
<?php $__env->startSection('style'); ?>
    <link href='https://cdn.jsdelivr.net/npm/froala-editor@latest/css/froala_editor.pkgd.min.css' rel='stylesheet' type='text/css' />
    <style>
        .btn-group .btn {
            margin-right: 8px;
        }
        .btn-group .btn:last-child {
            margin-right: 0;
        }
        .btn-warning.edit-btn:hover {
            background-color: #e0a800;
            color: white;
        }
        .btn-danger.btn-delete:hover {
            background-color: #c82333;
            color: white;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!--start page wrapper -->
    <div class="page-wrapper">
        <div class="page-content">
            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">
                    Right to Information Act
                </div>
                <div class="ps-3">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0 p-0">
                            <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a></li>
                            <li class="breadcrumb-item active" aria-current="page">Right to Information Act</li>
                        </ol>
                    </nav>
                </div>
                <div class="ms-auto">
                    <div class="btn-group">
                    </div>
                </div>
            </div>
            <!--end breadcrumb-->
            <div class="row">
                <div class="col-lg-4 mx-auto">
                    <div class="card">
                        <div class="card-header radius-15 bg-primary">
                            <div class="d-flex align-items-center">
                                <h6 class="mb-0 text-white">+ Right to Information Act</h6>
                            </div>
                        </div>
                        <div class="card-body">
                            <form enctype="multipart/form-data" id="SameForm">
                                <?php echo csrf_field(); ?>
                                <!-- Hidden ID -->
                                <input type="hidden" name="id" value="<?php echo e($member->id ?? ''); ?>">

                                <!-- Name -->
                                <div class="mb-3">
                                    <label for="name" class="form-label">Name</label>
                                    <input type="text" class="form-control" id="name" name="name"
                                        value="<?php echo e($member->name ?? ''); ?>" placeholder="Enter Right to Information Act name">
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <!-- Upload List -->
                                <div class="mb-3">
                                    <label for="listupload" class="form-label">Upload List (PDF / Image)</label>
                                    <input type="file" class="form-control" id="listupload" name="listupload">
                                    <?php if(isset($member) && $member->listupload): ?>
                                        <?php
                                            $ext = pathinfo($member->listupload, PATHINFO_EXTENSION);
                                        ?>
                                        <div class="mt-2">
                                            <?php if(in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'webp'])): ?>
                                                <img src="<?php echo e(asset('storage/' . $member->listupload)); ?>" width="150" alt="Uploaded Image">
                                            <?php elseif(strtolower($ext) === 'pdf'): ?>
                                                <a href="<?php echo e(asset('storage/' . $member->listupload)); ?>" target="_blank">View PDF</a>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php $__errorArgs = ['listupload'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <button type="submit" class="btn btn-primary">Save</button>
                            </form>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <!-- Display Success Message -->
                            <?php if(session('success')): ?>
                                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                            <?php endif; ?>
                            <!-- Display Errors -->
                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger">
                                    <ul>
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8 mx-auto">
                    <div class="card">
                        <div class="card-header radius-15 bg-primary">
                            <div class="d-flex align-items-center">
                                <h6 class="mb-0 text-white">Right to Information Act</h6>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table" id="example">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>Uploaded List</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- DataTables -->
    <script>
        $(function() {
            $('#example').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(route('mis.soochna.data')); ?>',
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex' },
                    { data: 'name', name: 'name' },
                    { data: 'listupload', name: 'listupload' },
                    { data: 'status', name: 'status' },
                    { data: 'actions', name: 'actions', orderable: false, searchable: false }
                ]
            });
        });

        $(document).ready(function() {
            $(document).on("submit", "#SameForm", function(e) {
                e.preventDefault();
                console.log("AJAX running...");

                let formData = new FormData(this);
                $.ajax({
                    url: "<?php echo e(route('mis.soochna.store')); ?>",
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(res) {
                        if (res.status == "add") {
                            $("#SameForm")[0].reset();
                            $('#example').DataTable().ajax.reload();
                        }

                        if (res.status == 'update') {
                            $('#example').DataTable().ajax.reload(null, false);
                            $("#SameForm")[0].reset();
                            $("#SameForm input[name='id']").val('');
                            $('#listupload-preview').remove();
                        }
                        toastr.success(res.msg);
                    },
                    error: function(xhr) {
                        let error = xhr.responseJSON.errors;
                        $.each(error, function(key, value) {
                            $(`.${key}`).html(value);
                            toastr.error(value);
                        });
                    }
                });
            });
        });

        $(document).on('click', '.edit-btn', function () {
            let id = $(this).data('id');
            $.ajax({
                url: `/mis/soochna/get/${id}`, 
                method: 'GET',
                success: function (data) {
                    $('#SameForm input[name="id"]').val(data.id);
                    $('#SameForm input[name="name"]').val(data.name);

                    if (data.listupload) {
                        let fileUrl = `/storage/${data.listupload}`;
                        let extension = fileUrl.split('.').pop().toLowerCase();
                        let previewHtml = '';

                        if (['jpg', 'jpeg', 'png', 'webp'].includes(extension)) {
                            previewHtml = `<img src="${fileUrl}" alt="Uploaded Image" width="150">`;
                        } else if (extension === 'pdf') {
                            previewHtml = `<a href="${fileUrl}" target="_blank">View PDF</a>`;
                        } else {
                            previewHtml = `<a href="${fileUrl}" target="_blank">View File</a>`;
                        }

                        $('#listupload-preview').remove();
                        $('#SameForm input[name="listupload"]').after(`
                            <div id="listupload-preview" class="mt-2">${previewHtml}</div>
                        `);
                    } else {
                        $('#listupload-preview').remove();
                    }
                },
                error: function () {
                    alert("Error loading data.");
                }
            });
        });

        // Status toggle
        $(document).on("click", ".btn-status", function() {
            let statusUrl = $(this).data("status");
            $.ajax({
                url: statusUrl,
                type: "GET",
                success: function(res) {
                    if (res.status == 'success') {
                        toastr.success(res.msg);
                    } else {
                        toastr.error(res.msg);
                    }
                    $('#example').DataTable().ajax.reload();
                }
            });
        });

        // Delete record
        $(document).on("click", ".btn-delete", function() {
            let delUrl = $(this).data("delid");
            $.ajax({
                url: delUrl,
                type: "GET",
                success: function(res) {
                    if (res.status === 1) {
                        toastr.success("Data has been deleted successfully");
                    } else {
                        toastr.error('Something went wrong');
                    }
                    $('#example').DataTable().ajax.reload();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.adminApp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/npgovardhan25/public_html/resources/views/mis/soochnakaadhikar/soochnakaadhikar.blade.php ENDPATH**/ ?>