<?php $__env->startSection('style'); ?>
<link href='https://cdn.jsdelivr.net/npm/froala-editor@latest/css/froala_editor.pkgd.min.css' rel='stylesheet' type='text/css' />

<style>
.btn-group .btn {
    margin-right: 8px;
}

.btn-group .btn:last-child {
    margin-right: 0;
}

.btn-warning.edit-btn:hover {
    background-color: #e0a800;
    color: white;
}

.btn-danger.btn-delete:hover {
    background-color: #c82333;
    color: white;
}
</style>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">All Wards  </div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page"> Wards </li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                </div>
            </div>
        </div>
        <!--end breadcrumb-->
        <div class="row">
            <?php if(has_permission(['Wards'], 'create')): ?>
            <div class="col-lg-4 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Add Wards</h6>
                        </div>
                    </div>
                    <div class="card-body">
                        
                        <form action="" method="POST" enctype="multipart/form-data" id="SameForm">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <input type="hidden"name="id" value="<?php echo e($ward->id ?? ''); ?>">
                                <label for="name" class="form-label">District</label>
                                <input type="text" class="form-control" id="ditrict" name="ditrict" value="<?php echo e($ward->ditrict ?? ''); ?>" >
                                <?php $__errorArgs = ['ditrict'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3">
                                <label for="name" class="form-label">Wards Name</label>
                                <input type="text" class="form-control" id="name" name="name" value="<?php echo e($ward->name ?? ''); ?>" >
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3">
                                <label for="name" class="form-label">Ward Number</label>
                                <input type="number" class="form-control" id="ward_number" name="ward_number" value="<?php echo e($ward->ward_number ?? ''); ?>" >
                                <?php $__errorArgs = ['ward_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <?php if(has_permission(['Wards'], 'status')): ?>
                            <div class="mb-3">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-control" id="status" name="status">
                                <option value="1" <?php echo e((isset($ward) && $ward->status == 1) ? 'selected' : ''); ?>>Active</option>
                                <option value="0" <?php echo e((isset($ward) && $ward->status == 0) ? 'selected' : ''); ?>>Inactive</option>
                                </select> 
                            </div>
                            <?php endif; ?>

                            <button type="submit" class="btn btn-primary">Save </button>
                            <a href="<?php echo e(route('gis.wards.index')); ?>" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <!-- Displaying Success Message -->
                        <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>

                        <!-- Displaying Error Messages -->
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <?php endif; ?>
            <?php if(has_permission(['Wards'], 'index')): ?>
            <div class="col-lg-8 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Wards List</h6>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="example">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Ward Name</th>
                                        <th>Ward Number</th>
                                        <th>Ditrict</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?> 
<script>
$(function () {
    $('#example').DataTable({
        processing: true,
        serverSide: true,
        ajax: '<?php echo e(route('gis.wards.index')); ?>',
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex' },
            { data: 'name', name: 'name' },
            { data: 'ward_number', name: 'ward_number' },
            { data: 'ditrict', name: 'ditrict' },
            { data: 'status', name: 'status' },
            { data: 'actions', name: 'actions', orderable: false, searchable: false }
        ]
    });
});


   $(document).ready(function () {
    $(document).on("submit", "#SameForm", function (e) {
        e.preventDefault();

        let formData = new FormData(this);
        $.ajax({
            url: "<?php echo e(route('gis.wards.store')); ?>",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: function (res) {
    if (res.status == "add") {
        $("#SameForm")[0].reset();
        $('#example').DataTable().ajax.reload();
    }

    if (res.status == 'update') {
        $('#example').DataTable().ajax.reload(null, false);  
        $("#SameForm")[0].reset();
        $("#SameForm input[name='id']").val('');
    }

    toastr.success(res.msg);
},
            error: function (xhr) {
                let error = xhr.responseJSON.errors;
                $.each(error, function (key, value) {
                    $(`.${key}`).html(value);
                    toastr.error(value);
                });
            }
        });
    });
});


$(document).on('click', '.edit-btn', function() {
    let id = $(this).data('id');
    $.ajax({
        url: `/gis/wards/${id}/edit`,  // AJAX URL for getting ward data
        method: 'GET',
        success: function(data) {
            // Form ko fill karo bina reload ke
            $('#SameForm input[name="id"]').val(data.id);
            $('#SameForm input[name="ditrict"]').val(data.ditrict);
            $('#SameForm input[name="name"]').val(data.name);
            $('#SameForm input[name="ward_number"]').val(data.ward_number);
            $('#SameForm select[name="status"]').val(data.status);
        },
        error: function() {
            alert('Data load karne me error aaya');
        }
    });
});


    $(document).on("click", ".btn-delete", function () {
                let delUrl = $(this).data("delid");
                $.ajax({
                    url: delUrl,
                    type: "POST",
                    success: function (res) {
                        if (res.status === 1) {
                            toastr.success("Data has been deleted successfully");
                        } else {
                            toastr.error('Something went wrong');
                        }
                         $('#example').DataTable().ajax.reload();
                    }
                })
            })


</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.adminApp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/npgovardhan25/public_html/resources/views/admin/wards.blade.php ENDPATH**/ ?>