
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Nagar Panchayat Bakewar</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
  <!-- Lightbox2 CSS -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/css/lightbox.min.css" rel="stylesheet">
   <link rel="stylesheet" href="<?php echo e(asset('')); ?>web/main.css">



  <style>
    /* ===== Topbar Unique Style ===== */
.top-bar {
  background: linear-gradient(270deg, #ff512f, #2490dd, #ffe02f);
  background-size: 600% 600%;
  animation: gradientBG 12s ease infinite;
  color: #fff;
  font-size: 14px;
  padding: 8px 0;
  position: relative;
  overflow: hidden;
  z-index: 1000;
}

/* Background animation */
@keyframes gradientBG {
  0% { background-position: 0% 50%; }
  50% { background-position: 100% 50%; }
  100% { background-position: 0% 50%; }
}

/* Contact Info */
.contact-info span {
  margin-right: 15px;
  display: flex;
  align-items: center;
}

.contact-info i {
  margin-right: 6px;
  color: #ffd369;
}

/* Social Icons */
.social-icons a {
  color: #fff;
  margin-left: 12px;
  font-size: 14px;
  width: 28px;
  height: 28px;
  display: inline-flex;
  align-items: center;
  justify-content: center;
  border-radius: 50%;
  background: rgba(255,255,255,0.1);
  transition: all 0.3s ease;
}

.social-icons a:hover {
  background: #ffd369;
  color: #222;
  transform: rotate(10deg) scale(1.15);
}

/* Language Selector */
.lang-select {
  border-radius: 20px;
  padding: 2px 10px;
  font-size: 13px;
  border: none;
  background: rgba(255,255,255,0.15);
  color: #fff;
  cursor: pointer;
}

.lang-select option {
  color: #000;
}

/* Responsive */
@media (max-width: 576px) {
  .top-bar .container {
    flex-direction: column;
    text-align: center;
  }
  .top-bar .contact-info {
    margin-bottom: 6px;
    justify-content: center;
  }
}
    /* ===== Navbar ===== */

    .navbar {
      background: #fff;
      box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
    }

    .navbar-brand {
      font-weight: 700;
      font-size: 16px;
      color: #000;
    }

    .navbar-nav .nav-link {
      font-size: 14px;
      font-weight: 500;
      max-width: 160px;
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      transition: all 0.2s ease-in-out;
    }

    .navbar-nav .nav-link:hover {
      white-space: normal;
      /* full text visible */
      background: #f8f9fa;
      border-radius: 5px;
      /* ❌ padding change mat karo */
    }

    @media (max-width: 1180px) {
      .navbar-nav .nav-link {
        max-width: none;
        /* responsive me koi limit nahi */
        white-space: normal;
        /* text line-break ho sakta hai */
        text-overflow: unset;
      }
    }


    /* Custom toggler icon */
    .navbar-toggler {
      border: none;
    }

    .navbar-toggler-icon {
      background-image: url("data:image/svg+xml;charset=utf8,%3Csvg viewBox='0 0 30 30' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath stroke='rgba%280,0,0,0.7%29' stroke-width='2' stroke-linecap='round' stroke-miterlimit='10' d='M4 7h22M4 15h22M4 23h22'/%3E%3C/svg%3E");
    }

    /* Dropdown hover effect */
    @media (min-width: 992px) {
      .navbar .dropdown:hover .dropdown-menu {
        display: block;
        margin-top: 0;
      }
    }

    /* ===== Responsive Fix ===== */
    @media (max-width: 576px) {
      .top-bar .container {
        flex-direction: column;
        text-align: center;
      }

      .top-bar .container>div {
        justify-content: center !important;
        margin-bottom: 5px;
      }

      .navbar-brand {
        font-size: 16px;
      }

      .navbar-brand img {
        height: 60px;
      }
    }

    /* <!-- ===== carousel ===== --> */
    .carousel-item img {
      width: 100%;
      height: 80vh;
      /* tum apni pasand se fix height set kar sakte ho */
      object-fit: cover;
      /* puri image dikhegi */

    }

    @media(max-width:768px) {
      .carousel-item img {
        height: 60vh;
        /* mobile ke liye chhoti height */
      }
    }


    /* News Section */
    .news-ticker {
      background: linear-gradient(90deg,#ef6640, #dd9783);
      /* blue gradient */
      overflow: hidden;
      position: relative;
    }

    .news-heading {
      background: rgba(0, 0, 0, 0.3);
      padding: 6px 12px;
      border-radius: 5px;
      font-size: 15px;
      font-weight: bold;
    }

    .ticker-wrap {
      overflow: hidden;
      position: relative;
      white-space: nowrap;
    }

    .ticker {
      display: inline-block;
      padding-left: 100%;
      animation: ticker 20s linear infinite;
    }

    .ticker-item {
      display: inline-block;
      margin-right: 50px;
      font-size: 14px;
      color: #fff;
    }

    .ticker-item:hover {
      animation-play-state: paused;
      cursor: pointer;
    }

    @keyframes ticker {
      0% {
        transform: translateX(0);
      }

      100% {
        transform: translateX(-100%);
      }
    }

    /* <!-- Chairman Section --> */
    /* Section Background */
    .chairman-section {
      background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
      position: relative;
      overflow: hidden;
    }

    /* Floating Animation */
    .animate-float {
      animation: float 3s ease-in-out infinite;
    }

    @keyframes float {
      0% {
        transform: translateY(0);
      }

      50% {
        transform: translateY(-8px);
      }

      100% {
        transform: translateY(0);
      }
    }

    /* Chairman Card */
    .chairman-card {
      background: #fff;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .chairman-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    }

    /* Message Box */
    .message-box {
      background: #fff;
      border-left: 6px solid #0d6efd;
      transition: all 0.3s ease;
    }

    .message-box:hover {
      transform: translateY(-5px);
      box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    }

    /* Decorative Line */
    .decor-line {
      position: absolute;
      top: 15px;
      left: -6px;
      width: 6px;
      height: 50px;
      background: linear-gradient(#0d6efd, #6610f2);
      border-radius: 5px;
      animation: growLine 2s infinite alternate;
    }

    @keyframes growLine {
      from {
        height: 30px;
      }

      to {
        height: 80px;
      }
    }

    .message-box p {
      text-align: justify;
    }



    /* Section Background */
    .about-modern {
      background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
      position: relative;
      overflow: hidden;
    }

    /* Content Box */
    .about-box {
      background: #fff;
      border-left: 6px solid #0d6efd;
      transition: all 0.3s ease;
    }

    .about-box:hover {
      transform: translateY(-6px);
      box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    }

    /* Underline Animation */
    .about-box h2 {
      position: relative;
      display: inline-block;
    }

    .about-box h2 .underline {
      position: absolute;
      left: 0;
      bottom: -5px;
      width: 0;
      height: 3px;
      background: linear-gradient(90deg, #0d6efd, #6610f2);
      transition: width 0.5s ease;
    }

    .about-box:hover h2 .underline {
      width: 100%;
    }

    /* Banner Image */
    .about-banner {
      position: relative;
      overflow: hidden;
    }

    .about-banner img {
      transition: transform 0.6s ease;
    }

    .about-banner:hover img {
      transform: scale(1.1);
    }

    /* Overlay */
    .banner-overlay {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0, 0, 0, 0.4);
      transition: all 0.4s ease;
    }

    .about-banner:hover .banner-overlay {
      background: rgba(0, 0, 0, 0.6);
    }

    /* Banner Text */
    .banner-text {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
    }


    /* Section Background */
    .departments-section {
      background: linear-gradient(135deg, #f9f9fb, #eef3ff);
      position: relative;
      overflow: hidden;
    }

    .departments-section::before {
      content: "";
      position: absolute;
      top: -80px;
      left: -80px;
      width: 250px;
      height: 250px;
      background: radial-gradient(circle, rgba(255, 105, 180, 0.3), transparent 70%);
      border-radius: 50%;
      z-index: 0;
    }

    .departments-section::after {
      content: "";
      position: absolute;
      bottom: -80px;
      right: -80px;
      width: 300px;
      height: 300px;
      background: radial-gradient(circle, rgba(0, 191, 255, 0.3), transparent 70%);
      border-radius: 50%;
      z-index: 0;
    }


    /* Department Card */
    .dept-card {
      position: relative;
      z-index: 1;
      background: #fff;
      border-radius: 20px;
      border-left: 6px solid #0d6efd;
      padding: 2rem 1.5rem;
      text-align: center;
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
      transition: all 0.4s ease;
    }

    .dept-card:hover {
      transform: translateY(-12px) scale(1.03);
      box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    }

    /* Icon Circle */
    .icon-circle {
      width: 110px;
      height: 110px;
      margin: 0 auto 1rem;
      border-radius: 50%;
      background: linear-gradient(135deg, #ef6640, #dd9783);
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 18px;
      box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
    }

    .icon-circle img {
      width: 200%;
      height: auto;
    }

    /* Title */
    .dept-card h5 {
      font-size: 1.25rem;
      font-weight: 700;
      margin-bottom: 0.8rem;
      color: #333;
    }

    /* Description */
    .dept-card p {
      font-size: 0.95rem;
      color: #555;
      min-height: 70px;
    }


    /* Our Services */
    /* Section background */
    .services-modern {
      background: linear-gradient(135deg, #f9f9fb, #eef3ff);
      position: relative;
      overflow: hidden;
    }

    .services-modern::before,
    .services-modern::after {
      content: "";
      position: absolute;
      border-radius: 50%;
      z-index: 0;
    }

    .services-modern::before {
      width: 280px;
      height: 280px;
      top: -80px;
      left: -80px;
      background: radial-gradient(circle, rgba(255, 105, 180, 0.25), transparent 70%);
    }

    .services-modern::after {
      width: 320px;
      height: 320px;
      bottom: -90px;
      right: -90px;
      background: radial-gradient(circle, rgba(0, 191, 255, 0.25), transparent 70%);
    }


    /* Card modern */
    .service-card-modern {
      position: relative;
      overflow: hidden;
      border-radius: 20px;
      height: 280px;
      display: flex;
      align-items: flex-end;
      justify-content: center;
      color: #fff;
      text-align: center;
      transition: all 0.4s ease;
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    }

    .service-card-modern:hover {
      transform: translateY(-12px) scale(1.03);
      box-shadow: 0 20px 45px rgba(0, 0, 0, 0.2);
    }

    /* Background Image */
    .card-bg {
      position: absolute;
      inset: 0;
      background-size: cover;
      background-position: center;
      transition: transform 0.6s ease;
      z-index: 0;
    }

    .service-card-modern:hover .card-bg {
      transform: scale(1.15);
    }

    /* Overlay */
    .card-overlay {
      position: absolute;
      inset: 0;
      background: linear-gradient(180deg, rgba(0, 0, 0, 0.25), rgba(0, 0, 0, 0.75));
      z-index: 1;
      transition: background 0.4s ease;
    }

    .service-card-modern:hover .card-overlay {
      background: linear-gradient(180deg, rgba(0, 0, 0, 0.15), rgba(0, 0, 0, 0.85));
    }

    /* Content */
    .card-content {
      position: relative;
      z-index: 2;
      padding: 1.5rem;
    }

    .card-content h4 {
      font-size: 1.3rem;
      font-weight: 700;
      margin-bottom: 0.4rem;
    }

    .card-content p {
      font-size: 1rem;
      margin-bottom: 0.8rem;
    }

    .card-content a {
      color: #ffb347;
      font-weight: 600;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .card-content a:hover {
      color: #ffd166;
    }

    /* grievance  */
    .public-grievance {
      background: linear-gradient(135deg, #f8fbff, #eef4fa);
      position: relative;
      overflow: hidden;
    }

    .public-grievance::before {
      content: "";
      position: absolute;
      width: 250px;
      height: 250px;
      background: radial-gradient(circle, #0077ff33, transparent 70%);
      top: -60px;
      left: -60px;
      border-radius: 50%;
    }

    .public-grievance::after {
      content: "";
      position: absolute;
      width: 300px;
      height: 300px;
      background: radial-gradient(circle, #00c6ff33, transparent 70%);
      bottom: -80px;
      right: -80px;
      border-radius: 50%;
    }

    .grievance-card {
      background: rgba(255, 255, 255, 0.9);
      backdrop-filter: blur(12px);
      border-radius: 20px;
      box-shadow: 0 8px 24px rgba(0, 0, 0, 0.08);
      transition: transform 0.3s ease;
    }

    .grievance-card:hover {
      transform: translateY(-6px);
    }

    


    .message-text {
      font-size: 1rem;
      color: #555;
      line-height: 1.7;
      text-align: justify;
    }

    .btn-modern {
      padding: 12px 28px;
      font-size: 1rem;
      font-weight: 600;
      color: #fff;
      border: none;
      border-radius: 30px;
      background: linear-gradient(135deg, #ef6640, #dd9783);
      box-shadow: 0 6px 18px rgba(0, 119, 255, 0.3);
      transition: all 0.3s ease;
    }

    .btn-modern:hover {
      transform: translateY(-3px);
      box-shadow: 0 8px 22px rgba(0, 119, 255, 0.45);
    }

    .grievance-img-wrapper {
      position: relative;
      overflow: hidden;
      border-radius: 20px;
    }

    .grievance-img-wrapper img {
      transition: transform 0.6s ease;
    }

    .grievance-img-wrapper:hover img {
      transform: scale(1.08);
    }

    .grievance-overlay {
      position: absolute;
      inset: 0;
      background: linear-gradient(135deg, rgba(0, 119, 255, 0.25), rgba(0, 198, 255, 0.25));
      opacity: 0;
      transition: opacity 0.4s ease;
      border-radius: 20px;
    }

    .grievance-img-wrapper:hover .grievance-overlay {
      opacity: 1;
    }

    /* Modal Improvements */
    .modal-content {
      border-radius: 20px;
    }

    .modal-title {
      font-size: 1.25rem;
    }


    /* yojana */
    .yojana-section {
      background: linear-gradient(135deg, #f8fbff, #eef4fa);
      position: relative;
      overflow: hidden;
      
    }

    .yojana-section::before,
    .yojana-section::after {
      content: "";
      position: absolute;
      border-radius: 50%;
      filter: blur(80px);
      opacity: 0.5;
    }

    .yojana-section::before {
      width: 250px;
      height: 250px;
      background: #0077ff44;
      top: -60px;
      left: -60px;
    }

    .yojana-section::after {
      width: 300px;
      height: 300px;
      background: #00c6ff44;
      bottom: -80px;
      right: -80px;
    }

    .yojana-heading {
            font-size: 2rem;
      position: relative;
      display: inline-block;
    }

    .yojana-heading::after {
      content: "";
      position: absolute;
      left: 50%;
      bottom: -8px;
      transform: translateX(-50%);
      width: 80px;
      height: 3px;
      background: linear-gradient(90deg, #0077ff, #00c6ff);
      border-radius: 3px;
    }

    .yojana-card {
      background: rgba(255, 255, 255, 0.9);
      backdrop-filter: blur(10px);
      border-radius: 20px;
      padding: 25px 20px;
      box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
      transition: transform 0.4s ease, box-shadow 0.4s ease;
        border-left: 6px solid #0d6efd;
    }

    .yojana-card:hover {
      transform: translateY(-8px) scale(1.02);
      box-shadow: 0 12px 28px rgba(0, 0, 0, 0.15);
    }

    .yojana-card h5 {
      margin-top: 15px;
      font-weight: 600;
      color: #2c3e50;
    }

    .yojana-card p {
      color: #666;
      font-size: 0.95rem;
      min-height: 50px;
    }

    .icon-box {
      width: 120px;
      height: 120px;
      margin: 0 auto;
      border-radius: 30%;
      /* background: linear-gradient(135deg, #0077ff, #00c6ff); */
      display: flex;
      align-items: center;
      justify-content: center;
      box-shadow: 0 6px 16px rgba(0, 119, 255, 0.25);
      padding: 5px;
    }

    .icon-box img {
      width: 100%;
      height: auto;
      border-radius: 30%;
      object-fit: cover;
    }
     #img333 {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;

    }

    
  


    .btn-modern {
      display: inline-block;
      margin-top: 15px;
      padding: 10px 22px;
      font-size: 0.9rem;
      font-weight: 600;
      border-radius: 25px;
      background: linear-gradient(135deg, #0077ff, #00c6ff);
      color: #fff;
      text-decoration: none;
      transition: all 0.3s ease;
      box-shadow: 0 6px 18px rgba(0, 119, 255, 0.3);
    }

    .btn-modern:hover {
      transform: translateY(-3px);
      box-shadow: 0 8px 24px rgba(0, 119, 255, 0.5);
    }

    /* gallery */
     .gallery-section {
      background: #d6deef;
      font-family: 'Segoe UI', sans-serif;
    }
    
    .gallery-section p {
      color: #6c757d;
      margin-bottom: 2rem;
    }

    .gallery-item {
      position: relative;
      overflow: hidden;
      border-radius: 15px;
      box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
      cursor: pointer;
      transition: transform 0.3s ease;
    }

    .gallery-item:hover {
      transform: translateY(-5px);
    }

    .gallery-item img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      transition: transform 0.4s ease;
    }

    .gallery-item:hover img {
      transform: scale(1.1);
    }

    .gallery-overlay {
      position: absolute;
      inset: 0;
      background: rgba(0, 0, 0, 0.5);
      display: flex;
      align-items: center;
      justify-content: center;
      opacity: 0;
      transition: opacity 0.3s ease;
    }

    .gallery-item:hover .gallery-overlay {
      opacity: 1;
    }

    .gallery-overlay i {
      color: #fff;
      font-size: 2rem;
    }

 /* event  */
    .events-news h2 .underline {
    position: absolute;
    bottom: -8px; left: 50%;
    transform: translateX(-50%);
    width: 60px; height: 3px;
    background: linear-gradient(90deg,#0072ff,#00c6ff);
    border-radius: 5px;
    animation: slideWidth 2s infinite alternate;
  }
  @keyframes slideWidth {
    from { width: 40px; }
    to { width: 100px; }
  }
  .event-card {
    background: #fff;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 8px 20px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
  }
  .event-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 12px 28px rgba(0,0,0,0.15);
  }
  .event-img {
    position: relative;
    height: 220px;
    overflow: hidden;
  }
  .event-img img {
    width: 100%; height: 100%;
    object-fit: cover;
    transition: transform 0.4s ease;
  }
  .event-card:hover .event-img img {
    transform: scale(1.1);
  }
  .date-badge {
    position: absolute;
    top: 12px; left: 12px;
    background: linear-gradient(135deg,#ef6640, #dd9783);
    color: #fff;
    font-size: 0.85rem;
    font-weight: 600;
    padding: 5px 12px;
    border-radius: 50px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.15);
  }
  .event-body {
    padding: 1rem 1.2rem;
  }
  .event-body h5 {
    font-weight: 600;
    color: #0072ff;
    margin-bottom: 0.5rem;
  }
  .event-body p {
    margin: 0;
    color: #555;
    font-size: 0.95rem;
  }
  

  /* staff */
  .staff-section h2 .underline {
    position: absolute;
    bottom: -8px; left: 50%;
    transform: translateX(-50%);
    width: 60px; height: 3px;
    background: linear-gradient(90deg,#0072ff,#00c6ff);
    border-radius: 5px;
    animation: slideWidth 2s infinite alternate;
  }
  @keyframes slideWidth {
    from { width: 40px; }
    to { width: 100px; }
  }
  .staff-card {
    background: #fff;
    border-radius: 20px;
    overflow: hidden;
    text-align: center;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    box-shadow: 0 8px 18px rgba(0,0,0,0.08);
  }
  .staff-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 12px 28px rgba(0,0,0,0.15);
  }
  .staff-img {
    position: relative;
    width: 100%;
    height: 220px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #f3f6fa;
    overflow: hidden;
  }
  .staff-img img {
    width: 120px; height: 120px;
    object-fit: cover;
    border-radius: 50%;
    transition: transform 0.4s ease;
  }
  .staff-card:hover .staff-img img {
    transform: scale(1.1);
  }
  .staff-overlay {
    position: absolute;
    inset: 0;
    background: rgba(232, 102, 66, 0.85);
    color: #fff;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: opacity 0.3s ease;
    text-align: center;
    font-size: 0.9rem;
  }
  .staff-card:hover .staff-overlay {
    opacity: 1;
  }
  .staff-overlay i {
    margin-right: 6px;
  }
  .staff-info {
    padding: 1rem;
  }
  .staff-info h5 {
    margin-bottom: 0.3rem;
    font-weight: 600;
    color: #0072ff;
  }
  .staff-info p {
    margin: 0;
    color: #555;
    font-size: 0.9rem;
  }

  /* download */
  .form-card {
    transition: all 0.3s ease;
    background: #fff;
  }
  .form-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
  }
  .icon-circle {
    width: 70px;
    height: 70px;
    background: #f8f9fa;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: background 0.3s;
  }
  .form-card:hover .icon-circle {
    background: #ffecec;
  }
  .download-btn {
    background: #dc3545;
    color: #fff;
    font-weight: 600;
    border-radius: 30px;
    transition: 0.3s;
  }
  .download-btn:hover {
    background: #b02a37;
    color: #fff;
    transform: scale(1.05);
  }

  /* Feedback */
  #feedback{
    background-color:#f2f6fe;
  }
     #feedback .form-control {
    border: 1px solid #ddd;
    padding: 10px 14px;
    transition: border 0.3s, box-shadow 0.3s;
  }
  #feedback .form-control:focus {
    border-color: #28a745;
    box-shadow: 0 0 6px rgba(40, 167, 69, 0.3);
  }
  #feedback h2 {
    color: #2c3e50;
  }
  #feedback button {
    font-weight: 600;
    transition: 0.3s;
  }
  #feedback button:hover {
    transform: scale(1.05);
  }

     /* contact us  */
  .contact-section {
      padding: 60px 0;
    }

    .contact-card {
      display: flex;
      align-items: center;
      gap: 20px;
      padding: 20px;
      border-radius: 16px;
      background: rgba(255, 255, 255, 0.8);
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
      backdrop-filter: blur(10px);
      transition: all 0.3s ease-in-out;
    }

    .contact-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 12px 28px rgba(0, 0, 0, 0.12);
    }

    .contact-icon {
      width: 55px;
      height: 55px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 22px;
      color: #fff;
      transition: all 0.3s ease;
      flex-shrink: 0;
    }

    .contact-card:hover .contact-icon {
      transform: scale(1.15);
      box-shadow: 0 0 15px rgba(0,0,0,0.2);
    }

    .contact-info h5 {
      font-weight: 600;
      margin-bottom: 5px;
    }

    iframe {
      border: none;
      border-radius: 16px;
      width: 100%;
      height: 350px;
    }

    /* footer  */
    .footer {
  background: linear-gradient(to right, #ef6640, #dd9783);
  color: #fff;
  padding: 60px 0 20px;
  position: relative;
  overflow: hidden;
}
.footer h5 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 20px;
  position: relative;
}
.footer h5::after {
  content: "";
  width: 40px;
  height: 2px;
  background: #0d6efd;
  position: absolute;
  left: 0;
  bottom: -8px;
}
.footer-list {
  list-style: none;
  padding: 0;
}
.footer-list li {
  margin-bottom: 10px;
  font-size: 14px;
}
.footer-list li a {
  color: #fff;
  font-weight: 600;
  text-decoration: none;
  transition: all 0.3s;
}
.footer-list li a:hover {
  color: black;
  padding-left: 5px;
}
.social-links a {
  display: inline-block;
  width: 36px;
  height: 36px;
  margin: 0 5px;
  background: rgba(255,255,255,0.05);
  color: #fff;
  border-radius: 50%;
  text-align: center;
  line-height: 36px;
  transition: 0.3s;
}
.social-links a:hover {
  background: black;
  transform: translateY(-3px);
}
.footer-bottom {
  margin-top: 30px;
  font-size: 13px;
  color: #aaa;
}
.footer-bottom .visitors {
  color: #ffcc00;
  font-weight: bold;
}
.animate {
  opacity: 0;
  transform: translateY(30px);
  transition: all 0.6s ease;
}
.animate.show {
  opacity: 1;
  transform: translateY(0);
}
  </style>
</head>

<body>

 <!-- ===== Top Bar ===== -->
<div class="top-bar">
  <div class="container d-flex flex-wrap justify-content-between align-items-center">
    
    <!-- Left: Contact Info -->
    <div class="d-flex flex-wrap align-items-center contact-info">
      <span><i class="fa fa-phone"></i> +91-1234567890</span>
      <span class="ms-3"><i class="fa fa-envelope"></i> info@Bakewarnp.in</span>
    </div>
    
    <!-- Right: Social + Language -->
    <div class="d-flex align-items-center mt-2 mt-sm-0">
      <div class="social-icons d-flex">
        <a href="#"><i class="fab fa-facebook-f"></i></a>
        <a href="#"><i class="fab fa-twitter"></i></a>
        <a href="#"><i class="fab fa-instagram"></i></a>
      </div>
      <select class="form-select form-select-sm ms-3 lang-select">
        <option>English</option>
        <option>हिन्दी</option>
      </select>
    </div>
  </div>
</div>
  <!-- ===== Navbar ===== -->
  <nav class="navbar navbar-expand-lg">
    <div class="container">
      <a class="navbar-brand d-flex align-items-center" href="#">
        <img src="<?php echo e(asset('')); ?>web/image/logo.png" alt="Logo" height="80" class="me-2">
        <span>
          <strong class="text-danger">Nagar Panchayat Bakewar</strong><br>Etawah, Uttar Pradesh
        </span>
      </a>
      <button class="navbar-toggler ms-auto" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
        <ul class="navbar-nav">
          <li class="nav-item"><a class="nav-link active" href="#">Home</a></li>

          <!-- Dropdown: About Us -->
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">About Us</a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="#">History</a></li>
              <li><a class="dropdown-item" href="#">Vision & Mission</a></li>
              <li><a class="dropdown-item" href="#">Officials</a></li>
            </ul>
          </li>

          <li class="nav-item"><a class="nav-link" href="#">Online House Tax Payment</a></li>

          <!-- Dropdown: Departments -->
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">Departments</a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="#">Health Department</a></li>
              <li><a class="dropdown-item" href="#">Engineering Department</a></li>
              <li><a class="dropdown-item" href="#">Finance Department</a></li>
            </ul>
          </li>

          <li class="nav-item"><a class="nav-link" href="#">E-Tendering</a></li>

          <!-- Dropdown: Right to Information -->
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">Right to Information</a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="#">RTI Act</a></li>
              <li><a class="dropdown-item" href="#">Application Procedure</a></li>
              <li><a class="dropdown-item" href="#">FAQs</a></li>
            </ul>
          </li>

          <!-- Dropdown: Gallery -->
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">Gallery</a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="#">Photo Gallery</a></li>
              <li><a class="dropdown-item" href="#">Video Gallery</a></li>
            </ul>
          </li>
        </ul>
      </div>
    </div>
  </nav>

  <!-- ===== carousel ===== -->
  <div id="carouselExampleAutoplaying" class="carousel slide" data-bs-ride="carousel">
    <div class="carousel-inner">
      <div class="carousel-item active">
        <img src="https://i.pinimg.com/736x/d9/34/79/d93479e461b130c067b9b7696be460c3.jpg" class="d-block w-100 "
          alt="...">
      </div>
      <div class="carousel-item">
        <img src="https://i.pinimg.com/1200x/39/25/1b/39251bcddc068c1875d8bdc74def196b.jpg" class="d-block w-100"
          alt="...">
      </div>

    </div>
    <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleAutoplaying"
      data-bs-slide="prev">
      <span class="carousel-control-prev-icon" aria-hidden="true"></span>
      <span class="visually-hidden">Previous</span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleAutoplaying"
      data-bs-slide="next">
      <span class="carousel-control-next-icon" aria-hidden="true"></span>
      <span class="visually-hidden">Next</span>
    </button>
  </div>

  <!-- News Ticker Section -->
  <section class="news-ticker py-2">
    <div class="container-fluid d-flex align-items-center">
      <!-- Left Heading -->
      <div class="news-heading px-3 d-flex align-items-center text-white">
        <i class="bi bi-megaphone-fill me-2"></i> <strong>Latest Updates</strong>
      </div>

      <!-- Scrolling News -->
      <div class="ticker-wrap flex-grow-1">
        <div class="ticker">
          <div class="ticker-item">
            <span class="badge bg-danger text-white me-2">NEW</span>
            Nagar Panchayat Bakewar || Date: 18-08-2025 11:43:50 AM
          </div>
          <div class="ticker-item">
            <span class="badge bg-success text-white me-2">UPDATE</span>
            Cleanliness drive will start from 20th August
          </div>
          <div class="ticker-item">
            <span class="badge bg-warning text-dark me-2">INFO</span>
            Online bill payment service is now available
          </div>
          <div class="ticker-item">
            <span class="badge bg-danger text-white me-2">ALERT</span>
            Water supply will remain disrupted from 7 AM
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Chairman Section -->
  <section class="chairman-section py-5">
    <div class="container">
      <div class="row g-5 align-items-center">

        <!-- Left Side (Profile Card) -->
        <div class="col-lg-4 col-md-5">
          <div class="chairman-card text-center shadow-lg p-4 rounded-4 bg-white animate-float">
            <div class="chairman-photo mb-3">
              <img src="https://cdn-icons-png.flaticon.com/512/3135/3135715.png"
                class="img-fluid rounded-circle border border-4 border-danger shadow" alt="Chairman">
            </div>
            <h5 class="fw-bold text-dark mb-1">Shri [Chairman Name]</h5>
            <p class="text-muted small mb-0">Chairman</p>
            <p class="text-muted small">Nagar Panchayat Bakewar Uttar Pradesh</p>
          </div>
        </div>

        <!-- Right Side (Message Content) -->
        <div class="col-lg-8 col-md-7">
          <div class="message-box p-5 rounded-4 position-relative shadow-lg">
            <span class="decor-line"></span>
            <h2 class="fw-bold text-danger-emphasis mb-4">Chairman’s Message</h2>
            <p class="text-dark fs-6">
              I am honored to serve the people of Bakewar  as the Chairman of Nagar Panchayat.
              Our goal is to ensure the delivery of efficient and transparent public services
              to every citizen. With the cooperation of the people and the dedication of our staff,
              we aim to make Bakewar  a model town with improved infrastructure, sanitation,
              and digital governance. Let us work together for the betterment of our Nagar Panchayat
              and create a bright future for coming generations.
            </p>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- About Section -->
  <section class="about-modern py-5">
    <div class="container">
      <div class="row align-items-center g-5">

        <!-- Left Content -->
        <div class="col-lg-6" data-aos="fade-right" data-aos-duration="1200">
          <div class="about-box p-4 rounded-4 shadow-lg">
            <h2 class="fw-bold text-danger-emphasis mb-4 position-relative">
              About Nagar Panchayat Bakewar Bakewar
              <span class="underline"></span>
            </h2>

            
            <p class="text-dark fs-6 lh-lg">
              Nagar Panchayat Bakewar  is an urban local body located in the Uttar Pradesh.
              It plays a vital role in providing civic services such as sanitation, water supply, street lighting,
              solid waste management, birth and death registration, and local infrastructure development.
              With a vision of transparent and efficient governance, Nagar Panchayat Bakewar  is committed to
              enhancing the quality of life for its residents by delivering public services in a citizen-friendly
              manner.
            </p>
          </div>
        </div>

        <!-- Right Image Banner -->
        <div class="col-lg-6" data-aos="fade-left" data-aos-duration="1200">
          <div class="about-banner position-relative rounded-4 overflow-hidden shadow-lg">
            <img src="https://i.pinimg.com/1200x/ee/c1/c9/eec1c98b6ad057206219c99d562a9f57.jpg" class="img-fluid w-100"
              alt="About Bakewar ">
            <div class="banner-overlay"></div>
            <div class="banner-text text-white text-center">
              <h4 class="fw-bold" data-aos="zoom-in" data-aos-delay="300">Nagar Panchayat Bakewar </h4>
              <p class="mb-0" data-aos="zoom-in" data-aos-delay="500">Uttar Pradesh</p>
            </div>
          </div>
        </div>

      </div>
    </div>
  </section>


  <!-- Departments Section -->
  <section class="departments-section py-5">
    <div class="container text-center mb-5" data-aos="fade-up">
      <h2 class="fw-bold text-danger-emphasis">Departments</h2>
      <p class="text-muted fw-bold">
        Various departments under Nagar Panchayat Bakewar Uttar Pradesh are dedicated to providing
        public services and maintaining the city's infrastructure.
      </p>
    </div>

    <div class="container">
      <div class="row g-4">

        <!-- Department 1 -->
        <div class="col-md-6 col-lg-4" data-aos="zoom-in" data-aos-delay="100">
          <div class="dept-card">
            <div class="icon-circle">
              <img src="<?php echo e(asset('')); ?>web/image/D1.png" alt="PWD">
            </div>
            <h5>Public Works Department</h5>
            <p>This department is responsible for road construction, building repairs, and other public construction
              works.</p>
          </div>
        </div>

        <!-- Department 2 -->
        <div class="col-md-6 col-lg-4" data-aos="zoom-in" data-aos-delay="200">
          <div class="dept-card">
            <div class="icon-circle">
              <img src="<?php echo e(asset('')); ?>web/image/D2.png" alt="IT">
            </div>
            <h5>IT Department</h5>
            <p>This department is responsible for all online services and technological development of the Nagar
              Panchayat.</p>
          </div>
        </div>

        <!-- Department 3 -->
        <div class="col-md-6 col-lg-4" data-aos="zoom-in" data-aos-delay="200">
          <div class="dept-card">
            <div class="icon-circle">
              <img src="<?php echo e(asset('')); ?>web/image/D3.png" alt="Property Tax">
            </div>
            <h5>Property Tax</h5>
            <p>This department is responsible for property tax collection and management of related records.</p>
          </div>
        </div>

        <!-- Department 4 -->
        <div class="col-md-6 col-lg-4" data-aos="zoom-in" data-aos-delay="300">
          <div class="dept-card">
            <div class="icon-circle">
              <img src="<?php echo e(asset('')); ?>web/image/D4.png" alt="Health">
            </div>
            <h5>Health Department</h5>
            <p>This department ensures cleanliness, health services, and prevention of diseases in the municipal area.
            </p>
          </div>
        </div>

        <!-- Department 5 -->
        <div class="col-md-6 col-lg-4" data-aos="zoom-in" data-aos-delay="400">
          <div class="dept-card">
            <div class="icon-circle">
              <img src="<?php echo e(asset('')); ?>web/image/D5.png" alt="Street Light">
            </div>
            <h5>Street Light</h5>
            <p>This department is responsible for maintaining street lighting and installing new lights.</p>
          </div>
        </div>

        <!-- Department 6 -->
        <div class="col-md-6 col-lg-4" data-aos="zoom-in" data-aos-delay="500">
          <div class="dept-card">
            <div class="icon-circle">
              <img src="<?php echo e(asset('')); ?>web/image/D6.png" alt="Water Supply">
            </div>
            <h5>Water Supply Department</h5>
            <p>This department provides clean drinking water to all households and establishments in the city.</p>
          </div>
        </div>

        <!-- Department 7 -->
        <div class="col-md-6 col-lg-4" data-aos="zoom-in" data-aos-delay="600">
          <div class="dept-card">
            <div class="icon-circle">
              <img src="<?php echo e(asset('')); ?>web/image/OS1.png" alt="Law Department">
            </div>
            <h5>Law Department</h5>
            <p>This department oversees legal advice, court cases, and compliance with administrative laws.</p>
          </div>
        </div>

        <!-- Department 8 -->
        <div class="col-md-6 col-lg-4" data-aos="zoom-in" data-aos-delay="600">
          <div class="dept-card">
            <div class="icon-circle">
              <img src="<?php echo e(asset('')); ?>web/image/D7.png" alt="Establishment">
            </div>
            <h5>Establishment</h5>
            <p>This department manages staff recruitment, salaries, and office procedures.</p>
          </div>
        </div>

        <!-- Department 9 -->
        <div class="col-md-6 col-lg-4" data-aos="zoom-in" data-aos-delay="600">
          <div class="dept-card">
            <div class="icon-circle">
              <img src="<?php echo e(asset('')); ?>web/image/D8.png" alt="Garden">
            </div>
            <h5>Garden / Horticulture</h5>
            <p>The maintenance of city gardens and efforts to increase greenery come under this department.</p>
          </div>
        </div>

      </div>
    </div>

  </section>

  <!-- Our Services Section -->
  <section class="services-modern py-5">
    <div class="container text-center mb-5" data-aos="fade-up">
      <h2 class="fw-bold text-danger-emphasis">OUR SERVICES</h2>
      <p class="text-muted fw-bold">
        Nagar Panchayat Bakewar Uttar Pradesh is committed to providing transparent, accessible,
        and citizen-centric services for the benefit of all residents.
      </p>
    </div>

    <div class="container">
      <div class="swiper servicesSwiper">
        <div class="swiper-wrapper">

          <!-- Slide 1 -->
          <div class="swiper-slide">
            <div class="service-card-modern">
              <div class="card-bg" style="background-image: url('<?php echo e(asset('')); ?>web/image/OS1.png');"></div>
              <div class="card-overlay"></div>
              <div class="card-content">
                <h4>E-Tender</h4>

                <a href="#">Read More →</a>
              </div>
            </div>
          </div>

          <!-- Slide 2 -->
          <div class="swiper-slide">
            <div class="service-card-modern">
              <div class="card-bg" style="background-image: url('<?php echo e(asset('')); ?>web/image/OS2.png');"></div>
              <div class="card-overlay"></div>
              <div class="card-content">
                <h4>Public Grievance</h4>

                <a href="#">Read More →</a>
              </div>
            </div>
          </div>

          <!-- Slide 3 -->
          <div class="swiper-slide">
            <div class="service-card-modern">
              <div class="card-bg" style="background-image: url('<?php echo e(asset('')); ?>web/image/OS3.png');"></div>
              <div class="card-overlay"></div>
              <div class="card-content">
                <h4>RTI</h4>

                <a href="#">Read More →</a>
              </div>
            </div>
          </div>

          <!-- Slide 4 -->
          <div class="swiper-slide">
            <div class="service-card-modern">
              <div class="card-bg" style="background-image: url('<?php echo e(asset('')); ?>web/image/OS4.png');"></div>
              <div class="card-overlay"></div>
              <div class="card-content">
                <h4>Zones / Wards</h4>

                <a href="#">Read More →</a>
              </div>
            </div>
          </div>

          <!-- Slide 5 -->
          <div class="swiper-slide">
            <div class="service-card-modern">
              <div class="card-bg" style="background-image: url('<?php echo e(asset('')); ?>web/image/OS5.png');"></div>
              <div class="card-overlay"></div>
              <div class="card-content">
                <h4>Citizen Charter</h4>

                <a href="#">Read More →</a>
              </div>
            </div>
          </div>

          <!-- Slide 6 -->
          <div class="swiper-slide">
            <div class="service-card-modern">
              <div class="card-bg" style="background-image: url('<?php echo e(asset('')); ?>web/image/OS6.png');"></div>
              <div class="card-overlay"></div>
              <div class="card-content">
                <h4>Property Tax</h4>

                <a href="#">Read More →</a>
              </div>
            </div>
          </div>

          <!-- Slide 7 -->
          <div class="swiper-slide">
            <div class="service-card-modern">
              <div class="card-bg" style="background-image: url('<?php echo e(asset('')); ?>web/image/OS7.png');"></div>
              <div class="card-overlay"></div>
              <div class="card-content">
                <h4>Birth / Death Certificate</h4>

                <a href="#">Read More →</a>
              </div>
            </div>
          </div>

        </div>

        <!-- Navigation -->
        <div class="swiper-button-next"></div>
        <div class="swiper-button-prev"></div>
        <div class="swiper-pagination"></div>
      </div>
    </div>
  </section>


  <!-- Public Grievance Section -->
  <section class="public-grievance py-5 position-relative">
    <div class="container">
      <div class="row align-items-center g-5">

        <!-- Left Content -->
        <div class="col-lg-6">
          <div class="grievance-card p-4" data-aos="fade-up" data-aos-duration="1200">
            <h2 class="text-danger-emphasis fw-bold mb-3">
              Public Grievance
            </h2>
            <p class="message-text">
              Nagar Panchayat Bakewar  is committed to addressing the concerns and grievances of its citizens.
              We encourage residents to report issues related to sanitation, water supply, roads, street lighting,
              and other civic matters. Your feedback helps us improve. Click the button below to register your
              grievance.
            </p>

            <!-- Button -->
            <div class="mt-4">
              <button type="button" class="btn-modern" data-bs-toggle="modal" data-bs-target="#grievanceModal">
                Submit Grievance
              </button>
            </div>
          </div>
        </div>

        <!-- Right Image -->
        <div class="col-lg-6">
          <div class="grievance-img-wrapper" data-aos="zoom-in" data-aos-delay="200">
            <img src="<?php echo e(asset('')); ?>web/image/grievance.jpg" class="img-fluid rounded-4 shadow-lg" alt="grievance">
            <div class="grievance-overlay"></div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Yojana Section -->
   <section class="yojana-section py-5 position-relative">
    <div class="container text-center">
      <!-- Heading -->
      <h2 class="yojana-heading fw-bold mb-3 text-primary" data-aos="zoom-in">
        Government Schemes
        
      </h2>
      <p class="text-muted mb-5" data-aos="fade-up" data-aos-delay="200">
        Citizen-centric schemes implemented by Nagar Panchayat Govardhan,mathura.
      </p>

      <!-- Cards -->
      <div class="row g-4 justify-content-center">

        <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="100">
          <div class="yojana-card h-100">
            <div class="icon-box">
              <img src="<?php echo e(asset('')); ?>web/image/Y1.png" alt="PM Awas Yojana">
            </div>
            <h5>PM Awas Yojana</h5>
            <p>Affordable housing for the urban poor.</p>
            <a href="#" class="btn-modern">Read more →</a>
          </div>
        </div>

        <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="200">
          <div class="yojana-card h-100">
            <div class="icon-box">
              <img src="<?php echo e(asset('')); ?>web/image/Y2.png" alt="Swachh Bharat Mission">
            </div>
            <h5>Swachh Bharat Mission</h5>
            <p>Cleanliness and sanitation for all.</p>
            <a href="#" class="btn-modern">Read more →</a>
          </div>
        </div>

        <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="300">
          <div class="yojana-card h-100">
            <div class="icon-box">
              <img id="img333" src="<?php echo e(asset('')); ?>web/image/Y3.jpg" alt="NULM">
            </div>
            <h5>NULM</h5>
            <p>Skill training and livelihood for urban poor.</p>
            <a href="#" class="btn-modern">Read more →</a>
          </div>
        </div>

        <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="400">
          <div class="yojana-card h-100">
            <div class="icon-box">
              <img src="<?php echo e(asset('')); ?>web/image/Y4.jpg" alt="Jal Jeevan Mission">
            </div>
            <h5>Jal Jeevan Mission</h5>
            <p>Tap water for every household.</p>
            <a href="#" class="btn-modern">Read more →</a>
          </div>
        </div>

      </div>
    </div>
  </section>


  <!-- ===== Gallery Section Start ===== -->
  <section class="gallery-section py-5">
    <div class="container text-center">
      <h2 class="text-danger-emphasis fw-bold">Photo / Media Gallery</h2>
      <p>Important moments and events of Nagar Panchayat Bakewar Uttar Pradesh.</p>

      <div class="row g-4">
        <!-- Gallery Item -->
        <div class="col-lg-4 col-md-6">
          <div class="gallery-item" data-bs-toggle="modal" data-bs-target="#lightboxModal" data-img="<?php echo e(asset('')); ?>web/image/E5.jpg">
            <img src="<?php echo e(asset('')); ?>web/image/E5.jpg" alt="Gallery 1">
            <div class="gallery-overlay"><i class="bi bi-arrows-fullscreen"></i></div>
          </div>
        </div>

        <div class="col-lg-4 col-md-6">
          <div class="gallery-item" data-bs-toggle="modal" data-bs-target="#lightboxModal" data-img="<?php echo e(asset('')); ?>web/image/E5.jpg">
            <img src="<?php echo e(asset('')); ?>web/image/E5.jpg" alt="Gallery 2">
            <div class="gallery-overlay"><i class="bi bi-arrows-fullscreen"></i></div>
          </div>
        </div>

        <div class="col-lg-4 col-md-6">
          <div class="gallery-item" data-bs-toggle="modal" data-bs-target="#lightboxModal" data-img="<?php echo e(asset('')); ?>web/image/E5.jpg">
            <img src="<?php echo e(asset('')); ?>web/image/E5.jpg" alt="Gallery 3">
            <div class="gallery-overlay"><i class="bi bi-arrows-fullscreen"></i></div>
          </div>
        </div>

        <!-- Add more gallery items -->
      </div>
    </div>
  </section>

  <!-- Lightbox Modal -->
  <div class="modal fade" id="lightboxModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-xl">
      <div class="modal-content bg-transparent border-0 shadow-none">
        <div class="modal-body p-0 text-center">
          <img id="lightboxImage" src="" class="img-fluid rounded">
        </div>
      </div>
    </div>
  </div>


  <!-- ===== Events/News ===== -->
<section class="events-news py-5" style="background: linear-gradient(135deg, #f9f9f9, #eef3f7);">
  <div class="container">
    <div class="text-center mb-5">
      <h2 class="fw-bold position-relative d-inline-block">
        <span class="text-danger-emphasis fw-bold">
          Events & News
        </span>
        <span class="underline"></span>
      </h2>
      <p class="text-muted">Stay updated with the latest happenings in Nagar Panchayat Bakewar Uttar Pradesh.</p>
    </div>

    <div class="row g-4">
      <!-- Event Card -->
      <div class="col-md-6 col-lg-4" data-aos="fade-up">
        <div class="event-card">
          <div class="event-img">
            <img src="<?php echo e(asset('')); ?>web/image/E1.jpg" alt="Event">
            <span class="date-badge">15 Aug 2025</span>
          </div>
          <div class="event-body">
            <h5>Swachhta Abhiyan</h5>
            <p>Cleanliness drive conducted with citizen participation.</p>
          </div>
        </div>
      </div>

      <!-- Event Card -->
      <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="100">
        <div class="event-card">
          <div class="event-img">
            <img src="<?php echo e(asset('')); ?>web/image/E2.jpg" alt="Event">
            <span class="date-badge">30 Jul 2025</span>
          </div>
          <div class="event-body">
            <h5>Tree Plantation</h5>
            <p>200+ saplings planted across wards.</p>
          </div>
        </div>
      </div>

      <!-- Event Card -->
      <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="200">
        <div class="event-card">
          <div class="event-img">
            <img src="<?php echo e(asset('')); ?>web/image/E3.jpg" alt="Event">
            <span class="date-badge">20 Jul 2025</span>
          </div>
          <div class="event-body">
            <h5>Awareness Program</h5>
            <p>Workshop on water conservation held.</p>
          </div>
        </div>
      </div>

      <!-- Event Card -->
      <div class="col-md-6 col-lg-4" data-aos="fade-up">
        <div class="event-card">
          <div class="event-img">
            <img src="<?php echo e(asset('')); ?>web/image/E4.jpg" alt="Event">
            <span class="date-badge">15 Aug 2025</span>
          </div>
          <div class="event-body">
            <h5>Independence Day</h5>
            <p>Flag hoisting and cultural programs held.</p>
          </div>
        </div>
      </div>

      <!-- Event Card -->
      <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="100">
        <div class="event-card">
          <div class="event-img">
            <img src="<?php echo e(asset('')); ?>web/image/E5.jpg" alt="Event">
            <span class="date-badge">5 Aug 2025</span>
          </div>
          <div class="event-body">
            <h5>Free Health Camp</h5>
            <p>Medical checkup for local citizens.</p>
          </div>
        </div>
      </div>

      <!-- Event Card -->
      <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="200">
        <div class="event-card">
          <div class="event-img">
            <img src="<?php echo e(asset('')); ?>web/image/E6.jpg" alt="Event">
            <span class="date-badge">8 Mar 2025</span>
          </div>
          <div class="event-body">
            <h5>Women's Day Celebration</h5>
            <p>Programs for empowerment and health awareness.</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<!-- ===== Our Staff ===== -->
<section class="staff-section py-5">
  <div class="container">
    <div class="text-center mb-5">
      <h2 class="fw-bold position-relative d-inline-block">
        <span class="text-danger-emphasis fw-bold">
          Staff Directory
        </span>
        <span class="underline"></span>
      </h2>
      <p class="text-muted mt-2">Meet the officials of Nagar Panchayat Bakewar Uttar Pradesh.</p>
    </div>

    <div class="row g-4">
      <!-- Staff Card -->
      <div class="col-md-6 col-lg-3" data-aos="fade-up">
        <div class="staff-card">
          <div class="staff-img">
            <img src="https://cdn-icons-png.flaticon.com/512/3135/3135715.png" alt="official">
            <div class="staff-overlay">
              <p><i class="bi bi-envelope"></i> chairman@nagarparishadBakewar .in</p>
              <p><i class="bi bi-telephone"></i> +91-9876543210</p>
            </div>
          </div>
          <div class="staff-info text-center">
            <h5>Shri XYZ Singh</h5>
            <p>Chairman</p>
          </div>
        </div>
      </div>

      <!-- Staff Card -->
      <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="100">
        <div class="staff-card">
          <div class="staff-img">
            <img src="https://cdn-icons-png.flaticon.com/512/3135/3135823.png" alt="official">
            <div class="staff-overlay">
              <p><i class="bi bi-envelope"></i> eo@nagarparishadBakewar .in</p>
              <p><i class="bi bi-telephone"></i> +91-9123456780</p>
            </div>
          </div>
          <div class="staff-info text-center">
            <h5>Shri ABC Verma</h5>
            <p>Executive Officer</p>
          </div>
        </div>
      </div>

      <!-- Staff Card -->
      <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="200">
        <div class="staff-card">
          <div class="staff-img">
            <img src="https://cdn-icons-png.flaticon.com/512/3135/3135768.png" alt="official">
            <div class="staff-overlay">
              <p><i class="bi bi-envelope"></i> clerk@nagarparishadBakewar .in</p>
              <p><i class="bi bi-telephone"></i> +91-9988776655</p>
            </div>
          </div>
          <div class="staff-info text-center">
            <h5>Smt. Neha Sharma</h5>
            <p>Senior Clerk</p>
          </div>
        </div>
      </div>

      <!-- Staff Card -->
      <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="300">
        <div class="staff-card">
          <div class="staff-img">
            <img src="https://cdn-icons-png.flaticon.com/512/3135/3135789.png" alt="official">
            <div class="staff-overlay">
              <p><i class="bi bi-envelope"></i> je@nagarparishadBakewar .in</p>
              <p><i class="bi bi-telephone"></i> +91-9876543000</p>
            </div>
          </div>
          <div class="staff-info text-center">
            <h5>Shri Deepak Kumar</h5>
            <p>Junior Engineer</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<!-- ===== Download Form ===== -->
<section id="forms" class="py-5 bg-light">
  <div class="container">
    <div class="text-center mb-5">
      <h2 class="text-danger-emphasis fw-bold">Downloadable Forms 
        
      </h2>
      <p class="text-muted">Official forms for public use.</p>
    </div>

    <div class="row g-4">
      <!-- Form Card -->
      <div class="col-md-4">
        <div class="form-card shadow-lg border-0 p-4 rounded-4 h-100 text-center animate__animated animate__fadeInUp">
          <div class="icon-circle mx-auto mb-3">
            <i class="fas fa-file-pdf fa-3x text-danger-emphasis"></i>
          </div>
          <h5 class="fw-bold mb-3">Birth Certificate Form</h5>
          <a href="#" class="btn download-btn w-100">
            <i class="fas fa-download me-2"></i>Download
          </a>
        </div>
      </div>

      <!-- Form Card -->
      <div class="col-md-4">
        <div class="form-card shadow-lg border-0 p-4 rounded-4 h-100 text-center animate__animated animate__fadeInUp animate__delay-1s">
          <div class="icon-circle mx-auto mb-3">
            <i class="fas fa-file-pdf fa-3x text-danger-emphasis"></i>
          </div>
          <h5 class="fw-bold mb-3">Death Certificate Form</h5>
          <a href="#" class="btn download-btn w-100">
            <i class="fas fa-download me-2"></i>Download
          </a>
        </div>
      </div>

      <!-- Form Card -->
      <div class="col-md-4">
        <div class="form-card shadow-lg border-0 p-4 rounded-4 h-100 text-center animate__animated animate__fadeInUp animate__delay-2s">
          <div class="icon-circle mx-auto mb-3">
            <i class="fas fa-file-pdf fa-3x text-danger-emphasis"></i>
          </div>
          <h5 class="fw-bold mb-3">Property Tax Form</h5>
          <a href="#" class="btn download-btn w-100">
            <i class="fas fa-download me-2"></i>Download
          </a>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- ===== Feedback ===== -->
<section id="feedback" class="py-5">
  <div class="container">
    <div class="row align-items-center g-4">

      <!-- Left Side Form -->
      <div class="col-lg-7">
        <div class="p-4 shadow-lg bg-white rounded-4">
          <h2 class="text-danger-emphasis fw-bold mb-2">We Value Your Feedback</h2>
          <p class="text-muted mb-4">Your suggestions help us improve public services and serve you better.</p>

          <form>
            <div class="row g-3">
              <div class="col-md-6">
                <label class="form-label fw-semibold">Name</label>
                <input type="text" class="form-control rounded-3" placeholder="Enter your name">
              </div>
              <div class="col-md-6">
                <label class="form-label fw-semibold">Email</label>
                <input type="email" class="form-control rounded-3" placeholder="Enter your email">
              </div>
              <div class="col-md-6">
                <label class="form-label fw-semibold">Mobile</label>
                <input type="text" class="form-control rounded-3" placeholder="Enter your mobile number">
              </div>
              <div class="col-md-6">
                <label class="form-label fw-semibold">Subject</label>
                <input type="text" class="form-control rounded-3" placeholder="Enter subject">
              </div>
              <div class="col-12">
                <label class="form-label fw-semibold">Feedback</label>
                <textarea class="form-control rounded-3" rows="4" placeholder="Write your Feedback"></textarea>
              </div>
              <div class="col-12 text-end">
                <button type="submit" class="btn btn-success px-4 rounded-pill shadow-sm">
                  <i class="fas fa-paper-plane me-2"></i>Send Feedback
                </button>
              </div>
            </div>
          </form>
        </div>
      </div>

      <!-- Right Side Illustration -->
      <div class="col-lg-5 text-center">
        <div class="card shadow-lg border-0 rounded-4 overflow-hidden animate__animated animate__fadeInRight">
          <img src="<?php echo e(asset('')); ?>web/image/Feedback.webp" class="img-fluid" alt="Feedback Illustration">
          <div class="p-3">
            <h5 class="fw-bold mb-1">Nagar Panchayat Bakewar </h5>
            <p class="text-muted">Etawah</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- ===== Contact Us ===== -->
  <section class="contact-section">
    <div class="container">
      <div class="text-center mb-5">
        <h2 class="text-danger-emphasis fw-bold">Contact Us</h2>
        <p class="text-muted">We’re here to assist you. Get in touch with us anytime!</p>
      </div>

      <div class="row g-4">
        <!-- Left side info -->
        <div class="col-lg-5 d-flex flex-column gap-4">
          <div class="contact-card" data-aos="fade-right">
            <div class="contact-icon" style="background:#007bff;">
              <i class="bi bi-geo-alt-fill"></i>
            </div>
            <div class="contact-info">
              <h5>Address</h5>
              <p class="mb-0">Nagar Panchayat Bakewar <br> Etawah,  Uttar Pradesh</p>
            </div>
          </div>

          <div class="contact-card" data-aos="fade-right" data-aos-delay="200">
            <div class="contact-icon" style="background:#28a745;">
              <i class="bi bi-telephone-fill"></i>
            </div>
            <div class="contact-info">
              <h5>Phone</h5>
              <p class="mb-0">+91-XXXX-XXXXXX</p>
            </div>
          </div>

          <div class="contact-card" data-aos="fade-right" data-aos-delay="400">
            <div class="contact-icon" style="background:#ffc107;">
              <i class="bi bi-envelope-fill"></i>
            </div>
            <div class="contact-info">
              <h5>Email</h5>
              <p class="mb-0">npBakewar @gmail.com</p>
            </div>
          </div>
        </div>

        <!-- Right side map -->
        <div class="col-lg-7" data-aos="zoom-in">
         <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d7131.11654661743!2d79.1752238!3d26.6626221!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39760f4a96a958ab%3A0x9c0bce6f487e5d95!2sBakewar%2C%20Uttar%20Pradesh%20206124!5e0!3m2!1sen!2sin!4v1758614986910!5m2!1sen!2sin" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
      </div>
    </div>
  </section>

  <!-- ===== Footer Section ===== -->
<footer class="footer">
  <div class="container">
    <div class="row footer-top">
      
      <!-- Contact Us -->
      <div class="col-lg-3 col-md-6 footer-col animate">
        <h5>Contact Us</h5>
        <ul class="footer-list">
          <li><i class="fas fa-map-marker-alt"></i>Nagar Panchayat Bakewar <br> Etawah, Uttar Pradesh</li>
          <li><i class="fas fa-phone"></i> +91-135-2747051-58 Ext 4360</li>
          <li><i class="fas fa-phone"></i> +91-135-2744064, 2743331</li>
          <li><i class="fas fa-envelope"></i> helpdesk[dot]soi[at]gov[dot]in</li>
        </ul>
        <div class="social-links">
          <a href="#"><i class="fab fa-facebook-f"></i></a>
          <a href="#"><i class="fab fa-twitter"></i></a>
          <a href="#"><i class="fab fa-youtube"></i></a>
          
          <a href="#"><i class="fab fa-linkedin-in"></i></a>
        </div>
      </div>

      <!-- Quick Links -->
      <div class="col-lg-3 col-md-6 footer-col animate">
        <h5>Quick Links</h5>
        <ul class="footer-list">
          <li><a href="#">FAQs</a></li>
          <li><a href="#">RTI</a></li>
          <li><a href="#">Feedback</a></li>
          <li><a href="#">Notices</a></li>
          <li><a href="#">Help</a></li>
          <li><a href="#">Public Grievances</a></li>
          <li><a href="#">Software and Plugins</a></li>
        </ul>
      </div>

      <!-- Website Policies -->
      <div class="col-lg-3 col-md-6 footer-col animate">
        <h5>Website Policies</h5>
        <ul class="footer-list">
          <li><a href="#">Accessibility Statement</a></li>
          <li><a href="#">Accessibility Options</a></li>
          <li><a href="#">Privacy Policy</a></li>
          <li><a href="#">Hyperlinking Policy</a></li>
          <li><a href="#">Copyright Policy</a></li>
          <li><a href="#">Terms & Conditions</a></li>
          <li><a href="#">Disclaimer</a></li>
        </ul>
      </div>

      <!-- Locate Us -->
      <div class="col-lg-3 col-md-6 footer-col animate">
        <h5>Locate Us</h5>
        <div class="map-container">
         <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d7131.11654661743!2d79.1752238!3d26.6626221!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39760f4a96a958ab%3A0x9c0bce6f487e5d95!2sBakewar%2C%20Uttar%20Pradesh%20206124!5e0!3m2!1sen!2sin!4v1758614986910!5m2!1sen!2sin" width="100%" height="200" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
      </div>
    </div>

    <!-- Bottom Bar -->
    <div class="footer-bottom text-center">
      <p>Last Updated On : 19 September 2025 at 01:26 pm || 
         <span class="visitors">Visitors : 3657</span></p>
    </div>
  </div>
</footer>

  <!-- Modal -->
  <div class="modal fade" id="grievanceModal" tabindex="-1" aria-labelledby="grievanceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content rounded-4 shadow-lg">

        <div class="modal-header border-0">
          <h5 class="modal-title fw-bold" id="grievanceModalLabel">
            Public Grievance Form
          </h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>

        <div class="modal-body px-4">
          <form>
            <div class="mb-3">
              <label class="form-label">Name</label>
              <input type="text" class="form-control form-control-lg" placeholder="Enter your name">
            </div>
            <div class="mb-3">
              <label class="form-label">Mobile</label>
              <input type="text" class="form-control form-control-lg" placeholder="Enter mobile number">
            </div>
            <div class="mb-3">
              <label class="form-label">Ward</label>
              <input type="text" class="form-control form-control-lg" placeholder="Enter ward">
            </div>
            <div class="mb-3">
              <label class="form-label">Subject</label>
              <input type="text" class="form-control form-control-lg" placeholder="Enter subject">
            </div>
            <div class="mb-3">
              <label class="form-label">Description</label>
              <textarea class="form-control form-control-lg" rows="3" placeholder="Enter description"></textarea>
            </div>
            <div class="mb-3">
              <label class="form-label">Upload Image (optional)</label>
              <input type="file" class="form-control form-control-lg">
            </div>
          </form>
        </div>

        <div class="modal-footer border-0">
          <button type="button" class="btn-modern">Submit</button>
          <button type="button" class="btn btn-outline-secondary rounded-pill px-4"
            data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>






  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <!-- Lightbox2 JS -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/js/lightbox.min.js"></script>

  <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
  <script>
    AOS.init();
  </script>
  <!-- Swiper CSS + JS -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
  <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
  <script>
    var swiper = new Swiper(".servicesSwiper", {
      slidesPerView: 1,
      spaceBetween: 20,
      loop: true,
      autoplay: {
        delay: 2500,
        disableOnInteraction: false,
      },
      pagination: {
        el: ".swiper-pagination",
        clickable: true,
      },
      navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
      },
      breakpoints: {
        768: { slidesPerView: 3 },
        1200: { slidesPerView: 5 }
      }
    });
  </script>
  <script>
    document.addEventListener("DOMContentLoaded", () => {
      const grievanceForm = document.querySelector("#grievanceModal form");
      if (grievanceForm) {
        grievanceForm.addEventListener("submit", function (e) {
          e.preventDefault(); // stop reload
          alert("Form submitted! (demo)");
          const modalEl = document.getElementById("grievanceModal");
          const bsModal = bootstrap.Modal.getInstance(modalEl);
          if (bsModal) bsModal.hide();
        });
      }
    });
  </script>
  <script>
    // Change modal image dynamically
    const lightboxModal = document.getElementById('lightboxModal');
    const lightboxImage = document.getElementById('lightboxImage');

    document.querySelectorAll('.gallery-item').forEach(item => {
      item.addEventListener('click', () => {
        const imgSrc = item.getAttribute('data-img');
        lightboxImage.src = imgSrc;
      });
    });
  </script>
  <script>
document.addEventListener("DOMContentLoaded", () => {
  const elements = document.querySelectorAll(".animate");
  const observer = new IntersectionObserver(entries => {
    entries.forEach(entry => {
      if(entry.isIntersecting){
        entry.target.classList.add("show");
      }
    });
  }, {threshold: 0.2});
  
  elements.forEach(el => observer.observe(el));
});
</script>
</body>

</html><?php /**PATH /home/npgovardhan25/public_html/resources/views/index.blade.php ENDPATH**/ ?>