<?php $__env->startSection('style'); ?>
<link href='https://cdn.jsdelivr.net/npm/froala-editor@latest/css/froala_editor.pkgd.min.css' rel='stylesheet' type='text/css' />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="row">
            <div class="col-12">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            </div>
        </div>
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">All User </div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page"> User </li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                </div>
            </div>
        </div>
        <!--end breadcrumb-->
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">User Add</h6>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="" class="row" method="POST" enctype="multipart/form-data"id="SameForm">
                            <?php echo csrf_field(); ?>
                            <div class="col-md-3 mb-3">
                                
                                <label for="name" class="form-label">Name *</label>
                                <input type="text" class="form-control" id="name" name="name" value="<?php echo e($user->name ?? ''); ?>" required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="email" class="form-label">Email *</label>
                                <input type="text" class="form-control" id="email" name="email" value="<?php echo e($user->email ?? ''); ?>"  <?php echo e(isset($user->email) ? 'readonly':''); ?> required>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="password" class="form-label">Password *</label>
                                <input type="password" class="form-control" id="password" name="password" value=""   }}>
                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="password_confirmation" class="form-label">Password Confirmation *</label>
                                <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" value=""  }}>
                                <?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="mobile" class="form-label">Mobile *</label>
                                <input type="text" class="form-control" id="mobile" name="mobile" value="<?php echo e($user->mobile ?? ''); ?>" required>
                                <?php $__errorArgs = ['mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="address" class="form-label">Address</label>
                                <input type="text" class="form-control" id="address" name="address" value="<?php echo e($user->address ?? ''); ?>" required>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="aadhar" class="form-label">Aadhar *</label>
                                <input type="text" class="form-control" id="aadhar" name="aadhar" value="<?php echo e($user->aadhar ?? ''); ?>" required>
                                <?php $__errorArgs = ['aadhar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="pan" class="form-label">Pancard No *</label>
                                <input type="text" class="form-control" id="pan" name="pan" value="<?php echo e($user->pan ?? ''); ?>" required>
                                <?php $__errorArgs = ['pan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="profile" class="form-label">Profile</label>
                                <input type="file" class="form-control" id="profile" name="profile" >
                                <?php $__errorArgs = ['profile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="role_id" class="form-label">Role *</label>
                                <select  class="form-select form-select-sm" id="role_id" name="roll_id">
                                    <option value="">Select Role</option>
                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                        <option value="<?php echo e($role->id); ?>" <?php echo e(isset($user->roll_id)? ($user->roll_id== $role->id ? 'selected' : ''):''); ?>>
                                            <?php echo e($role->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            
                            <div class="col-md-4 mb-3">
                                <label for="status" class="form-label">Status</label>
                                <select  class="form-select form-select-sm" id="status" name="status">
                                    <option value="1" <?php echo e(isset($user->status)? ($user->status== 1 ? 'selected' : ''):''); ?>>Active</option>
                                    <option value="0" <?php echo e(isset($user->status)? ($user->status== 0 ? 'selected' : ''):''); ?>>Inactive</option>
                                </select>
                            </div>
                         <input type="hidden" name="id" id="user_id" value="">



                            <div class="col-md-2 m-1"> 
                                <button type="submit" class="btn btn-primary pr-2">Save </button>
                                 <a href="<?php echo e(route('gis.user.index')); ?>" class="btn btn-secondary ">Cancel</a>
                            </div>
                             
                        </form>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <!-- Displaying Success Message -->
                        <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>

                        <!-- Displaying Error Messages -->
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="col-lg-12 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">User List</h6>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive"> 
                            <table class="table" id="example">
                                <thead>
                                    <tr>
                                        <th>ID</th> 
                                        <th>Status</th>
                                        <th>Role</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Mobile</th>
                                        <th>Address</th>
                                        <th>Aadhar</th>
                                        <th>Pancard No</th>
                                        <th>Profile</th>
                                        <th>Created By </th>
                                        <th>Created Date </th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                               
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    $(function () {
        $("#example").DataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(route('gis.user.data')); ?>", // same route as your controller
            columns: [
                { data: "DT_RowIndex", name: "DT_RowIndex" },
                { data: "status", name: "status" },
                { data: "role", name: "role.name" },
                { data: "name", name: "name" },
                { data: "email", name: "email" },
                { data: "mobile", name: "mobile" },
                { data: "address", name: "address" },
                { data: "aadhar", name: "aadhar" },
                { data: "pan", name: "pan" },
                { data: "profile", name: "profile", orderable: false, searchable: false },
                { data: "created_by", name: "user.name" },
                { data: "created_at", name: "created_at" },
                { data: "actions", name: "actions", orderable: false, searchable: false },
            ],
        });
    });
</script>

<script>
    $(document).ready(function () {
        $(document).on("submit", "#SameForm", function (e) {
            e.preventDefault();

            let $form = $(this);
            let formData = new FormData(this);
            // 👇 Forcefully ensure 'id' is present in FormData
            let userId = $('#SameForm input[name="id"]').val();
            console.log("Submitting ID:", userId);
            if (userId) {
                formData.append("id", userId);
            }
            let $submitBtn = $form.find("button[type='submit']");

            // Disable submit button to prevent multiple clicks
            $submitBtn.prop("disabled", true).text("Saving...");

            // Clear all error messages
            $(".text-danger").html("");

            $.ajax({
                url: "<?php echo e(route('gis.user.store')); ?>",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,

                success: function (res) {
                    // Reset the form
                    $form[0].reset();
                    $("#status").val("1");
                    $("#role_id").val("");
                    // ✅ Yeh dono lines yahaan likho
                    $('#SameForm input[name="email"]').prop("readonly", false);
                    $('#SameForm input[name="id"]').val("");

                    // Reload DataTable
                    $("#example").DataTable().ajax.reload(null, false);

                    // Show success toastr
                    toastr.success(res.msg || "Saved successfully!");
                },

                error: function (xhr) {
                    if (xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        $.each(errors, function (key, value) {
                            $(`.${key}-error`).html(value[0]);
                            toastr.error(value[0]);
                        });
                    } else {
                        toastr.error("Something went wrong. Please try again.");
                    }
                },

                complete: function () {
                    $submitBtn.prop("disabled", false).text("Save");
                },
            });
        });
    });

    $(document).on("click", "#cancelBtn", function (e) {
        e.preventDefault(); // Stop page refresh
        $("#SameForm")[0].reset(); // Reset the form
        $("#SameForm input[name='id']").val(""); // Also clear hidden ID if editing
    });

    $(document).on("click", ".edit-btn", function () {
        if (!confirm("Are you sure you want to edit this item?")) 
        {
            return;
        }
        let id = $(this).data("id");
        $.ajax({
            url: `<?php echo e(url('gis/user/get')); ?>/${id}`,

            method: "GET",
            success: function (data) {
                $('#SameForm input[name="id"]').val(data.id);

                $('#SameForm input[name="name"]').val(data.name);
                $('#SameForm input[name="email"]').val(data.email).prop("readonly", true);

                $('#SameForm input[name="mobile"]').val(data.mobile);
                $('#SameForm input[name="aadhar"]').val(data.aadhar);
                $('#SameForm input[name="pan"]').val(data.pan);
                $('#SameForm input[name="address"]').val(data.address);
                $('#SameForm select[name="roll_id"]').val(data.roll_id);
                $('#SameForm select[name="status"]').val(data.status);

                // Optional: Scroll to form
                $("html, body").animate(
                    {
                        scrollTop: $("#SameForm").offset().top,
                    },
                    500
                );
            },
            error: function () {
                alert("An error occurred while loading the data.");
            },
        });
    });

    $(document).on("click", ".btn-delete", function () {
        if (!confirm("Are you sure you want to delete this item?")) {
            return; // User canceled
        }
        let delUrl = $(this).data("delid");
        $.ajax({
            url: delUrl,
            type: "GET",
            success: function (res) {
                if (res.status === 1) {
                    toastr.success("Data has been deleted successfully");
                } else {
                    toastr.error("Something went wrong");
                }
                $("#example").DataTable().ajax.reload();
            },
        });
    });
</script>





<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.adminApp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/npgovardhan25/public_html/resources/views/admin/users/index.blade.php ENDPATH**/ ?>