<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Property Details - Nagar Panchayat Govardhan">
    <meta name="author" content="Nagar Panchayat Govardhan">
    <meta name="robots" content="index, follow">
    <meta property="og:title" content="Property Details - Nagar Panchayat Govardhan">
    <meta property="og:description" content="Detailed property information including location, area, owner details, and construction details."/>
    <meta property="og:image" content="<?php echo e(asset('admin/assets/up.png')); ?>"> <!-- Replace with a valid image URL -->
    <meta property="og:url" content="current_page_url"> <!-- Replace with the current page URL -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Property Details - Nagar Panchayat Govardhan">
    <meta name="twitter:description" content="Detailed property information including location, area, owner details, and construction details.">
    <meta name="twitter:image" content="<?php echo e(asset('admin/assets/up.png')); ?>"> <!-- Replace with a valid image URL -->
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(asset('admin/assets/up.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('admin/assets/up.png')); ?>" type="image/png"> <!-- For PNG format -->
    <link rel="apple-touch-icon" href="<?php echo e(asset('admin/assets/up.png')); ?>">


    <title>Property Details</title>
    <style type="text/css">
        @media print {
            .body {
                height: 2240px !important;
            }
        }

        .body {
            width: 720px;
            height: 1150px;
            padding: 5px;
            margin: auto;
            margin-top: 10px;
            border: 1px solid black;
            border-radius: 5px; 
            font-size: 11px; 
        }

        table {
            width: 100%;
            border: 1px solid black;
            margin-bottom: 10px;
            font-size: 10px;
            text-align: left;
            border-collapse: collapse;
        }

        th, td {
            padding: 2px 5px;
            border: 1px solid black;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        .tab  { 
            text-align: center; 
        }
  
        .table-header {
            font-weight: bold;
            background-color: #f0f0f0;
        }

        .table-section {
            margin-top: 20px;
        }
    </style>
    
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDgFcTmfanz9rxx1l0Hl9-cMTNJF8jpgQE&amp;callback=initMap" async="" defer=""></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
</head>
<body> 
    
    <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2=>$property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
    <div class="body" >
        <div class="tt">
            <h2 style="text-align: center;">
                कार्यालय नगर पंचायत गोवर्धन, जिला मथुरा, उत्तर प्रदेश<br>
                Office of Nagar Panchayat Govardhan, Mathura, Uttar Pradesh
            </h2>

            
            <table border="1" cellspacing="0" cellpadding="8" width="100%">
                <tr>
                    <th colspan="4" class="table-header">1. संपत्ति की सामान्य जानकारी / General Property Information</th>
                </tr>
                <tr>
                    <td>संपत्ति का परिक्षेत्र / Property Zone</td>
                    <td><b><?php echo e($property->taxRateZoneData?->name ?? '-'); ?></b></td>
                    <td>वार्ड / Ward</td>
                    <td><b><?php echo e($property->ward->name); ?></b></td>
                </tr>
                <tr>
                    <td>जी आई एस एवं पार्सल न० / GIS & Parcel No.</td>
                    <td><b><?php echo e($property->parcelNo); ?></b></td>
                    <td>यूनिक आईडी / Unique ID</td>
                    <td><b><?php echo e($property->nagarpalikaId); ?></b></td>
                </tr>
                <tr>
                    <td>संपत्ति संख्या / Property Number</td>
                    <td><b><?php echo e($property->propertyNo); ?></b></td>
                    <td>बिजली बिल क्रमांक / Electricity Bill No.</td>
                    <td><b><?php echo e($property->electricityId); ?></b></td>
                </tr>
                <tr>
                    <td>खसरा क्रमांक / Khasra Number</td>
                    <td><b><?php echo e($property->khasraNo); ?></b></td>
                    <td>संपत्ति का प्रकार / Property Type</td>
                    <td><b><?php echo e($property->propertyTypeData?->type_name); ?></b></td>
                </tr>
            </table>

    
            <table border="1" cellspacing="0" cellpadding="8" width="100%">
            <tr>
                <th colspan="2" class="table-header">2. संपत्ति मालिक की जानकारी / Property Owner Information</th>
            </tr>
            <tr>
                <td colspan="2">
                    <table style="width: 100%; margin-top: 10px;" border="1" cellspacing="0" cellpadding="6">
                        <tr class="table-header">
                            <th>क्रमांक / S.No.</th>
                            <th>संपत्ति करदाता का नाम / Owner Name</th>
                            <th>पिता/पति / Father/Husband</th>
                            <th>मोबाइल नंबर / Mobile Number</th>
                            <th>ईमेल / Email</th>
                            <th>अतिरिक्त मोबाइल / Alternate Mobile</th>
                        </tr>
                        <?php $__currentLoopData = (is_array($property->ownerDetails)? $property->ownerDetails : json_decode($property->ownerDetails)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $owner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><b><?php echo e($k + 1); ?></b></td>
                                <td><b><?php echo e($owner->name ?? '-'); ?></b></td>
                                <td><b><?php echo e($owner->fatherName ?? '-'); ?></b></td>
                                <td><b><?php echo e($owner->mobile ?? '-'); ?></b></td>
                                <td><b><?php echo e($owner->email ?? '-'); ?></b></td>
                                <td><b><?php echo e($owner->secondaryPhone ?? '-'); ?></b></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    पता / Address :- 
                    <b><?php echo e($property->houseNo); ?> <?php echo e($property->streetNoName); ?> <?php echo e($property->locality); ?> <?php echo e($property->colony); ?> <?php echo e($property->city); ?> <?php echo e($property->pincode); ?></b>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <b>निकाय में पंजीकृत संपत्ति कर क्रमांक, संपत्ति स्वामी का नाम तथा संपत्ति का क्षेत्रफल / 
                    Registered Property Tax No., Owner Name, and Property Area in the Municipality</b>
                </td> 
            </tr>
           <tr> 
                <td>
                    संपत्ति का उपयोग (आवासीय / व्यावसायिक / दोनों ) / Property Use (Residential/Commercial/Both): 
                    <b><?php echo e($property->propertyTypeData?->type_name); ?></b>
                </td>
                <td>
                    निर्मित क्षेत्रफल / Built-up Area: 
                    <b><?php echo e($property->totalBuiltUpAreaSqFt); ?> SqFt / <?php echo e($property->totalBuiltUpAreaSqMeter); ?> SqMeter</b>
                </td>
            </tr>
        </table> 
             
            <table border="1" cellspacing="0" cellpadding="8" width="100%">
                <tr>
                    <th colspan="4" class="table-header">
                        3. संपत्ति के क्षेत्रफल की जानकारी / Property Area Details
                    </th>
                </tr>
                <tr>
                    <td>भूमि / प्लाट का क्षेत्रफल (वर्ग फ़ीट में) / Land / Plot Area (in SqFt)</td>
                    <td>
                        <b><?php echo e(number_format($property->plotAreaSqFt, 2)); ?> SqFt / <?php echo e(number_format($property->plotAreaSqMeter, 2)); ?> SqMeter</b>
                    </td>
                    <td>प्लिथ क्षेत्रफल (वर्ग फ़ीट में) / Plinth Area (in SqFt)</td>
                    <td>
                        <b><?php echo e(number_format( $property->plinthAreaSqFt, 2)); ?> SqFt / <?php echo e(number_format($property->plinthAreaSqMeter, 2)); ?> SqMeter</b>
                    </td>
                </tr>
                <tr>
                    <td>संपत्ति का कुल निर्माण / Total Built-up Area</td>
                    <td>
                        <b><?php echo e(number_format($property->totalBuiltUpAreaSqFt, 2)); ?> SqFt / <?php echo e(number_format( $property->totalBuiltUpAreaSqMeter, 2)); ?> SqMeter</b>
                    </td>
                    <td>अक्षांश / देशांतर / Latitude / Longitude</td>
                    <td><b><?php echo e($property->latitude); ?> / <?php echo e($property->longitude); ?></b></td>
                </tr>
            </table>
            <table class="tab" border="1" cellspacing="0" cellpadding="6" width="100%">
                <tr>
                    <th class="tab" colspan="15"><b>संपत्ति के निर्मित क्षेत्रफल का विवरण / Details of Constructed Area of the Property</b></th>
                </tr>
                <tr>
                    <th class="tab" rowspan="3">तल फ्लोर / Floor</th>
                    <th class="tab" colspan="4">पक्का / Pucca</th>
                    <th class="tab" colspan="4">आंशिक पक्का / Semi-Pucca</th>
                    <th class="tab" colspan="4">कच्चा / Kachcha</th>
                    <th class="tab"  rowspan="3" >खुली भूमि / Open Land</th>

                    <th class="tab" rowspan="3">योग / Total</th>
                </tr>
                <tr>
                    <th class="tab" colspan="2">आवासीय / Residential</th>
                    <th class="tab" colspan="2">व्यावसायिक / Commercial</th>
                    <th class="tab" colspan="2">आवासीय / Residential</th>
                    <th class="tab" colspan="2">व्यावसायिक / Commercial</th>
                    <th class="tab" colspan="2">आवासीय / Residential</th>
                    <th class="tab" colspan="2">व्यावसायिक / Commercial</th>
                </tr>
                <tr>
                    <th class="tab">स्वयं के उपयोग में / Self-use</th>
                    <th class="tab">किराये पर / Rented</th>
                    <th class="tab">स्वयं के उपयोग में / Self-use</th>
                    <th class="tab">किराये पर / Rented</th>
                    <th class="tab">स्वयं के उपयोग में / Self-use</th>
                    <th class="tab">किराये पर / Rented</th>
                    <th class="tab">स्वयं के उपयोग में / Self-use</th>
                    <th class="tab">किराये पर / Rented</th>
                    <th class="tab">स्वयं के उपयोग में / Self-use</th>
                    <th class="tab">किराये पर / Rented</th>
                    <th class="tab">स्वयं के उपयोग में / Self-use</th>
                    <th class="tab">किराये पर / Rented</th>
                </tr>
                <!-- Add data rows here --> 
                <?php
                     // Usage example:
                    $floorData = json_decode($property->floorData); 
                    $tableData = calculateFloorData($property, $floorData, $allInOne);
                    
                    // Output the table rows
                    foreach ($tableData as $row) {
                        echo "<tr>";
                        echo "<td class='tab'>{$row['floorType']}</td>";
                        for ($i = 1; $i <= 14; $i++) {
                            echo "<td class='tab'>{$row['data'][$i]}</td>";
                        }
                        echo "</tr>";
                    }
                ?> 
                  
            </table>
            <table class="table">
                <tr>
                    <td colspan="9" class="tab"> आयाम विवरण <br> Dimension Details </td>
                </tr>
                <tr class="text-center">
                    <th class="tab">
                        Usage type <br> (उपयोग प्रकार)
                    </th>
                    <th class="tab">
                        Usage Factor <br> (उपयोग कारक)
                    </th>
                    <th class="tab">
                        Floor <br> (तल)
                    </th>
                    <th class="tab">
                        Construction <br> (निर्माण)
                    </th>
                    <th class="tab">
                        Area <br> (क्षेत्रफल)
                    </th>
                    <th class="tab">
                        Rate <br> (दर)
                    </th>
                    <th class="tab">
                        ALV <br> (वार्षिक मूल्यांकन)
                    </th>
                    <th class="tab">
                        TPV (10%) <br> (संपत्ति का 10%  मूल्य)
                    </th>
                </tr>
            
                <?php 
                $TotalAmount = 0;
                $WTotalAmount = 0;
                $DTotalAmount = 0;
                ?>
            
                <?php $__currentLoopData = $floorData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $floor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php 
                    // Get the rate based on the floor details
                    $rate = calculateRate($floor->constructionType, $floor->usageType, $floor->usageFactor, $property->taxRateZone, $property->ward?->id);
                    
                    // Call the function to calculate amounts
                    $amounts = calculateAmounts($floor, $property, $rate);
            
                    $TotalAmount += $amounts['discount'];
                    $WTotalAmount += $amounts['Wdiscount']; 
                    $DTotalAmount += $amounts['Ddiscount'];
                    ?>
            
                    <tr>  
                        <td> <?php echo e(usageType($floor->usageType, $allInOne['propertyType'])); ?> </td>
                        <td> <?php echo e(usageFactors($floor->usageFactor, $allInOne['usagsFactor'])); ?> </td> 
                        <td> <?php echo e(floorType($floor->floorType, $allInOne['floorType'])); ?> </td>
                        <td> <?php echo e(yearOfConstructions($floor->constructionType, $allInOne['natureOfConstruction'])); ?> </td> 
                        <td><?php echo e($floor->areaSqFt); ?> SqFt </td>    
                        <td class="tab"><?php echo e(number_format($rate, 2)); ?></td>
                        <td class="tab"><?php echo e(number_format($amounts['baseAmount'], 2)); ?></td>
                        <td class="tab"><?php echo e(number_format($amounts['discount'], 2)); ?></td> 
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
                <tr>
                    <td colspan="7">
                        1. संपत्ति कर कुल देय राशि 10% है।/Total due property tax is 10%.
                    </td>
                    <td class="bold">₹<?php echo e(number_format($TotalAmount, 2)); ?>/-</td>
                </tr>
            
                <tr>
                    <td colspan="7">
                        2. जल कर 7% कार्य प्रगति पर है।/Water tax (7%) 
                    </td>
                    <td class="bold">₹<?php echo e(number_format($WTotalAmount, 2)); ?>/-</td>
                </tr>
                <tr>
                    <td colspan="7">
                        2. ड्रैनेज  कर 2.5% कार्य प्रगति पर है।/Water tax (2.5%) 
                    </td>
                    <td class="bold">₹<?php echo e(number_format($DTotalAmount, 2)); ?>/-</td>
                </tr>
            </table>

            <table>
                <tr>
                    <th colspan="4" class="table-header">4. संपत्ति का चित्र एवं जीआईएस मैप</th>
                </tr>
                <tr>
                    <td  width="300px">संपत्ति का फोटोग्राफ</td>
                    <td>जी आई एस मैप</td>
                </tr>
                <tr>
                    <td>
                        <img style="width: 120px; height: 120px;" src="<?php echo e(asset('')); ?>storage/<?php echo e($property->propertyFirstImage); ?>" alt="Property Image 1">
                        <img style="width: 120px; height: 120px;" src="<?php echo e(asset('')); ?>storage/<?php echo e($property->propertyFirstImage); ?>" alt="Property Image 1">
                    </td> 
                    <td>
                        <div id="map<?php echo e($property->id); ?>" style="height: 120px; width: 100%;"></div>
                    </td>
                </tr>
            </table>
            <table>
                <tr> 
                    <td colspan="3">कृपया नोटिस प्राप्ति के 15 दिवस के अन्दर यदि कोई आपत्ति हो तो पालिका मे दाखिल करें |  अन्यथा की स्थिति में  आपकी स्वीकृती मानते हुए उक्त मूल्यांकित दर प्रभावी कर दी जायेगी। वाद मियाद डिमांड कायम करते हुये नगर पालिका अधिनियम 1916 की धारा 141 क 2 के अनुसार शास्ति निर्धारण करते हुए बिल मांग प्रेषित की जायेगी एवं अधिनियम 1916 की धारा 144 एवं भूमि/भवन स्वकर निर्धारण नियमावली 2024 के अन्तर्गत वसूली की जाऐगी एवं निर्धारण अवधि में कर जमा करने पर सम्पत्ति कर में छूट एवं निर्धारण अवधी में कर जमा न करने पर व्याज सहित वसूला जाऐगा।
                        <br>
                        नोटः- उक्त कर निर्धारण वाद प्रक्रिया हेतु मान्य नहीं होगा एवं कोई भी भवन स्वामी का उक्त प्रक्रिया एवं कर रसीद के स्वामित्व का दावा मान्य नहीं होगा। यदि पूर्व में गृह कर की धन राशि बकाया है तो वह मांग के अनुसार देय होगी।
                    </td>
                </tr>
                <tr>
                    <td> <b id="ht-<?php echo e($key2); ?>"></b> <br><br><br> </td> 
                </tr>
                <tr>
                    <td style="text-align: right;"> 
                        अधिशासी अधिकारी/टैक्स कलेक्टर
                    </td> 
                </tr> 
                   
            </table>
        </div>
    </div>
      
     
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
    <style>
/* Pagination Container */
nav[role="navigation"] {
  display: flex;
  justify-content: center;
  margin-top: 30px;
  padding: 10px 0;
  flex-wrap: wrap;
  gap: 8px;
}

/* Flex utilities */
.flex {
  display: flex;
}

.justify-between {
  justify-content: space-between;
}

.flex-1 {
  flex: 1;
}

/* Hide on small screens */
.sm\:hidden {
  display: none;
}

/* Pagination Buttons and Spans */
a, span {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  padding: 8px 14px;
  font-size: 16px;
  font-weight: 500;
  border: 1px solid #ddd;
  border-radius: 4px; /* Rectangular */
  text-decoration: none;
  color: #555;
  background-color: #f7f7f7;
  transition: all 0.3s ease;
  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

/* Hover and Focus States */
a:hover,
a:focus {
  background-color: #4CAF50;
  color: white;
  border-color: #4CAF50;
  transform: translateY(-2px);
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
}

a:hover svg,
a:focus svg {
  fill: white;
}

/* Disabled State for Span */
span {
  cursor: not-allowed;
  background-color: #e5e5e5;
  border-color: #ccc;
  color: #aaa;
  transform: translateY(0);
  box-shadow: none;
}

/* Previous and Next Buttons */
a[rel="prev"],
a[rel="Next"] {
  background-color: #fff;
  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

a[rel="prev"]:hover,
a[aria-label="Next"]:hover {
  background-color: #e0e0e0;
}

/* Active Page */
span[aria-current="page"] {
  background-color: #007bff;
  color: white;
  border-color: #007bff;
  font-weight: 600;
  transform: translateY(-2px);
}

/* Page Number Hover Effect */
a[aria-label^="Go to page"]:hover,
a[aria-label^="Go to page"]:focus {
  background-color: #007bff;
  color: white;
  border-color: #007bff;
}

/* SVG Arrow Styles */
a[rel="prev"] svg, 
a[rel="Next"] svg {
  width: 16px;
  height: 16px;
  margin-right: 6px;
  fill: #555;
  transition: fill 0.3s ease;
}

/* Responsive for Small Screens */
@media (max-width: 640px) {
  .sm\:hidden {
    display: block;
  }

  .sm\:flex-1 {
    display: flex;
    justify-content: center;
  }

  .sm\:items-center {
    align-items: center;
  }

  .flex-1 {
    display: block;
  }
}



    </style>
        <div style="text-align: center; margin-top: 20px;">
            <?php echo e($properties->appends(request()->query())->links()); ?> 
        </div>

    <script> 
            
        function initMap(mapId, lat, lng) {
            var location = { lat: lat, lng: lng };
            var map = new google.maps.Map(document.getElementById(mapId), {
                zoom: 20,
                center: location,
                mapTypeId: 'satellite' // Change this to 'roadmap', 'hybrid', or 'terrain' as needed
            });
            new google.maps.Marker({
                position: location,
                map: map,
                title: "Property Location"
            });
        }

        // Wait until the Google Maps script is loaded
        window.addEventListener('load', function () {
            <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                initMap('map<?php echo e($property->id); ?>', <?php echo e($property->latitude ?? 0.000); ?>, <?php echo e($property->longitude ?? 0.000); ?>);
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        });
    </script>

    
<script>
    window.addEventListener("beforeprint", function () {
        // Remove existing styles (if any)
        document.querySelectorAll("[id^='dynamic-print-style-']").forEach(style => style.remove());

        // Get all .body and .tt elements (one per property)
        const bodies = document.querySelectorAll(".body");

        bodies.forEach((body, index) => {
            const tt = body.querySelector(".tt");
            const ttHeight = tt.offsetHeight;
            //document.getElementById("ht-" + index).innerHTML = ttHeight; 
            let newHeight = 1124; // default height
            if (ttHeight > 1123) {
                newHeight = 2240;
            }

            // Create a unique class per body if needed
            const bodyId = `body-${index}`;
            body.classList.add(bodyId);

            // Create a unique style tag for each
            const style = document.createElement("style");
            style.id = `dynamic-print-style-${index}`;
            style.innerHTML = `
                @media print {
                    .${bodyId} {
                        height: ${newHeight}px !important;
                    }
                }
            `;
            document.head.appendChild(style);
        });
    });

    // Cleanup styles after print
    window.addEventListener("afterprint", function () {
        document.querySelectorAll("[id^='dynamic-print-style-']").forEach(style => style.remove());
    });
</script>
    
    
</body>
</html>

 <?php /**PATH /home/npgovardhan25/public_html/resources/views/admin/property-surveyors/print-ward-demand-notice.blade.php ENDPATH**/ ?>