<?php
    use App\Models\Ward;
    use App\Models\User;
    use App\Models\FloorType;
    
    $wards = Ward::all();
    $users = User::all();
    $floors = FloorType::where('status',1)->get();
?>

<?php $__env->startSection('style'); ?>
<link href='https://cdn.jsdelivr.net/npm/froala-editor@latest/css/froala_editor.pkgd.min.css' rel='stylesheet' type='text/css' />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">All Property Surveyors </div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page"> Property Surveyors </li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <!-- Displaying Success Message -->
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <!-- Displaying Error Messages -->
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
        </div>
      <!-- Include jQuery -->
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Property Surveyors List</h6>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row mb-2">
                            <div class="col-md-2">
                                <select id="no_of_row" class="form-select  ">
                                    <option value="15">15</option> 
                                    <option value="50">50</option> 
                                    <option value="100">100</option>
                                    <option value="150">150</option>
                                    <option value="200">200</option>
                                    <option value="250">250</option> 
                                    <option value="500">500</option> 
                                    <option value="1000">1000</option>
                                    <option value="1500">1500</option>
                                    <option value="1500">2000</option>
                                    <option value="1500">2500</option>
                                    <option value="1500">3000</option>
                                    <option value="1500">3500</option>
                                    <option value="1500">4000</option>
                                </select>
                            </div>
                            <div class="col-md-2"> 
                                <select id="wardNo" class="form-select  ">
                                    <option value="">All Ward</option> 
                                    <?php $__currentLoopData = $wards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$ward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($ward->id); ?>" ><?php echo e($ward->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2"> 
                                <select id="userId" class="form-select  ">
                                    <option value="">All Users</option> 
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>" ><?php echo e($user->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">  
                                <input type="date" name="startDate" id="startDate" class="form-control" > 
                            </div>
                            <div class="col-md-2">  
                                <input type="date" name="endDate" id="endDate" class="form-control" > 
                            </div>
                            <div class="col-md-2"> 
                                <input type="submit" value="Search" class="btn btn-primary" onclick="loadS()">
                            </div>
                            
                            <!--<div class="col-md-2"> -->
                            <!--    <button id="exportPDF" class="btn btn-danger">Export to PDF</button>-->
                            <!--</div>--> 
                            <!-- Export Buttons -->
                        </div>
                        
                        <div class="row mb-2">
                            <div class="col-md-2">
                                <!-- Dropdown for column selection -->
                              <select id="columnSelect" class="form-select">
                                <option value="">All</option>
                            
                                <option value="0">SN</option>
                                <option value="1">Actions</option>
                                <option value="2">Status</option>
                                <option value="3">Surveyor Name</option>
                                <option value="4">Assessment Year</option>
                                <option value="5">Survey ID</option>
                                <option value="6">Date of Survey</option>
                                <option value="7">Owner Name</option>
                                <option value="8">Owner Father Name</option>
                                <option value="9">Mobile No</option>
                                <option value="10">Ward Name</option>
                                <option value="11">Is Slum</option>
                                <option value="12">Parcel No</option>
                                <option value="13">Property No</option>
                                <option value="14">Electricity ID</option>
                                <option value="15">Khasra No</option>
                                <option value="16">Registry No</option>
                                <option value="17">Constructed Date</option>
                                <option value="18">Respondent Name</option>
                                <option value="19">Respondent Relationship</option>
                                <option value="20">Owner Aadhaar Number</option>
                                <option value="21">City</option>
                                <option value="22">Pincode</option>
                                <option value="23">Is Same As Property</option>
                                <option value="24">House No</option>
                                <option value="25">Street Name</option>
                                <option value="26">Locality</option>
                                <option value="27">Colony</option>
                                <option value="28">Present House No</option>
                                <option value="29">Present Street Name</option>
                                <option value="30">Present Locality</option>
                                <option value="31">Present Colony</option>
                                <option value="32">Present City</option>
                                <option value="33">Present Pincode</option>
                                <option value="34">Tax Rate Zone</option>
                                <option value="35">Property Ownership</option>
                                <option value="36">Property Type</option>
                                <option value="37">Property Uses</option>
                                <option value="38">Year of Construction</option>
                                <option value="39">Situation</option>
                                <option value="40">Road Type</option>
                                <option value="41">Floors</option>
                                <option value="42">Plot Area SqFt</option>
                                <option value="43">Plot Area SqMeter</option>
                                <option value="44">Plinth Area SqFt</option>
                                <option value="45">Plinth Area SqMeter</option>
                                <option value="46">Total Built Up Area SqFt</option>
                                <option value="47">Total Built Up Area SqMeter</option>
                                <option value="48">Is Municipal Water Supply</option>
                                <option value="49">Total Water Connection</option>
                                <option value="50">Water Connection Id/Type</option>
                                <option value="51">Toilet Type</option>
                                <option value="52">Is Municipal Waste Service</option>
                            </select>

                                 
                            </div>
                              
                            <div class="col-md-2"> 
                                <input type="text" id="searchQuery" placeholder="Search..."  class="form-control"> 
                                <!--oninput="loadSurveys(1)"-->
                            </div>
                            <div class="col-md-6">  
                            </div>
                            <div class="col-md-2"> 
                                <button id="exportExcel" class="btn btn-primary">Export to Excel</button>
                            </div>
                            <!--<div class="col-md-2"> -->
                            <!--    <button id="exportPDF" class="btn btn-danger">Export to PDF</button>-->
                            <!--</div>--> 
                            <!-- Export Buttons -->
                        </div>
                        
                        <style>
                            .table-wrapper {
                              max-height: 600px;  /* Set the desired height for the table */
                              overflow-y: auto;   /* Enables vertical scrolling */
                              display: block;     /* Makes the table wrapper block-level so that the scrolling works */
                            }
                          
                            .table {
                              width: 100%;
                              border-collapse: collapse;  /* Ensures no space between table borders */
                            }
                          
                            .table thead {
                              background: #ffc107; /* Optional: Adds a background color to the header */
                              position: sticky;     /* Makes the header sticky */
                              top: 0;               /* Sticks the header to the top */
                              z-index: 1;           /* Ensures the header stays above the table body */
                            }
                          
                            .table th, .table td {
                              padding: 8px;         /* Adds padding to the cells */
                              border: 1px solid #ddd; /* Adds a border to the cells */
                            }
                          </style>
                        <div class="table-responsive">
                            <div class="table-wrapper"> 
                                <table class="table" id="example22">
                                    
                                    <thead>
                                        <tr>
                                            <th>SN</th>
                                            <th>Actions</th>
                                            <th>Status</th>
                                            <th>Surveyor Name</th> 
                                            <th>Assessment Year</th>
                                            <th>Survey Id</th> 
                                            <th>Date of Survey </th> 
                                            <th>Owner Name</th>
                                            <th>Owner Father Name</th>
                                            <th>Mobile No</th>
                                            <th>Ward Name</th> 
                                            <th>Is Slum</th>
                                            <th>Parcel No</th>
                                            <th>Property No</th>
                                            <th>Electricity ID</th>
                                            <th>Khasra No</th>
                                            <th>Registry No</th>
                                            <th>Constructed Date</th>
                                            <th>Respondent Name</th>
                                            <th>Respondent Relationship</th>
                                            <th>Owner Aadhaar Number</th>
                                            <th>City</th>
                                            <th>Pincode</th>
                                            <th>Is Same As Property</th>
                                            <th>House No</th>
                                            <th>Street Name</th>
                                            <th>Locality</th>
                                            <th>Colony</th>
                                            <th>Present House No</th>
                                            <th>Present Street Name</th>
                                            <th>Present Locality</th>
                                            <th>Present Colony</th>
                                            <th>Present City</th>
                                            <th>Present Pincode</th>
                                            <th>Tax Rate Zone</th>
                                            <th>Property Ownership</th>
                                            <th>Property Type</th>
                                            <th>Property Uses</th>
                                            <th>Year of Construction</th>
                                            <th>Situation</th>
                                            <th>Road Type</th>
                                            <th>Floors</th>
                                            <th>Plot Area SqFt</th> 
                                            <th>Plot Area SqMeter</th> 
                                            <th>Plinth Area SqFt</th> 
                                            <th>Plinth Area SqMeter</th>
                                            <th>Total Built Up Area SqFt</th>
                                            <th>Total Built Up Area SqMeter</th>
                                            <th>Is Muncipal Water Supply</th> 
                                            <th>Total Water Connection</th>
                                            <th>Water Connection Id/Type</th>
                                            <th>Toilet Type</th>
                                            <th>Is Muncipal Waste Service</th>
                                            <th>Is Muncipal Water Supply</th>
                                            <th>Is Muncipal Water Supply</th>
                                        </tr>
                                    </thead> 
                                    <tbody id="surveyTableBody"></tbody>
                                </table>
                            </div>
                            <!-- Pagination (Previous & Next buttons only) -->
                            <div class="pagination" id="paginationLinks"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script> 
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.20/jspdf.plugin.autotable.min.js"></script>
<script>

    function loadS() 
    {
        event.preventDefault();  
        loadSurveys(1);
    }
//$(document).ready(function () {
    // Load surveys on page load
    loadSurveys(1);

    // Function to load survey data via AJAX
    function loadSurveys(page) {
        let no_of_row = $("#no_of_row").val();
        let wardNo = $("#wardNo").val(); 
        let userId = $("#userId").val();
        let startDate = $("#startDate").val(); // Get the search query from the input
        let endDate = $("#endDate").val(); // Get the search query from the input
        
        let floorsType = '';
        $.ajax({  url: '<?php echo e(route("gis.floors.index")); ?>',  type: 'GET', dataType: 'json', success: function (floor)  { floorsType = floor; } })
        let floorUsageTypes = '';
        $.ajax({  url: '<?php echo e(route("gis.floorUsageTypes.index")); ?>',  type: 'GET', dataType: 'json', success: function (floorUsageType)  { floorUsageTypes = floorUsageType; } })
        let floorUsageFactors = '';
        $.ajax({  url: '<?php echo e(route("gis.floorUsageFactors.index")); ?>',  type: 'GET', dataType: 'json', success: function (floorUsageFactor)  { floorUsageFactors = floorUsageFactor; } })
        let natureOfConstructionLists = '';
        $.ajax({  url: '<?php echo e(route("gis.natureOfConstructionLists.index")); ?>',  type: 'GET', dataType: 'json', success: function (natureOfConstructionList)  { natureOfConstructionLists = natureOfConstructionList; } })

        $.ajax({
            url: '<?php echo e(route("gis.property-data")); ?>?page=' + page + '&perPage=' + no_of_row + '&wardNo=' + wardNo + '&userId=' + userId + '&startDate=' + startDate + '&endDate=' + endDate,  
            type: 'GET',
            dataType: 'json',
            success: function (response) {
                console.log(response);
                // Populate the table
                let tableBody = $('#surveyTableBody');
                tableBody.empty();  // Clear current table data 
                let ii = (response.current_page > 1) ? (response.current_page - 1 ) * no_of_row + 1  : 1; 
                $.each(response.data, function (index, survey) {
                    // Extract owner details
                    //console.log(response.me.role.id)
                    //if(response.me.role.id==1)
                    let ownerDetails = null;
                    if (typeof survey.ownerDetails === 'string') 
                    {    
                        ownerDetails = JSON.parse(survey.ownerDetails);
                    } 
                    else 
                    {
                        ownerDetails = survey.ownerDetails; 
                    }
                    
                    //let ownerDetails = JSON.parse(survey.ownerDetails);
                    let ownerName = 'N/A';
                    if (ownerDetails.length > 0) {
                        ownerName = ['Naa','Na ','Na','Noo','Nooo'].includes(ownerDetails[0].name) ? 'N/A' : ownerDetails[0].name;
                    }
 
                    let fatherName = 'N/A';
                    if (ownerDetails.length > 0) {
                        fatherName = ['Naa','Na ','Na','Noo','Nooo'].includes(ownerDetails[0].fatherName) ? 'N/A' : ownerDetails[0].fatherName;
                    }
                    let mobile = ownerDetails.length > 0 ? ownerDetails[0].mobile : 'N/A';
                    const date = new Date(survey.created_at);
                    //const formattedDate = date.toLocaleDateString('en-GB'); // en-GB uses dd/mm/yyyy format 
                    const options = {
                      //weekday: 'long', // "Monday"
                      year: 'numeric', // "2025"
                      month: 'long', // "March"
                      day: 'numeric', // "11"
                      hour: '2-digit', // "14"
                      minute: '2-digit', // "30"
                      second: '2-digit', // "00"
                      hour12: true // Enable AM/PM format
                    };
                    
                    let floorData = JSON.parse(survey.floorData ?? survey.floors );
                    if (!Array.isArray(floorData)) {
                        floorData = JSON.parse(floorData);
                    }
                    
                                        
                    const plinth = {};
                    const plinthSm = {};
                    
                    floorData.forEach(floor => {
                        const type = floor.floorType;
                        const area = parseFloat(floor.areaSqFt) || 0;
                        const areaSm = parseFloat(floor.areaSqMt) || 0;
                    
                        if (!plinth[type]) {
                            plinth[type] = 0;
                            plinthSm[type] = 0;
                        }
                    
                        plinth[type] += area;
                        plinthSm[type] += areaSm;
                    });
                    
                    // Get the first values
                    const firstPlinthValue = Object.values(plinth)[0];
                    const firstPlinthSmValue = Object.values(plinthSm)[0];
                    
                    console.log(firstPlinthValue);
                    console.log(firstPlinthSmValue);
                    
                    // ✅ Total plinth areas
                    const totalPlinth = Object.values(plinth).reduce((sum, val) => sum + val, 0);
                    const totalPlinthSm = Object.values(plinthSm).reduce((sum, val) => sum + val, 0);
                    
                    // ✅ Format to 2 decimal places
                    const totalPlinthFormatted = totalPlinth.toFixed(2);
                    const totalPlinthSmFormatted = totalPlinthSm.toFixed(2);
                    
                    function floorType(floorType, floors) {
                        console.log('floorType:-',floorType);
                        console.log('floors:-',floors);
                        const floorId = parseInt(floorType);
                        const floor = floors.find(f => f.id === floorId);
                        return floor ? floor.name : '-';
                    }
                    
                    function usageType(usageType, floorUsageType) {
                        const usageTypeId = parseInt(usageType);
                        const type = floorUsageType.find(t => t.id === usageTypeId);
                        return type ? type.type_name : '-';
                    }
                    
                    function usageFactors(usageFactor, usageFactors) {
                        const usageFactorId = parseInt(usageFactor);
                        const factor = usageFactors.find(f => f.id === usageFactorId);
                        return factor ? factor.name : '-';
                    }
                    
                    function natureOfConstructions(constructionType, natureOfConstructionLists) {
                        const constructionTypeId = parseInt(constructionType);
                        const type = natureOfConstructionLists.find(t => t.id === constructionTypeId);
                        return type ? type.name : '-';
                    }


                    const formattedDate = date.toLocaleString('en-GB', options);
                    // Construct table row with all data from the JSON
                    let floors =`<table class="table table-bordered" >
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Floor Type</th>
                                        <th>Area SqFt</th> 
                                        <th>Area SqMt </th> 
                                        <th>Usage Type</th>
                                        <th>Usage Factor</th>
                                        <th>Construction Type</th> 
                                    </tr>
                                </thead>`;
                    
                    $.each(floorData, function (inIndex, floor) 
                    {
                        //console.log(floor);
                        floors +=`<tr>
                                    <td>${inIndex+1}</td>
                                    <td>${ floor.floorType == 'Other' ? floor.floorType + '('+ floor.floorTypeOther+')'   : floorType(floor.floorType, floorsType) }</td>
                                    <td>${floor.areaSqFt}</td>
                                    <td>${floor.areaSqMt}</td>
                                    <td>${ floor.usageType == 'Other' ? floor.usageType + '('+ floor.usageTypeOther+')'   : usageType(floor.usageType, floorUsageTypes) }</td>
                                    <td>${ floor.usageFactor == 'Other' ? floor.usageFactor + '('+ floor.usageFactorOther+')'   : usageFactors(floor.usageFactor, floorUsageFactors) }</td>
                                    <td>${ floor.constructionType == 'Other' ? floor.constructionType + '('+ floor.constructionTypeOther+')'   : natureOfConstructions(floor.constructionType , natureOfConstructionLists) }</td>
                                </tr>`; 
                    });
                    floors +=`</table>`;
                    floors =``;
                    
                    tableBody.append(`
                        <tr>
                            <td>${ii++}</td>
                            <td>
                                <div class="btn-group">
                                    <button class="btn btn-primary btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        Action
                                    </button>
                                    <div class="dropdown-menu" style="">
                                        <?php if(has_permission(['Properties'], 'demand-notice-print')): ?>
                                        <a target="_blank" href="<?php echo e(route('gis.properties.demand-notice-print', '')); ?>/${survey.id}" class="dropdown-item edit-btn" >Demand Notice Print</a>
                                        <?php endif; ?>
                                        <?php if(has_permission(['Properties'], 'show')): ?>
                                        <a target="_blank" href="<?php echo e(route('gis.properties.show', '')); ?>/${survey.id}" class="dropdown-item edit-btn" >View</a>
                                        <?php endif; ?>
                                        <?php if(has_permission(['Properties'], 'edit')): ?>
                                        <a target="_blank" href="<?php echo e(url('gis/properties/${survey.id}/edit')); ?>" class="dropdown-item edit-btn">Edit</a>  
                                        <?php endif; ?>
                                        <?php if(has_permission(['Properties'], 'destroy')): ?>
                                        <form action="<?php echo e(route('gis.property.destroy','')); ?>${survey.id}" method="POST" style="display:inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <input type="hidden" value="${survey.id}" name="id">
                                            <button type="submit" class="dropdown-item edit-btn" onclick="return confirm('Are you sure you want to delete this Property Surveyors Data?');">Delete</button>
                                        </form> 
                                        <?php endif; ?>
                                    </div>
                                </div> 
                            </td> 
                             <td><a target="_blank"  data-status="<?php echo e((has_permission(['Properties'], 'in-progress') || has_permission(['QC-Level-1'], 'status') || has_permission(['Properties'], 'QC-Level-2') || has_permission(['Properties'], 'QC-Done') ) ? url('gis/properties/status/${survey.id}/${getSurveyStatus(survey.status)[`value`]}') : '#'); ?>" class="btn ${getSurveyStatus(survey.status)['class']} btn-sm btn-status">${getSurveyStatus(survey.status)['label']}</a></td>
                            <td><a target="_blank" href="<?php echo e((has_permission(['Properties'], 'user-profile')) ? route('gis.property.user.show', '') : '#'); ?>/${survey.user.id}" class="btn btn-dark btn-sm">${survey.user.name}</a></td>
                             <td>${survey.period}</td>
                            <td>${survey.nagarpalikaId}</td>
                            <td>${formattedDate}</td>
                            <td>${ownerName}</td>
                            <td>${fatherName}</td>
                            <td>${mobile}</td>
                            <td>${survey.ward.name}</td> 
                            <td>${survey.isSlum}</td>
                            <td>${survey.parcelNo}</td>
                            <td>${survey.propertyNo}</td>
                            <td>${survey.electricityId ? survey.electricityId : 'N/A'}</td>
                            <td>${survey.khasraNo ? survey.khasraNo : 'N/A'}</td>
                            <td>${survey.registryNo ? survey.registryNo : 'N/A'}</td>
                            <td>${survey.constructedDate}</td>
                            <td>${['Naa','Na ','Na','Noo','Nooo'].includes(survey.respondentName) ? 'N/A' : survey.respondentName}</td>
                            <td>${survey.respondent_relation_data?.name}</td>
                            <td>${survey.ownerAadhaarNumber ? survey.ownerAadhaarNumber : 'N/A'}</td>
                            <td>${survey.city}</td>
                            <td>${survey.pincode}</td>
                            <td>${survey.isSameAsProperty}</td>
                            <td>${ ['Naa','Na ','Na','Noo','Nooo'].includes(survey.houseNo) ? 'N/A' : survey.houseNo }</td>
                            <td>${survey.streetNoName}</td>
                            <td>${survey.locality}</td>
                            <td>${survey.colony}</td>
                            <td>${ ['Naa','Na ','Na','Noo','Nooo'].includes(survey.presentHouseNo) ? 'N/A' : survey.presentHouseNo}</td>
                            <td>${survey.presentStreetNoName}</td>
                            <td>${survey.presentLocality}</td>
                            <td>${survey.presentColony}</td>
                            <td>${survey.presentCity}</td>
                            <td>${survey.presentPincode}</td>
                            <td>${ survey.tax_rate_zone_data?.name }</td> 
                            <td>${ survey.property_ownership_data?.name }</td>  
                            <td>${ survey.property_type_data?.type_name }</td>  
                            <td>${ survey.property_use_data?.name }</td> 
                             
                            <td>${ survey.year_of_construction_data?.name}</td>
                            <td>${ survey.situation_data?.name }</td> 
                            <td>${ survey.road_type_data?.name }</td>  
                            <td>${ floorData.map(floor => `${ floorType(floor.floorType, floorsType) } - ${floor.areaSqFt} SqFt - ${floor.areaSqMt} SqMt 
                            || Usage Type - ${  usageType(floor.usageType, floorUsageTypes) }
                            || Usage Factor - ${  usageFactors(floor.usageFactor, floorUsageFactors) }
                            || Usage Type - ${ natureOfConstructions(floor.constructionType , natureOfConstructionLists) }`).join(",<br> ") }</td> 
                            <td>${survey.plotAreaSqFt}</td> 
                            <td>${survey.plotAreaSqMeter}</td> 
                            <td>${ firstPlinthValue?.toFixed(2) ?? survey.plinthAreaSqFt}</td> 
                            <td>${ firstPlinthSmValue?.toFixed(2) ?? survey.plinthAreaSqMeter}</td>
                            <td>${ totalPlinthFormatted ?? survey.totalBuiltUpAreaSqFt}</td>
                            <td>${ totalPlinthSmFormatted ?? survey.totalBuiltUpAreaSqMeter}</td>
                            <td>${ survey.isMuncipalWaterSupply}</td>
                            <td>${ survey.totalWaterConnection}</td>
                            <td>${ survey.waterConnectionId}</td>
                            <td>${ survey.toilet_type_data?.name }</td> 
                            <td>${ survey.isMuncipalWaterSupply}</td>
                            <td>${ survey.isMuncipalWasteService}</td> 
                            <td>${ survey.source_of_water_data?.name }</td> 
                        </tr>
                    `);
                });

                // Update pagination with Previous and Next buttons
                let paginationLinks = $('#paginationLinks');
                paginationLinks.empty();

                // Previous button
                if (response.prev_page_url) 
                {
                    paginationLinks.append(`<a href="#" class="btn btn-secondary btn-sm" id="prevBtn">Previous</a>`);
                } else {
                    paginationLinks.append(`<span class="btn btn-light btn-sm">Previous</span>`);
                }

                // Next button
                if (response.next_page_url) {
                    paginationLinks.append(`<a href="#" class="btn btn-secondary btn-sm" id="nextBtn">Next</a>`);
                } else {
                    paginationLinks.append(`<span class="btn btn-light btn-sm">Next</span>`);
                }

                // Last button
                if (response.last_page_url) {
                    paginationLinks.append(`<a href="#" class="btn btn-secondary btn-sm" id="lastBtn">Last</a>`);
                } else {
                    paginationLinks.append(`<span class="btn btn-light btn-sm">Last</span>`);
                }

                // Handle Previous button click
                $('#prevBtn').on('click', function (e) {
                    e.preventDefault();
                    if (response.prev_page_url) {
                        loadSurveys(new URL(response.prev_page_url).searchParams.get('page')); // Get the previous page number from URL
                    }
                });

                // Handle Next button click
                $('#nextBtn').on('click', function (e) {
                    e.preventDefault();
                    if (response.next_page_url) {
                        loadSurveys(new URL(response.next_page_url).searchParams.get('page')); // Get the next page number from URL
                    }
                });

                // Handle Last button click
                $('#lastBtn').on('click', function (e) {
                    e.preventDefault();
                    if (response.last_page_url) {
                        loadSurveys(new URL(response.last_page_url).searchParams.get('page')); // Get the last page number from URL
                    }
                });
            },
            error: function () {
                alert('Error loading survey data.');
            }
        });
    }
    
     
    function getSurveyStatus(status) {
        const statusMap = {
            0: { label: 'In-progress', class: 'btn-warning', value: 1, },
            1: { label: 'QC Level 1', class: 'btn-primary', value: 2 },
            2: { label: 'QC Level 2', class: 'btn-info' , value: 3},
            3: { label: 'QC Done', class: 'btn-success', value: 4 },
            4: { label: 'Completed', class: 'btn-dark', value: 4 }
        };
        
        return statusMap.hasOwnProperty(status) ? statusMap[status] : 'Unknown';
    }


//});

</script>

<script>
    // Function to search and filter the table
    function searchTable() {
    let searchQuery = $("#searchQuery").val().toLowerCase(); // Get the search query and convert to lowercase
    let selectedColumn = $("#columnSelect").val(); // Get the selected column index (empty string for "All")
    let tableRows = $('#surveyTableBody tr'); // Get all rows in the table body

        tableRows.each(function () {
            let row = $(this); // Get the current row
    
            if (selectedColumn === "") {
                // Search across all columns if "All" is selected
                let rowText = row.text().toLowerCase(); // Get all the text content of the row
                if (rowText.indexOf(searchQuery) > -1) {
                    row.show();
                } else {
                    row.hide();
                }
            } else {
                // Otherwise, search only the selected column
                let cell = row.find('td').eq(selectedColumn); // Get the selected column in the row
                let cellText = cell.text().toLowerCase(); // Get the text of that cell and convert it to lowercase
    
                // If the cell contains the search query, show the row, otherwise hide it
                if (cellText.indexOf(searchQuery) > -1) {
                    row.show();
                } else {
                    row.hide();
                }
            }
        });
    }
    
    // Trigger search on input change
    $("#searchQuery").on("input", function() {
        searchTable(); // Call the search function when the user types in the search box
    });
    
    // Optional: Trigger search on column change
    $("#columnSelect").on("change", function() {
        searchTable(); // Call the search function when the user changes the column
    });

</script>

<!-- Add the export functionality -->
<script>
    // Excel export
    document.getElementById("exportExcel").addEventListener("click", function () 
    {
        // loadSurveys2(1);
        // setTimeout(function() 
        // { 
            var wb = XLSX.utils.table_to_book(document.getElementById('example22'), { sheet: "Survey Data" });
            XLSX.writeFile(wb, 'survey_data.xlsx'); 
        //}, 5000);  // 2000 milliseconds = 2 seconds
        
    });

    // PDF export
    // document.getElementById("exportPDF").addEventListener("click", function () {
    //     const { jsPDF } = window.jspdf;
    //     const doc = new jsPDF();
    //     doc.autoTable({ html: '#example22' });
    //     doc.save('survey_data.pdf');
    // });
</script>


<!-- Add the export functionality -->
<script>
    // Excel export
    
    $(document).on("click", ".btn-status", function() {
        let statusUrl = $(this).data("status");
        $.ajax({
            url: statusUrl,
            type: "GET",
            success: function(res) {
                res.status === 'success' ? toastr.success(res.msg) : toastr.error(res.msg);
                loadSurveys(1); 
            }
        });
    });
    
    document.getElementById("downloadNotices").addEventListener("click", function () 
    {
        let wardNo = document.getElementById("wardNo").value;
        if (wardNo) {
              window.open(`<?php echo e(url('gis/properties/print-ward-demand-notice/${wardNo}')); ?>`, '_blank');
        } else {
            alert("Please enter a ward number.");
        }
    });
    document.getElementById("exportExcel").addEventListener("click", function () 
    {
        let wardNo = document.getElementById("wardNo").value;
        let wardName ='';
        if (wardNo) {
             wardName = `-Ward-No-${wardNo}`;
        }
        var wb = XLSX.utils.table_to_book(document.getElementById('example22'), { sheet: "Survey Data" });
        XLSX.writeFile(wb, `<?php echo e(env('APP_NAME')); ?>${wardName}-survey-data.xlsx`); 
    });

    // PDF export
    // document.getElementById("exportPDF").addEventListener("click", function () {
    //     const { jsPDF } = window.jspdf;
    //     const doc = new jsPDF();
    //     doc.autoTable({ html: '#example22' });
    //     doc.save('survey_data.pdf');
    // });
</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.adminApp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/npgovardhan25/public_html/resources/views/admin/property-surveyors/index.blade.php ENDPATH**/ ?>