 


<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

 <!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">All Role </div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page"> Roles  <?php echo e(print_r( has_permission(['Roles'], 'create'))); ?></li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                </div>
            </div>
        </div>
        <!--end breadcrumb-->
        <div class="row"> 
        <?php if(has_permission(['Roles'], 'create')): ?>
            <div class="col-lg-7 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white"> Add Role</h6>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(isset($edt)? route('gis.roles.update',$edt->id) : route('gis.roles.store')); ?>" id="roleForm" class="row" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php if(isset($edt)): ?>
                                <?php echo method_field('PUT'); ?> <!-- This will make the form use the PUT method for updating -->
                            <?php endif; ?>

                            <div class="col-md-12 mb-3">
                                <label for="name" class="form-label">Name *</label>
                                <input type="text" class="form-control" id="name" name="name" value="<?php echo e($edt->name ?? ''); ?>" required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <?php
                            $permissions = [ 
                                'GIS' => ['index'],
                                'App' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Dashboard' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Users' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Roles' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Permission' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Property' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Wards' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'], 
                                'Relationship-with-Owners' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Tax-Rate-Zone' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Ownership-Type' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Situations' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Property-Type' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Property-Uses' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Year-of-Constructions' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Exemption-Applicable' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Floor-Usage-Types' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Floor-Types' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Usage-Factors' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Nature-of-Construction' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                
                                'MIS' => ['index'],
                                'Properties' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status', 'tax-generate', 'properties-tax-list', 'user-profile', 
                                'print-ward-demand-notice','demand-notice-print', 'properties-export', 'cash-desk-search','in-progress','QC-Level-1','QC-Level-2','QC-Done','report'],
                                
                                
                                'Ward-Members' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Slider' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Notice-Boards' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Office-Bearers' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'], 
                                'President' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Executive-Officer' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Member-List' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Staff-Details' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                
                                'Right-to-Information-Act' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'], 
                                'Citizen-Charter' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                'Site-Settings' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                //'Gallery' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'], 
                                //'Photo-Gallery' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                                //'Video-Gallery' => ['index', 'show', 'create', 'store', 'edit', 'update', 'destroy', 'status'],
                            ];

                            ?>

            

                            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $actions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             
                            <div class="col-md-12 mb-3">
                                
                                <label for="permission" class="form-label"><?php echo e($key); ?> Permission </label>
                                <div>
                                    <!-- Check All Checkbox -->
                                    <div class="form-check form-check-inline">
                                        <input
                                            class="form-check-input"
                                            type="checkbox"
                                            id="check_all_<?php echo e($key); ?>"
                                            onclick="toggleAllCheckboxes('<?php echo e($key); ?>')"
                                        <?php echo e((isset($edt->permission[$key]) && count($edt->permission[$key]) == count(auth()->user()->role->permission[$key])) ? 'checked' : ''); ?>

                                            
                                        >
                                        <label class="form-check-label" for="check_all_<?php echo e($key); ?>">
                                            Check All
                                        </label>
                                    </div>
                                    <!-- Individual Permission Checkboxes --> 
                                    <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            
                                        <div class="form-check form-check-inline">
                                            <input
                                                class="form-check-input permission-checkbox"
                                                type="checkbox"
                                                id="permission_<?php echo e($key); ?>_<?php echo e($action); ?>"
                                                name="permission[<?php echo e($key); ?>][]"
                                                onchange="updateCheckAllStatus('<?php echo e($key); ?>')"
                                                value="<?php echo e($action); ?>"
                                                <?php echo e((isset($edt) && in_array($action, $edt->permission[$key] ?? [])) ? 'checked' : ''); ?>

                                            >
                                            <label class="form-check-label" style="text-transform: capitalize;" for="permission_<?php echo e($key); ?>_<?php echo e($action); ?>">
                                                <?php echo e($action); ?>

                                            </label>
                                        </div>
                                         
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </div>
                            </div>
                             
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            <?php if(has_permission(['Roles'], 'status')): ?> 
                            <div class="col-md-12 mb-3">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-control" id="status" name="status">
                                    <option value="1" <?php echo e((isset($edt) && $edt->status == 1) ? 'selected' : ''); ?>>Active</option>
                                    <option value="0" <?php echo e((isset($edt) && $edt->status == 0) ? 'selected' : ''); ?>>Inactive</option>
                                </select>
                            </div>
                            <?php endif; ?>
                            <div class="col-md-12 m-1 row">
                                <div class="col-md-2 m-1">
                                    <input type="hidden" value="" id="id" name="id" /> 
                                    <button type="submit" class="btn btn-primary">Save </button>
                                </div>
                                <div class="col-md-2 m-1">
                                    <a href="<?php echo e(route('gis.roles.index')); ?>" class="btn btn-secondary">Cancel</a>
                                </div>
                            </div>  

                        </form>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <!-- Displaying Success Message -->
                        <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>

                        <!-- Displaying Error Messages -->
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        <?php endif; ?> 
        <?php if(has_permission(['Roles'], 'show')): ?>
            <div class="col-lg-5 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Role List</h6>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="roleTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Created By</th>
                                        <th>Date</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        </div>
    </div>
</div>


<!-- CSRF Meta -->
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
 
 <script>
    // JavaScript to handle the 'Check All' functionality
    function toggleAllCheckboxes(key) {
        const checkAllCheckbox = document.getElementById('check_all_' + key);
        const checkboxes = document.querySelectorAll(`input[name="permission[${key}][]"]`);

        // Check/uncheck all checkboxes based on the 'Check All' checkbox
        checkboxes.forEach(checkbox => {
            checkbox.checked = checkAllCheckbox.checked;
        });

        // Update 'Check All' checkbox based on individual checkbox status
        checkAllCheckbox.checked = Array.from(checkboxes).every(checkbox => checkbox.checked);
    }

    // Function to update the 'Check All' checkbox status when individual checkboxes are toggled
    function updateCheckAllStatus(key) {
        const checkAllCheckbox = document.getElementById('check_all_' + key);
        const checkboxes = document.querySelectorAll(`input[name="permission[${key}][]"]`);

        // Check if all checkboxes are checked
        checkAllCheckbox.checked = Array.from(checkboxes).every(checkbox => checkbox.checked);
    }
</script>

<script>
    $(document).ready(function () {
        // Setup CSRF for all AJAX
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Initialize DataTable
        var table = $('#roleTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(route('gis.roles.index')); ?>",
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                { data: 'name', name: 'name' },
                { data: 'created_by', name: 'user.name' },
                { data: 'created_at', name: 'created_at' },
                { data: 'status', name: 'status' },
                { data: 'actions', name: 'actions', orderable: false, searchable: false }
            ]
        });
        

        // Submit Form (Create/Update)
        $('#roleForm').submit(function (e) {
            e.preventDefault();

            let formData = new FormData(this);
            clearErrors();

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('gis.roles.store')); ?>",
                data: formData,
                processData: false,
                contentType: false,
                success: function (res) 
                {
                    $('#roleForm')[0].reset();
                    $('#id').val('');
                    table.ajax.reload();
                    toastr.success(res.msg);
                },
                error: function (xhr) {
                    let errors = xhr.responseJSON.errors;
                    $.each(errors, function (key, value) {
                        $('.error-' + key).text(value);
                        toastr.error(value);
                    });
                }
            });
        });

        // Cancel Button
        $('#cancelBtn').click(function () {
            $('#roleForm')[0].reset();
            $('#id').val('');
            clearErrors();
        });

        // Edit Button
        $(document).on('click', '.edit-btn', function () 
        {
            let id = $(this).data('id');
            $.get(`<?php echo e(url('gis/roles/${id}/edit')); ?>`, function (data)
            {
                $('#id').val(data.id);
                $('#name').val(data.name);
                
                permission = data.permission;
                for (const module in permission) {
                    const actions = permission[module];
                    const moduleKey = module.replace(/\s+/g, '_');
                
                    let allChecked = true;
                
                    for (const action of actions) {
                      const checkboxId = `permission_${moduleKey}_${action}`;
                      const checkbox = document.getElementById(checkboxId);
                
                      if (checkbox) {
                        checkbox.checked = true;
                      } else {
                        allChecked = false;
                        console.warn(`Missing checkbox: #${checkboxId}`);
                      }
                    }
                
                    // Check the "Check All" box if all are present and checked
                    const checkAllId = `check_all_${moduleKey}`;
                    const checkAllBox = document.getElementById(checkAllId);
                    if (checkAllBox && allChecked) {
                      checkAllBox.checked = true;
                    }
                  }
                console.log(data.permission);
                $('#status').val(data.status);
                clearErrors();
            });
        });

        // Delete Button
        $(document).on('click', '.btn-delete', function () {
            if (!confirm("Are you sure you want to delete this role?")) return;

            let delUrl = $(this).data("delid");
            $.get(delUrl, function (res) {
                if (res.status === 1) {
                    toastr.success("Deleted successfully");
                } else {
                    toastr.error("Delete failed");
                }
                table.ajax.reload();
            });
        });

        function clearErrors() {
            $('.text-danger').text('');
        }
    });
</script>
<?php $__env->stopSection(); ?>
 
<?php echo $__env->make('admin.layouts.adminApp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/npgovardhan25/public_html/resources/views/admin/role.blade.php ENDPATH**/ ?>