<?php $__env->startSection('style'); ?>
<link href='https://cdn.jsdelivr.net/npm/froala-editor@latest/css/froala_editor.pkgd.min.css' rel='stylesheet' type='text/css' />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">All Relationship with Owners </div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">Relationship with Owners </li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                </div>
            </div>
        </div>
        <!--end breadcrumb-->
        <div class="row">
            <div class="col-lg-4 mx-auto">
                <div class="card"> 
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Add Relationship with Owners </h6>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(isset($edt)? route('gis.relationship-with-owners.update',$edt->id) : route('gis.relationship-with-owners.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-control" id="name" name="name" value="<?php echo e($edt->name ?? ''); ?>" required>
                                <?php $__errorArgs = ['type_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                             
                             
                            <div class="mb-3">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-control" id="status" name="status">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-primary">Save </button>
                            <a href="<?php echo e(route('gis.relationship-with-owners.index')); ?>" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <!-- Displaying Success Message -->
                        <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>

                        <!-- Displaying Error Messages -->
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="col-lg-8 mx-auto">
                <div class="card"> 
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Nature of Construction List</h6>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="example">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Type Name</th> 
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $natureOfConstruction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$nature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($k+1); ?></td>
                                        <td><?php echo e($nature->name); ?></td> 
                                        <td><?php echo e($nature->status == 1 ? 'Active' : 'Inactive'); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('admin.nature-of-construction.edit', $nature->id)); ?>" class="btn btn-warning btn-sm">Edit</a>
                                            <form action="<?php echo e(route('admin.nature-of-construction.destroy')); ?>" method="POST" style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <input type="hidden" class="btn btn-danger btn-sm" value="<?php echo e($nature->id); ?>" name="id">
                                                <!--<button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this wards?');">Delete</button>-->
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.adminApp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/npgovardhan25/public_html/resources/views/admin/relationship-with-owners.blade.php ENDPATH**/ ?>