<?php $__env->startSection('style'); ?>
<link href='https://cdn.jsdelivr.net/npm/froala-editor@latest/css/froala_editor.pkgd.min.css' rel='stylesheet' type='text/css' />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <?php 
         
        $floorData = json_decode($property->floorData);
            if(!is_array($floorData))
                $floorData = json_decode($floorData);
    ?> 

<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"> Property Surveyors </div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">View  Property Surveyors </li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="<?php echo e(route('gis.property.index')); ?>" class="btn btn-primary" > Surveyors List</a>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Basic Details</h6>
                        </div>
                    </div>
                    <div class="card-body p-4 row"> 
                        <style> table { text-transform: capitalize; } </style>
						<table class="table mb-0 table-striped">
					    	<tbody> 
					    	    <tr>
                                    <th>Assessment Year</th>
                                    <td><?php echo e($property->period); ?> </td> 
                                 
                                    <th>ULB Name/Code</th>
                                    <td><?php echo e($property->ulbNameCode); ?></td>
                                    <th>E-Nagar Panchayat Id</th>
                                    <td><?php echo e($property->nagarpalikaId); ?> </td>
                                </tr>
                                 
                                <tr>
                                    <th>Ward Number</th>
                                    <td><?php echo e($property->ward->name ?? ''); ?></td>
                                 
                                    <th>Parcel No.</th>
                                    <td><?php echo e($property->parcelNo); ?></td>
                                 
                                    <th>Property No./Unit No.</th>
                                    <td><?php echo e($property->propertyNo); ?></td>
                                </tr>
                                <tr>
                                    <th>Electricity Id.</th>
                                    <td><?php echo e($property->electricityId); ?></td>
                                
                                    <th>Khasra No.</th>
                                    <td><?php echo e($property->khasraNo); ?></td>
                                
                                    <th>Registry No.</th>
                                    <td><?php echo e($property->registryNo); ?></td>
                                </tr>
                                <tr>
                                    <th>Construction Date</th>
                                    <td><?php echo e($property->constructedDate); ?></td>
                                
                                    <th>Latitude / Longitude</th>
                                    <td><?php echo e($property->latitude); ?> / <?php echo e($property->longitude); ?></td>
                                 
                                    <th>Slum Status</th>
                                    <td><?php echo e($property->isSlum); ?> <?php echo e($property->isSlum == 'Yes' ? 'Slum ID : '.$property->slumId : ''); ?></td>
                                </tr>
                        	</tbody>
                        </table>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Owner Details</h6>
                        </div>
                    </div>
                    <div class="card-body p-4 row">  
						<table class="table mb-0 table-striped"> 
                            <tbody>
					    	    <tr>
                                    <th>Name of the Respondent:</th> 
                                    <td> <?php echo e($property->respondentName); ?> </td>
                                 
                                    <th>Relationship of Respondent with Owner :</th> 
                                    <td><?php echo e($property->respondentRelationData?->name); ?></td>
                                    <th>Aadhar No :</th> 
                                    <td><?php echo e($property->ownerAadhaarNumber); ?>

                                    <?php if(!empty($property->ownerAadhaarNumber)): ?> <br>
                                        <small class="form-text text-muted">
                                            Current file: 
                                            <a href="<?php echo e(asset('storage/' . $property->aadhaarPhoto)); ?>" target="_blank">View PDF</a>
                                        </small>
                                    <?php endif; ?>
                                    </td>
                                    <th>Number of Famliy Members :</th> 
                                    <td><?php echo e($property->number_of_members); ?></td>
                                </tr>
                                <tr>
                                    <td colspan="8"> 
						                <table class="table mb-0 table-striped"> 
                                            <tr  class="table-dark">
                                                <th>SN</th>
                                                <th>Owner Name</th>
                                                <th>Father/Husband Name</th>
                                                <th>Mobile</th>
                                                <th>Email</th>
                                                <th>Secondary Mobile</th>
                                                
                                            </tr> 
                                            <?php $__currentLoopData = (is_array($property->ownerDetails)? $property->ownerDetails : json_decode($property->ownerDetails)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$owner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr> 
                                                <td><?php echo e($k+1); ?></td>
                                                <td><?php echo e($owner->name ?? ''); ?></td>
                                                <td><?php echo e($owner->fatherName ?? ''); ?></td>
                                                <td><?php echo e($owner->mobile ?? ''); ?></td>
                                                <td><?php echo e($owner->email ?? ''); ?></td> 
                                                <td><?php echo e($owner->secondaryPhone ?? ''); ?></td>
                                            </tr> 
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>  
						                </table> 
                                    </td>    
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Address Details</h6>
                        </div>
                    </div>
                    <div class="card-body p-4 row">  
						<table class="table mb-0 table-striped"> 
                            <tbody> 
                                <tr><th>Address :</th> <td><?php echo e($property->houseNo); ?>  <?php echo e($property->streetNoName); ?> <?php echo e($property->locality); ?> <?php echo e($property->colony); ?> <?php echo e($property->city); ?> <?php echo e($property->pincode); ?> </td></tr>
                                <tr><th>Present Address :</th> <td> <?php echo e($property->presentHouseNo); ?>  <?php echo e($property->presentStreetNoName); ?> <?php echo e($property->presentLocality); ?> <?php echo e($property->presentColony); ?> <?php echo e($property->presentCity); ?> <?php echo e($property->presentPincode); ?></td></tr>  
			                
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Taxation Details/General Details of the Property</h6>
                        </div>
                    </div>
                    <div class="card-body p-4 row">  
						<table class="table mb-0 table-striped"> 
                            <tbody> 
                                <tr>
                                    <th>Current Tax Rate :</th> <td> <?php echo e($property->taxRateZoneData?->name ?? '-'); ?>  </td> 
                                    <th>Property Ownership :</th>
                                    <td> <?php echo e($property->propertyOwnershipData?->name ?? '-'); ?> </td>  
                                    <th>Situation :</th>
                                    <td> <?php echo e($property->situationData?->name ?? '-'); ?> </td> 
                                </tr>
                                <tr>
                                    <th>Property Type :</th>
                                    <td> <?php echo e($property->propertyTypeData?->type_name); ?> </td> 
                                    <th>Property Use :</th>
                                    <td> <?php echo e($property->propertyUseData?->name ?? '-'); ?> </td> 
                                    <th>Road Type :</th>
                                    <td> <?php echo e($property->roadTypeData?->name ?? '-'); ?> </td> 
                                </tr>
                                <tr> 
                                    <th>Year of Construction :</th>
                                    <td> <?php echo e($property->yearOfConstructionData?->name ?? '-'); ?> </td>
                                    
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Floor Details</h6>
                        </div>
                    </div>
                     
                    <div class="card-body p-4 row">  
						<table class="table mb-0 table-striped"> 
                            <tbody> 
                                <tr>
                                    <th>Plot Area :</th> <td><?php echo e(number_format($property->plotAreaSqFt, 2)); ?> SqFt /<?php echo e(number_format( $property->plotAreaSqMeter, 2)); ?> SqMeter  </td>
                                    <th>Plinth Area :</th> <td> <?php echo e(number_format($property->plinthAreaSqFt, 2)); ?> SqFt /<?php echo e(number_format($property->plinthAreaSqMeter, 2)); ?> SqMeter  </td>
                                    <th>Total Built-Up Area  :</th> <td> <?php echo e(number_format($property->totalBuiltUpAreaSqFt, 2)); ?> SqFt /<?php echo e(number_format( $property->totalBuiltUpAreaSqMeter, 2)); ?> SqMeter  </td>
                                </tr>  
                                <td colspan="6"> 
					                <table class="table mb-0 table-striped">
					                    <thead>
                                            <tr class="table-dark">
                                                <th>Floor Type</th>
                                                <th>Area (Sq Ft)</th>
                                                <th>Area (Sq Meter)</th>
                                                <th>Usage Type</th>
                                                <th>Usage Factor</th>
                                                <th>Construction Type</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tbody>  
                                                <?php $__currentLoopData = $floorData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$floor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                                <tr>
                                                    <td> <?php echo e(floorType($floor->floorType, $allInOne['floorType'])); ?> </td> 
                                                    <td> <?php echo e($floor->areaSqFt); ?> SqFt </td>  
                                                    <td> <?php echo e($floor->areaSqMt); ?> SqM</td> 
                                                    <td> <?php echo e(usageType($floor->usageType, $allInOne['propertyType'])); ?> </td> 
                                                    <td> <?php echo e(usageFactors($floor->usageFactor, $allInOne['usagsFactor'])); ?> </td> 
                                                    <td> <?php echo e(yearOfConstructions($floor->constructionType, $allInOne['natureOfConstruction'])); ?> </td> 
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </tbody>
                                        </tbody>
                                    </table> 
                                </td>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Muncipal Town Supply</h6>
                        </div>
                    </div>
                    <div class="card-body p-4 row">  
						<table class="table mb-0 table-striped"> 
                            <tbody> 
                                <tr>
                                    <th>Muncipal Water Supply Connection :</th> <td><?php echo e($property->isMuncipalWaterSupply); ?>   </td>
                                </tr>
                                    <?php if($property->isMuncipalWaterSupply=='yes'): ?> 
                                <tr>
                                    <th>Water Connection</th>
                                    <td> 
                                        <table class="table mb-0 table-striped"> 
                                            <tr  class="table-dark">
                                                <th>SN</th>
                                                <th>Connection Id</th>
                                                <th>Connection Type</th>   
                                            </tr> 
                                            <?php $__currentLoopData = (is_array($property->waterConnectionId)? $property->waterConnectionId : json_decode($property->waterConnectionId)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$connection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr> 
                                                <td> <?php echo e($k+1); ?></td>
                                                <td> <?php echo e($connection->id ?? ''); ?></td>
                                                <td> <?php echo e(usageType($connection->connectionType, $allInOne['propertyType'])); ?> </td> 
                                            </tr> 
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>  
						                </table>  
                                    </td>
                                </tr>
                                    <?php endif; ?> 
                                
                                <tr>
                                    <th>Source of Water  :</th> <td> <?php echo e($property->sourceOfWaterData?->name); ?>  </td>
                                </tr>
                                <tr>
                                    <th>Toilet Type   :</th> <td> <?php echo e($property->toiletTypeData?->name); ?>  </td>
                                </tr>
  
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Property Location/Image</h6>
                        </div>
                    </div>
                    <div class="card-body p-4 row">  
						<table class="table mb-0 table-striped"> 
                            <tbody> 
                                <tr>
                                    <th>Latitude/longitude</th>
                                    <th>Map</th>
                                    <th>Property First Image</th>
                                    <th>Property Second Image</th>
                                    <th>Aadhar Image</th>
                                    <th>Owner Image</th>
                                </tr>
                                <tr>
                                    
                                    <th>Latitude : <?php echo e($property->latitude); ?>   </th> 
                                    <th rowspan='2'>
                                        <style>
                                            #map {
                                                height: 180px;
                                                width: 350px;
                                            }
                                        </style>
                                        <div id="map"></div> 
                                    </th>
                                    <th rowspan="2">  
                                        <img style="width: 180px; height: 180px;"  src="<?php echo e(asset('storage/' . $property->propertyFirstImage)); ?>" onerror="this.onerror=null;this.src='<?php echo e(asset('images/no-image.png')); ?>';" alt="Property Image 1"> 
                                    </th>
                                    <th rowspan="2">
                                        <img style="width: 180px; height: 180px;" src="<?php echo e(asset('storage/' . $property->propertySecondImage)); ?>" alt="Property Image 2" onerror="this.onerror=null;this.src='<?php echo e(asset('images/no-image.png')); ?>';">
                                    </th>
                                    <th rowspan="2">
                                        <?php if($property->aadhaarPhoto): ?>
                                        <img style="width: 180px; height: 180px;" src="<?php echo e(asset('storage/' . $property->aadhaarPhoto)); ?>" alt="Property Image 2" onerror="this.onerror=null;this.src='<?php echo e(asset('images/no-image.png')); ?>';">
                                         <?php endif; ?>
                                    </th>
                                    <th rowspan="2">
                                        <?php if($property->ownerImage): ?>
                                        <img style="width: 180px; height: 180px;" src="<?php echo e(asset('storage/' . $property->ownerImage)); ?>" alt="Property Image 2" onerror="this.onerror=null;this.src='<?php echo e(asset('images/no-image.png')); ?>';">
                                        <?php endif; ?>
                                    </th>
                                </tr>
                                <tr><th>longitude  :  <?php echo e($property->longitude); ?>  </th></tr> 
                                
                            </tbody>
                        </table>
                    </div>
                </div> 
                 
                </div>
            </div>
        </div> 
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?> 
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDgFcTmfanz9rxx1l0Hl9-cMTNJF8jpgQE&callback=initMap" async defer></script>
    <script>
        function initMap() {
            // Set the location for the map
            var location = { lat: <?php echo e($property->latitude); ?>, lng: <?php echo e($property->longitude); ?> };

            // Create a new map centered at the location
            var map = new google.maps.Map(document.getElementById('map'), {
                zoom: 15,  // Adjust the zoom level
                center: location,  // Center the map at the given location
            });

            // Add a marker at the location
            var marker = new google.maps.Marker({
                position: location,
                map: map,
                title: "This is the location"
            });
        }
    </script>    

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.adminApp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/npgovardhan25/public_html/resources/views/admin/property-surveyors/show.blade.php ENDPATH**/ ?>