<?php $__env->startSection('style'); ?>
<link href='https://cdn.jsdelivr.net/npm/froala-editor@latest/css/froala_editor.pkgd.min.css' rel='stylesheet' type='text/css' />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">All Year of Constructions </div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page"> Year of Constructions </li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                </div>
            </div>
        </div>
        <!--end breadcrumb-->
        <div class="row">
            <div class="col-lg-4 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Add Year of Constructions</h6>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="" method="POST" enctype="multipart/form-data"id="SameForm">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <input type="hidden" name="id" id="id" value="<?php echo e($edt->id ?? ''); ?>">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-control" id="name" name="name" value="<?php echo e($edt->name ?? ''); ?>" required>
                                <?php $__errorArgs = ['type_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <input type="text" class="form-control" id="description" name="description" value="<?php echo e($edt->description ?? ''); ?>" required>
                                <?php $__errorArgs = ['type_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                             
                            <div class="mb-3">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-control" id="status" name="status">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-primary">Save </button>
                             <a href="" class="btn btn-secondary" id="cancelBtn">Cancel</a>
                        </form>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <!-- Displaying Success Message -->
                        <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>

                        <!-- Displaying Error Messages -->
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="col-lg-8 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white"> Year of Constructions List</h6>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="basic-1">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Type Name</th>
                                        <th>Description</th> 
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                               
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- DataTables -->




<script>
    $(function () {
    $('#basic-1').DataTable({
        processing: true,
        serverSide: true,
         ajax: "<?php echo e(route('gis.propertyyear.data')); ?>", // Make sure your route returns DataTable data
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
            { data: 'name', name: 'name'},
            { data: 'description', name: 'description'},
            { data: 'status', name: 'status'},
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ]
    });
});


$(document).ready(function () {
    $(document).on("submit", "#SameForm", function (e) {
        e.preventDefault();

        let formData = new FormData(this);
        // formData.set('status', $('#status').val() == "1" ? 1 : 0); // 👈 Force boolean
           
        $.ajax({
            url: "<?php echo e(route('gis.propertyyear.store')); ?>",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: function (res) {
            
    if (res.status == "add") {
        $("#SameForm")[0].reset();
        $('#basic-1').DataTable().ajax.reload();
    }

    if (res.status == 'update') {
        $('#basic-1').DataTable().ajax.reload(null, false);  
        $("#SameForm")[0].reset();
        $("#SameForm input[name='id']").val('');
    }

    toastr.success(res.msg);
},
            error: function (xhr) {
                let error = xhr.responseJSON.errors;
                $.each(error, function (key, value) {
                    $(`.${key}`).html(value);
                    toastr.error(value);
                });
            }
        });
    });
});


$(document).on("click", "#cancelBtn", function (e) {
    e.preventDefault(); // Stop page refresh
    $("#SameForm")[0].reset(); // Reset the form
    $("#SameForm input[name='id']").val(''); // Also clear hidden ID if editing
});



$(document).on('click', '.edit-btn', function() {
  if (!confirm("Are you sure you want to edit this item?")) 
    {
        return; 
    }
    let id = $(this).data('id');
    $.ajax({
       url: `<?php echo e(url('gis/propertyyear/get')); ?>/${id}`,
 
        method: 'GET',
        success: function(data) {
           
            $('#SameForm input[name="id"]').val(data.id);
          
            $('#SameForm input[name="name"]').val(data.name);
            $('#SameForm input[name="description"]').val(data.description);
            $('#SameForm select[name="status"]').val(data.status);
        },
        error: function() {
            alert('An error occurred while loading the data.');
        }
    });
});

$(document).on("click", ".btn-delete", function () {
             if (!confirm("Are you sure you want to delete this item?"))
        {
            return; // User canceled
        }
                let delUrl = $(this).data("delid");
                $.ajax({
                    url: delUrl,
                    type: "GET",
                    success: function (res) {
                        if (res.status === 1) {
                            toastr.success("Data has been deleted successfully");
                        } else {
                            toastr.error('Something went wrong');
                        }
                         $('#basic-1').DataTable().ajax.reload();
                    }
                })
            })
</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.adminApp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/npgovardhan25/public_html/resources/views/admin/yearOfConstructions.blade.php ENDPATH**/ ?>