<?php
    use App\Models\Ward;
    use App\Models\User;
    use App\Models\FloorType;
    
    $wards = Ward::all();
    $users = User::all();
    $floors = FloorType::where('status',1)->get();
?>

<?php $__env->startSection('style'); ?>
<link href='https://cdn.jsdelivr.net/npm/froala-editor@latest/css/froala_editor.pkgd.min.css' rel='stylesheet' type='text/css' />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">All Property Surveyors </div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page"> Property Surveyors </li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <!-- Displaying Success Message -->
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <!-- Displaying Error Messages -->
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
        </div>
      <!-- Include jQuery -->
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Property Surveyors List</h6>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row mb-2">
                            <div class="col-md-2">
                                <select id="no_of_row" class="form-select  ">
                                    <option value="25">25</option> 
                                    <option value="50">50</option> 
                                    <option value="100">100</option> 
                                    <option value="250">250</option> 
                                    <option value="500">500</option> 
                                    <option value="1000">1000</option>
                                    <option value="1500">1500</option>
                                    <option value="2000">2000</option>
                                    <option value="2500">2500</option>
                                    <option value="3000">3000</option>
                                    <option value="3500">3500</option>
                                    <option value="4000">4000</option>
                                </select>
                            </div>
                            <div class="col-md-2"> 
                                <select id="wardNo" class="form-select  ">
                                    <option value="">All Ward</option> 
                                    <?php $__currentLoopData = $wards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$ward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($ward->id); ?>" ><?php echo e($ward->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2"> 
                                <select id="userId" class="form-select  ">
                                    <option value="">All Users</option> 
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">  
                                <input type="date" name="startDate" id="startDate" class="form-control" > 
                            </div>
                            <div class="col-md-2">  
                                <input type="date" name="endDate" id="endDate" class="form-control" > 
                            </div>
                            <div class="col-md-2"> 
                                <input type="submit" value="Search" class="btn btn-primary" onclick="loadS()">
                            </div>
                            
                            <!--<div class="col-md-2"> -->
                            <!--    <button id="exportPDF" class="btn btn-danger">Export to PDF</button>-->
                            <!--</div>--> 
                            <!-- Export Buttons -->
                        </div>
                        
                        <div class="row mb-2">
                            <?php $colIndex = 0;  ?>
                            <div class="col-md-2">
                                <!-- Dropdown for column selection -->
                                <select id="columnSelect" class="form-select">

                                    <option value="">All</option>
                                
                                    
                                    <option value="<?php echo e($colIndex++); ?>">SN</option>
                                    <option value="<?php echo e($colIndex++); ?>">Actions</option>
                                    <option value="<?php echo e($colIndex++); ?>">Status</option>
                                    <option value="<?php echo e($colIndex++); ?>">Surveyor Name</option>
                                    <option value="<?php echo e($colIndex++); ?>">Assessment Year</option>
                                    <option value="<?php echo e($colIndex++); ?>">Survey Id</option>
                                    <option value="<?php echo e($colIndex++); ?>">Date of Survey</option>
                                    <option value="<?php echo e($colIndex++); ?>">Owner Name</option>
                                    <option value="<?php echo e($colIndex++); ?>">Owner Father Name</option>
                                    <option value="<?php echo e($colIndex++); ?>">Mobile No</option>
                                    <option value="<?php echo e($colIndex++); ?>">Ward Name</option>
                                    <option value="<?php echo e($colIndex++); ?>">Is Slum</option>
                                    <option value="<?php echo e($colIndex++); ?>">Parcel No</option>
                                    <option value="<?php echo e($colIndex++); ?>">Property No</option>
                                    <option value="<?php echo e($colIndex++); ?>">Electricity ID</option>
                                    <option value="<?php echo e($colIndex++); ?>">Khasra No</option>
                                    <option value="<?php echo e($colIndex++); ?>">Registry No</option>
                                    <option value="<?php echo e($colIndex++); ?>">Constructed Date</option>
                                    <option value="<?php echo e($colIndex++); ?>">Respondent Name</option>
                                    <option value="<?php echo e($colIndex++); ?>">Respondent Relationship</option>
                                    <option value="<?php echo e($colIndex++); ?>">Owner Aadhaar Number</option>
                                    <option value="<?php echo e($colIndex++); ?>">City</option>
                                    <option value="<?php echo e($colIndex++); ?>">Pincode</option>
                                    <option value="<?php echo e($colIndex++); ?>">House No</option>
                                    <option value="<?php echo e($colIndex++); ?>">Street Name</option>
                                    <option value="<?php echo e($colIndex++); ?>">Locality</option>
                                    <option value="<?php echo e($colIndex++); ?>">Colony</option>
                                    <option value="<?php echo e($colIndex++); ?>">Present House No</option>
                                    <option value="<?php echo e($colIndex++); ?>">Present Street Name</option>
                                    <option value="<?php echo e($colIndex++); ?>">Present Locality</option>
                                    <option value="<?php echo e($colIndex++); ?>">Present Colony</option>
                                    <option value="<?php echo e($colIndex++); ?>">Present City</option>
                                    <option value="<?php echo e($colIndex++); ?>">Present Pincode</option>
                                    <option value="<?php echo e($colIndex++); ?>">Is Same As Property</option>
                                    <option value="<?php echo e($colIndex++); ?>">Tax Rate Zone</option>
                                    <option value="<?php echo e($colIndex++); ?>">Property Ownership</option>
                                    <option value="<?php echo e($colIndex++); ?>">Property Type</option>
                                    <option value="<?php echo e($colIndex++); ?>">Property Use</option>
                                    <option value="<?php echo e($colIndex++); ?>">Year of Construction</option>
                                    <option value="<?php echo e($colIndex++); ?>">Situation</option>
                                    <option value="<?php echo e($colIndex++); ?>">Road Type</option>
                                    <option value="<?php echo e($colIndex++); ?>">Floor Type</option>
                                
                                    
                                    <?php $__currentLoopData = $floors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $floor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($colIndex++); ?>">Floors - <?php echo e($floor->name); ?> - Residential</option>
                                        <option value="<?php echo e($colIndex++); ?>">Floors - <?php echo e($floor->name); ?> - Non-Residential</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                    
                                    <option value="<?php echo e($colIndex++); ?>">Plot Area (SqFt)</option>
                                    <option value="<?php echo e($colIndex++); ?>">Plot Area (SqMeter)</option>
                                    <option value="<?php echo e($colIndex++); ?>">Plinth Area (SqFt)</option>
                                    <option value="<?php echo e($colIndex++); ?>">Plinth Area (SqMeter)</option>
                                    <option value="<?php echo e($colIndex++); ?>">Total Built Up Area (SqFt)</option>
                                    <option value="<?php echo e($colIndex++); ?>">Total Built Up Area (SqMeter)</option>
                                
                                    
                                    <?php for($i=1; $i<=22; $i++): ?>
                                        <option value="<?php echo e($colIndex++); ?>">Total Diamond <?php echo e($i); ?></option>
                                    <?php endfor; ?>
                                
                                    
                                    <option value="<?php echo e($colIndex++); ?>">Is Municipal Water Supply</option>
                                    <option value="<?php echo e($colIndex++); ?>">Total Water Connection</option>
                                    <option value="<?php echo e($colIndex++); ?>">Water Connection Id/Type</option>
                                    <option value="<?php echo e($colIndex++); ?>">Toilet Type</option>
                                    <option value="<?php echo e($colIndex++); ?>">Is Municipal Waste Service</option>
                                    <option value="<?php echo e($colIndex++); ?>">Is Municipal Water Supply (DUPLICATE)</option>
                                    <option value="<?php echo e($colIndex++); ?>">Is Municipal Water Supply (DUPLICATE)</option>
                                
                                </select>

                                 
                            </div>
                           
                            <div class="col-md-2"> 
                                <input type="text" id="searchQuery" placeholder="Search..."  class="form-control"> 
                                <!--oninput="loadSurveys(1)"-->
                            </div>
                            <div class="col-md-4">  
                            </div>
                            <div class="col-md-2"> 
                                <?php if(has_permission(['Properties'], 'demand-notice-print')): ?>
                                <button id="downloadNotices" class="btn btn-warning">Download Notices</button>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2"> 
                                <?php if(has_permission(['Properties'], 'properties-export')): ?>
                                <button id="exportExcel" class="btn btn-warning">Export to Excel</button>
                                <?php endif; ?>
                            </div>
                        </div>
                        <style>
                            .table-wrapper {
                              max-height: 600px;  /* Set the desired height for the table */
                              overflow-y: auto;   /* Enables vertical scrolling */
                              display: block;     /* Makes the table wrapper block-level so that the scrolling works */
                            }
                          
                            .table {
                              width: 100%;
                              border-collapse: collapse;  /* Ensures no space between table borders */
                               text-align: center;
                                margin-left: auto;
                                margin-right: auto; 
                            }
                          
                            .table thead {
                              background: #ffc107; /* Optional: Adds a background color to the header */
                              position: sticky;     /* Makes the header sticky */
                              top: 0;               /* Sticks the header to the top */
                              z-index: 1;           /* Ensures the header stays above the table body */
                            }
                          
                            .table th, .table td {
                              padding: 8px;         /* Adds padding to the cells */
                              border: 1px solid #ddd; /* Adds a border to the cells */
                            }
                          </style>
                        <div class="table-responsive">
                            <div class="table-wrapper">
                                 
                            
                                <table class="table" id="example22">
                                    <thead>
                                        <tr>
                                            <th  rowspan="4">SN</th>
                                            <th  rowspan="4">Actions</th>
                                            <th  rowspan="4">Status</th>
                                            <th  rowspan="4">Surveyor Name</th> 
                                            <th  rowspan="4">Assessment Year</th>
                                            <th  rowspan="4">Survey Id</th> 
                                            <th  rowspan="4">Date of Survey </th> 
                                            <th  rowspan="4">Owner Name</th>
                                            <th  rowspan="4">Owner Father Name</th>
                                            <th  rowspan="4">Mobile No</th>
                                            <th  rowspan="4">Ward Name</th> 
                                            <th  rowspan="4">Is Slum</th>
                                            <th  rowspan="4">Parcel No</th>
                                            <th  rowspan="4">Property No</th>
                                            <th  rowspan="4">Electricity ID</th>
                                            <th  rowspan="4">Khasra No</th>
                                            <th  rowspan="4">Registry No</th>
                                            <th  rowspan="4">Constructed Date</th>
                                            <th  rowspan="4">Respondent Name</th>
                                            <th  rowspan="4">Respondent Relationship</th>
                                            <th  rowspan="4">Owner Aadhaar Number</th>
                                            <th  rowspan="4">City</th>
                                            <th  rowspan="4">Pincode</th>
                                            <th  rowspan="4">House No</th>
                                            <th  rowspan="4">Street Name</th>
                                            <th  rowspan="4">Locality</th>
                                            <th  rowspan="4">Colony</th>
                                            <th  rowspan="4">Present House No</th>
                                            <th  rowspan="4">Present Street Name</th>
                                            <th  rowspan="4">Present Locality</th>
                                            <th  rowspan="4">Present Colony</th>
                                            <th  rowspan="4">Present City</th>
                                            <th  rowspan="4">Present Pincode</th>
                                            <th  rowspan="4">Is Same As Property</th>
                                            <th  rowspan="4">Tax Rate Zone</th>
                                            <th  rowspan="4">Property Ownership</th>
                                            <th  rowspan="4">Property Type</th>
                                            <th  rowspan="4">Property Use</th>
                                            <th  rowspan="4">Year of Construction</th> 
                                            <th  rowspan="4">Situation</th>
                                            <th  rowspan="4">Road Type</th>
                                            <th style="text-align: center" colspan="<?php echo e((count($floors)*2)+1); ?>">Floors</th>
                                            <th  rowspan="4">Plot Area SqFt</th> 
                                            <th  rowspan="4">Plot Area SqMeter</th> 
                                            <th  rowspan="4">Plinth Area SqFt</th> 
                                            <th  rowspan="4">Plinth Area SqMeter</th>
                                            <th  rowspan="4">Total Built Up Area SqFt</th> 
                                            <th  rowspan="4">Total Built Up Area SqMeter</th>
                                            <th  rowspan="2" colspan="22">Total Diamond</th> 
                                            <th  rowspan="4">Is Muncipal Water Supply</th> 
                                            <th  rowspan="4">Total Water Connection</th>
                                            <th rowspan="4">Water Connection Id/Type</th>
                                            <th rowspan="4">Toilet Type</th>
                                            <th rowspan="4">Is Muncipal Waste Service</th>
                                            <th rowspan="4">Is Muncipal Water Supply</th>
                                            <th rowspan="4">Is Muncipal Water Supply</th>
                                        </tr>
                                        <tr>
                                            <th></th>
                                            <?php $__currentLoopData = $floors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$floor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                            <td style="text-align: center" colspan="2"><?php echo e($floor->name); ?></td>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            
                                        </tr>
                                        <tr>
                                            <th></th>
                                            <?php $__currentLoopData = $floors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$floor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                            <?php if($floor->id!=10): ?>
                                            <td style="text-align: center" colspan="1"  rowspan="2">Residential</td>
                                            <td style="text-align: center" colspan="1"  rowspan="2">Non-Residential</td>
                                            <?php else: ?>
                                            <td style="text-align: center" colspan="2"  rowspan="2">Area</td>
                                            <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <td style="text-align: center" colspan="9">Residential</td>
                                            <td style="text-align: center" colspan="9">Non-Residential</td>
                                            <th style="text-align: center" colspan="3">Open Land </th>
                                            <th style="text-align: center" rowspan="2">Total Tax</th>
                                            
                                        </tr>
                                         <tr>
                                            <th>Floor Type</th>
                                            <?php $__currentLoopData = $floors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$floor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                            
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <td style="text-align: center" class="bg-primary">RCC</td>
                                            <td style="text-align: center" class="bg-primary">T.Rate</td>
                                            <td style="text-align: center" class="bg-primary">Tax</td>
                                            <td style="text-align: center" class="bg-info">TEEN</td>
                                            <td style="text-align: center" class="bg-info">T.Rate</td>
                                            <td style="text-align: center" class="bg-info">Tax</td>
                                            <td style="text-align: center" class="bg-Secondary">KUCHA</td>
                                            <td style="text-align: center" class="bg-Secondary">T.Rate</td>
                                            <td style="text-align: center" class="bg-Secondary">Tax</td>
                                            <td style="text-align: center" class="bg-primary">RCC</td>
                                            <td style="text-align: center" class="bg-primary">T.Rate</td>
                                            <td style="text-align: center" class="bg-primary">Tax</td>
                                            <td style="text-align: center" class="bg-info">TEEN</td>
                                            <td style="text-align: center" class="bg-info">T.Rate</td>  
                                            <td style="text-align: center" class="bg-info">Tax</td>
                                            <td style="text-align: center" class="bg-Secondary">KUCHA</td>
                                            <td style="text-align: center" class="bg-Secondary">T.Rate</td>
                                            <td style="text-align: center" class="bg-Secondary">Tax</td>
                                            <td style="text-align: center" class="bg-danger">Plot Area</td> 
                                            <td style="text-align: center" class="bg-danger">Plot T.Rete</td>
                                            <td style="text-align: center" class="bg-danger">Plot Tax</td>
                                        </tr>
                                    </thead> 
                                    <tbody id="surveyTableBody"></tbody>
                                </table>
                            </div>
                            <!-- Pagination (Previous & Next buttons only) -->
                            <div class="pagination" id="paginationLinks"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script> 
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.20/jspdf.plugin.autotable.min.js"></script>
<script>

    function loadS() 
    {
        event.preventDefault();  
        loadSurveys(1);
    }
//$(document).ready(function () {
    // Load surveys on page load
    loadSurveys(1);

    // Function to load survey data via AJAX
    function loadSurveys(page) {
        let no_of_row = $("#no_of_row").val();
        let wardNo = $("#wardNo").val(); 
        let userId = $("#userId").val();
        let startDate = $("#startDate").val(); // Get the search query from the input
        let endDate = $("#endDate").val(); // Get the search query from the input
        const params = new URLSearchParams(window.location.search);
        const filterValue = params.get('filter') ? '&status='+params.get('filter') : null ;  
        console.log('Filter:', filterValue);

        let floorsType = '';
        $.ajax({  url: '<?php echo e(route("gis.floors.index")); ?>',  type: 'GET', dataType: 'json', success: function (floor)  { floorsType = floor; } })
        let floorUsageTypes = '';
        $.ajax({  url: '<?php echo e(route("gis.floorUsageTypes.index")); ?>',  type: 'GET', dataType: 'json', success: function (floorUsageType)  { floorUsageTypes = floorUsageType; } })
        let floorUsageFactors = '';
        $.ajax({  url: '<?php echo e(route("gis.floorUsageFactors.index")); ?>',  type: 'GET', dataType: 'json', success: function (floorUsageFactor)  { floorUsageFactors = floorUsageFactor; } })
        let natureOfConstructionLists = '';
        $.ajax({  url: '<?php echo e(route("gis.natureOfConstructionLists.index")); ?>',  type: 'GET', dataType: 'json', success: function (natureOfConstructionList)  { natureOfConstructionLists = natureOfConstructionList; } })

        $.ajax({
            url: '<?php echo e(route("gis.properties.index")); ?>?andOr=and&sortBy=nagarpalikaId&sortDirection=asc&page=' + page + '&perPage=' + no_of_row + '&wardNo=' + wardNo + '&user_id=' + userId + '&startDate=' + startDate + '&endDate=' + endDate+filterValue ,  
            type: 'GET',
            dataType: 'json',
            success: function (response) 
            {
                console.log(response);
                // Populate the table
                let tableBody = $('#surveyTableBody');
                tableBody.empty();  // Clear current table data 
                let ii = (response.current_page > 1) ? (response.current_page - 1 ) * no_of_row + 1  : 1; 
                $.each(response.data, function (index, survey) {
                    // Extract owner details
                    //console.log(response.me.role.id)
                    //if(response.me.role.id==1)
                    let ownerDetails = null;
                    if (typeof survey.ownerDetails === 'string') 
                    {    
                        ownerDetails = JSON.parse(survey.ownerDetails);
                    } 
                    else 
                    {
                        ownerDetails = survey.ownerDetails; 
                    }
                    
                    //let ownerDetails = JSON.parse(survey.ownerDetails);
                    let ownerName = 'N/A';
                    if (ownerDetails.length > 0) {
                        ownerName = ownerDetails[0].name; //  ['Naa','Na ','Na','Noo','Nooo'].includes(ownerDetails[0].name) ? 'N/A' :
                    }
 
                    let fatherName = 'N/A';
                    if (ownerDetails.length > 0) {
                        fatherName = ownerDetails[0].fatherName; //  ['Naa','Na ','Na','Noo','Nooo'].includes(ownerDetails[0].fatherName) ? 'N/A' :
                    }
                    let mobile = ownerDetails.length > 0 ? ownerDetails[0].mobile : 'N/A';
                    const date = new Date(survey.created_at);
                    //const formattedDate = date.toLocaleDateString('en-GB'); // en-GB uses dd/mm/yyyy format 
                    const options = {
                      //weekday: 'long', // "Monday"
                      year: 'numeric', // "2025"
                      month: 'long', // "March"
                      day: 'numeric', // "11"
                      hour: '2-digit', // "14"
                      minute: '2-digit', // "30"
                      second: '2-digit', // "00"
                      hour12: true // Enable AM/PM format
                    };
                    
                    let floorData = JSON.parse(survey.floorData);
                    if (!Array.isArray(floorData)) {
                        floorData = JSON.parse(floorData);
                    }
                    
                                        
                    const plinth = {};
                    const plinthSm = {};
                    
                    floorData.forEach(floor => 
                    {
                        const type = floor.floorType;
                        const area = parseFloat(floor.areaSqFt) || 0;
                        const areaSm = parseFloat(floor.areaSqMt) || 0;
                    
                        if (!plinth[type]) {
                            plinth[type] = 0;
                            plinthSm[type] = 0;
                        }
                    
                        plinth[type] += area;
                        plinthSm[type] += areaSm;
                    });
                    
                    let firstPlinthValue = Object.values(plinth)[0];
                    let firstPlinthSmValue = Object.values(plinthSm)[0];
                    // Get the first values
                    if([5,9].includes(Number(survey.property_use?.id)))
                    {
                        firstPlinthValue = 0;
                        firstPlinthSmValue =0;
                    }
                   
                    
                    // console.log(firstPlinthValue);
                    // console.log(firstPlinthSmValue);
                    
                    // ✅ Total plinth areas
                    let totalPlinth = Object.values(plinth).reduce((sum, val) => sum + val, 0);
                    let totalPlinthSm = Object.values(plinthSm).reduce((sum, val) => sum + val, 0);
                    if([5,9].includes(Number(survey.property_use?.id)))
                    {
                        firstPlinthValue = 0;
                        firstPlinthSmValue =0;
                        totalPlinth = 0;
                        totalPlinthSm =0;
                    }
                    // ✅ Format to 2 decimal places
                    const totalPlinthFormatted = totalPlinth.toFixed(2);
                    const totalPlinthSmFormatted = totalPlinthSm.toFixed(2);
                     
                    
                    function floorType(floorType, floors) {
                        // console.log(floorType)
                        // console.log(floors)
                        const floorId = parseInt(floorType);
                        const floor = floors.find(f => f.id === floorId);
                        return floor ? floor.name : '-';
                    }
                    
                    function usageType(usageType, floorUsageType) {
                        //  console.log(usageType)
                        // console.log(floorUsageType)
                        const usageTypeId = parseInt(usageType);
                        const type = floorUsageType.find(t => t.id === usageTypeId);
                        return type ? type.type_name : '-';
                    }
                    
                    function usageFactors(usageFactor, usageFactors) {
                        // console.log(usageFactor)
                        // console.log(usageFactors)
                        const usageFactorId = parseInt(usageFactor);
                        const factor = usageFactors.find(f => f.id === usageFactorId);
                        return factor ? factor.name : '-';
                    }
                    
                    function yearOfConstructions(constructionType, yearOfConstructions) {
                        // console.log(constructionType)
                        // console.log(yearOfConstructions)
                        const constructionTypeId = parseInt(constructionType);
                        const type = yearOfConstructions.find(t => t.id === constructionTypeId);
                        return type ? type.name : '-';
                    }


                    const formattedDate = date.toLocaleString('en-GB', options);
                     
                    
                    let ftd=``;
                    $.each(floorsType, function (inIx, fl) 
                    {   
                        if(fl.id!=10)
                        {
                            ftd +=`<td>${ Number(checkfloor(fl.id,[1, 5],1)) + Number(checkfloor(fl.id,[1, 5],[2,4])) + Number(checkfloor(fl.id,[1, 5],[3,5,'Other'])) } </td>  
                                <td>${ Number(checkfloor(fl.id,[2,3,4,6,'Other'],1)) + Number(checkfloor(fl.id,[2,3,4,6,'Other'],[2,4])) + Number(checkfloor(fl.id,[2,3,4,6,'Other'],[3,5,'Other'])) }</td>    `; 
                        }
                        else
                        {
                            ftd +=`<td colspan="2">${ Number(checkfloor(fl.id,[1, 5],1)) + Number(checkfloor(fl.id,[1, 5],[2,4])) + Number(checkfloor(fl.id,[1, 5],[3,5,'Other'])) + Number(checkfloor(fl.id,[2,3,4,6,'Other'],1)) + Number(checkfloor(fl.id,[2,3,4,6,'Other'],[2,4])) + Number(checkfloor(fl.id,[2,3,4,6,'Other'],[3,5,'Other'])) }</td>    `; 
                        }
                    })
                    
                    function checkfloor(floorid,usageType,constructionType) 
                    {
                        let ii =0;
                        let area =0;
                        $.each(floorData, function (inIndex, floor) 
                        {
                            
                            if(Number(floor.floorType)==floorid)
                            { 
                                //console.log(floor)
                                if (usageType.includes(Number(floor.usageType))) {
                                    
                                    // ftd +=`<td>${floor.floorType}||-${ floor.constructionType==1?floor.areaSqFt:'-'}</td> 
                                    // <td>${ floor.constructionType==2 || floor.constructionType==4?floor.areaSqFt:'-'}</td> 
                                    // <td>${ floor.constructionType==3?floor.areaSqFt:'-'}</td> 
                                    // <td>-</td> <td>-</td> <td>-</td>  `; 
                                    if(floor.constructionType==constructionType || (Array.isArray(constructionType) && constructionType.includes(Number(floor.constructionType))))
                                    {
                                        ii =1;
                                        area =floor.areaSqFt;
                                    }
                                       
                                }
                                else if (usageType.includes(Number(floor.usageType)))
                                {  
                                    if(floor.constructionType==constructionType || (Array.isArray(constructionType) && constructionType.includes(Number(floor.constructionType))))
                                    {
                                         ii =1;
                                          area =floor.areaSqFt;
                                    }
                                }
                                //ii =1;
                            }
                             
                        });
                        
                        return ii ? area : 0;
                    }
                    
                    function checkfloort(usageType,constructionType) 
                    {
                        let ii =0;
                        let area =0;
                        $.each(floorData, function (inIndex, floor) 
                        { 
                                if([5,9].includes(Number(survey.property_use?.id)))
                                {
                                    if(floor.constructionType==constructionType || (Array.isArray(constructionType) && constructionType.includes(Number(floor.constructionType))) || (Array.isArray(constructionType) && constructionType.includes(floor.constructionType)))
                                    {
                                       area =Number(survey.plotAreaSqFt);
                                       ii =1; 
                                    }
                                     
                                }
                                else if (usageType.includes(Number(floor.usageType))) {
                                     
                                    if(floor.constructionType==constructionType || (Array.isArray(constructionType) && constructionType.includes(Number(floor.constructionType))))
                                    {
                                        ii =1;
                                        area +=Number(floor.areaSqFt);
                                    }
                                       
                                }
                                else if (usageType.includes(Number(floor.usageType)))
                                {  
                                    if(floor.constructionType==constructionType || (Array.isArray(constructionType) && constructionType.includes(Number(floor.constructionType))))
                                    {
                                        ii =1;
                                        area +=Number(floor.areaSqFt);
                                    }
                                }
                                else if (usageType.includes(Number(floor.usageType)))
                                {  
                                    if(floor.constructionType==constructionType || (Array.isArray(constructionType) && constructionType.includes(Number(floor.constructionType))))
                                    {
                                        ii =1;
                                        area +=Number(floor.areaSqFt);
                                    }
                                }
                                //ii =1; 
                        });
                        
                        return ii ? area : '-';
                    }
                    
                    function checkfloorR(usageType,constructionType,wardId) 
                    {
                        let ii =0;
                        let area =0;
                        let rate =0;
                        $.each(floorData, function (inIndex, floor) 
                        { 
                                if([5,9].includes(Number(survey.property_use?.id)))
                                {
                                    if(floor.constructionType==constructionType || (Array.isArray(constructionType) && constructionType.includes(Number(floor.constructionType))) || (Array.isArray(constructionType) && constructionType.includes(floor.constructionType)))
                                    {
                                       rate = calculateRate(floor.constructionType, floor.usageType, floor.usageFactor, survey.taxRateZone,wardId); 
                                       ii =1; 
                                    }
                                     
                                }
                                else if (usageType.includes(Number(floor.usageType))) {
                                    
                                    if(floor.constructionType==constructionType || (Array.isArray(constructionType) && constructionType.includes(Number(floor.constructionType))))
                                    {
                                        ii =1;
                                        area +=Number(floor.areaSqFt);
                                        rate = calculateRate(floor.constructionType, floor.usageType, floor.usageFactor, survey.taxRateZone,wardId);
                                    }
                                       
                                }
                                else if (usageType.includes(Number(floor.usageType)))
                                {  
                                    if(floor.constructionType==constructionType || (Array.isArray(constructionType) && constructionType.includes(Number(floor.constructionType))))
                                    {
                                        ii =1;
                                        area +=Number(floor.areaSqFt);
                                        rate = calculateRate(floor.constructionType, floor.usageType, floor.usageFactor, survey.taxRateZone,wardId);
                                    }
                                }
                                //ii =1; 
                        });
                        
                        return ii ? rate : '-';
                    }
                    
                    function checkfloorTax(usageType,constructionType,wardId) 
                    {
                        let ii =0;
                        let TotalAmount =0;
                        let rate =0;
                        $.each(floorData, function (inIndex, floor) 
                        { 
                                if([5,9].includes(Number(survey.property_use?.id)))
                                {
                                    if(floor.constructionType==constructionType || (Array.isArray(constructionType) && constructionType.includes(Number(floor.constructionType))) || (Array.isArray(constructionType) && constructionType.includes(floor.constructionType)))
                                    { 
                                        ii =1; 
                                        rate = calculateRate(floor.constructionType, floor.usageType, floor.usageFactor, survey.taxRateZone,wardId);
                                        const baseAmount = (Number(survey.plotAreaSqFt) * rate * 12);
                                        const discount = (baseAmount * 10) / 100; 
                                        TotalAmount += discount;
                                    }
                                     
                                }
                                else if (usageType.includes(Number(floor.usageType))) {
                                    
                                    if(floor.constructionType==constructionType || (Array.isArray(constructionType) && constructionType.includes(Number(floor.constructionType))))
                                    {
                                        ii =1; 
                                        rate = calculateRate(floor.constructionType, floor.usageType, floor.usageFactor, survey.taxRateZone,wardId);
                                        const baseAmount = ((Number(floor.areaSqFt) * 80) / 100) * rate * 12;
                                        const discount = (baseAmount * 10) / 100; 
                                        TotalAmount += discount;
                                    }
                                       
                                }
                                 
                                //ii =1; 
                        });
                                
                        
                        return ii ? TotalAmount.toFixed(2) : 0;
                    }
                    
                    function checkftype() 
                    {
                        let ft='';
                        var groupedFloors = {};
                    
                        // Group floors by floor.id
                        $.each(floorData, function (inIndex, floor) 
                        {
                            if (!groupedFloors[floor.id]) { groupedFloors[floor.floorType] = []; }
                            groupedFloors[floor.floorType].push(floor);
                        });
                     
                        $.each(groupedFloors, function (id, floors) 
                        {
                            // console.log("Floor ID: " + id);
                            
                            if(id==1)
                            {
                               ft +='B'; 
                            }
                            if(id==2)
                            {
                               ft +='G'; 
                            }
                            if(id>2)
                            {
                               ft +='F'; 
                            }
                            if([5,9].includes(Number(survey.property_use?.id)))
                            {
                               ft="P" 
                            }
                            // console.table(floors); // Each group of the same floor.id
                        });
                        const str = ft

                        // Step 1: Count the 'F's
                        const countF = [...str].filter(c => c === 'F').length;
                        
                        // Step 2: Remove all 'F's
                        const withoutF = str.replace(/F/g, '');
                        
                        // Step 3: Append 'F' + count if count > 0
                        const result = countF > 0 ? withoutF + 'F' + countF : withoutF;
                        
                        // console.log(result); // Output: "GF3"
                        return result;
                    }

                    //console.log(response.floors)
                    //console.log(ftd)
                    
                    tableBody.append(`
                        <tr>
                            <td>${ii++}</td>
                            <td>
                                <div class="btn-group">
                                    <button class="btn btn-primary btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        Action
                                    </button>
                                    <div class="dropdown-menu" style="">
                                        <?php if(has_permission(['Properties'], 'demand-notice-print')): ?>
                                        <a target="_blank" href="<?php echo e(route('gis.properties.demand-notice-print', '')); ?>/${survey.id}" class="dropdown-item edit-btn" >Demand Notice Print</a>
                                        <?php endif; ?>
                                        <?php if(has_permission(['Properties'], 'show')): ?>
                                        <a target="_blank" href="<?php echo e(route('gis.properties.show', '')); ?>/${survey.id}" class="dropdown-item edit-btn" >View</a>
                                        <?php endif; ?>
                                        <?php if(has_permission(['Properties'], 'edit')): ?>
                                        <a target="_blank" href="<?php echo e(url('gis/properties/${survey.id}/edit')); ?>" class="dropdown-item edit-btn">Edit</a>  
                                        <?php endif; ?>
                                        <?php if(has_permission(['Properties'], 'destroy')): ?>
                                        <form action="<?php echo e(route('gis.property.destroy','')); ?>${survey.id}" method="POST" style="display:inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <input type="hidden" value="${survey.id}" name="id">
                                            <button type="submit" class="dropdown-item edit-btn" onclick="return confirm('Are you sure you want to delete this Property Surveyors Data?');">Delete</button>
                                        </form> 
                                        <?php endif; ?>
                                    </div>
                                </div> 
                            </td> 
                            <td><a target="_blank"  data-status="<?php echo e((has_permission(['Properties'], 'in-progress') || has_permission(['QC-Level-1'], 'status') || has_permission(['Properties'], 'QC-Level-2') || has_permission(['Properties'], 'QC-Done') ) ? url('gis/properties/status/${survey.id}/${getSurveyStatus(survey.status)[`value`]}') : '#'); ?>" class="btn ${getSurveyStatus(survey.status)['class']} btn-sm btn-status">${getSurveyStatus(survey.status)['label']}</a></td>
                            <td><a target="_blank" href="<?php echo e((has_permission(['Properties'], 'user-profile')) ? route('gis.property.user.show', '') : '#'); ?>/${survey.user.id}" class="btn btn-dark btn-sm">${survey.user.name}</a></td>
                            <td>${survey.period}</td>
                            <td>${survey.nagarpalikaId}</td>
                            <td>${formattedDate}</td>
                            <td>${ownerName}</td>
                            <td>${fatherName}</td>
                            <td>${mobile}</td>
                            <td>${survey.ward.name}</td> 
                            <td>${survey.isSlum}</td>
                            <td>${survey.parcelNo}</td>
                            <td>${survey.propertyNo}</td>
                            <td>${survey.electricityId ? survey.electricityId : 'N/A'}</td>
                            <td>${survey.khasraNo ? survey.khasraNo : 'N/A'}</td>
                            <td>${survey.registryNo ? survey.registryNo : 'N/A'}</td>
                            <td>${survey.constructedDate}</td>
                            <td>${['Naa','Na ','Na','Noo','Nooo'].includes(survey.respondentName) ? 'N/A' : survey.respondentName}</td>
                            <td>${survey.respondent_relation_data?.name}</td>
                            <td>${survey.ownerAadhaarNumber ? survey.ownerAadhaarNumber : 'N/A'}</td>
                            <td>${survey.city}</td>
                            <td>${survey.pincode}</td>
                            <td>${ ['Naa','Na ','Na','Noo','Nooo'].includes(survey.houseNo) ? 'N/A' : survey.houseNo }</td>
                            <td>${survey.streetNoName}</td>
                            <td>${survey.locality}</td>
                            <td>${survey.colony}</td>
                            <td>${ ['Naa','Na ','Na','Noo','Nooo'].includes(survey.presentHouseNo) ? 'N/A' : survey.presentHouseNo}</td>
                            <td>${survey.presentStreetNoName}</td>
                            <td>${survey.presentLocality}</td>
                            <td>${survey.presentColony}</td>
                            <td>${survey.presentCity}</td>
                            <td>${survey.presentPincode}</td>
                            <td>${survey.isSameAsProperty}</td>
                            <td>${ survey.tax_rate_zone_data?.name }</td> 
                            <td>${ survey.property_ownership_data?.name }</td>  
                            
                            <td>${ survey.property_type_data?.type_name  }</td> 
                            <td>${ survey.property_use_data?.name }</td>  
                            
                            <td>${ survey.year_of_construction_data?.name}</td> 
                            <td>${ survey.situation_data?.name }</td> 
                            <td>${ survey.road_type_data?.name }</td> 
                            <td>${ checkftype() } </td>
                            ${ ftd }
                            <td>${survey.plotAreaSqFt}</td> 
                            <td>${survey.plotAreaSqMeter}</td> 
                            <td>${ firstPlinthValue?.toFixed(2) ?? survey.plinthAreaSqFt} </td> 
                            <td>${ firstPlinthSmValue?.toFixed(2) ?? survey.plinthAreaSqMeter} </td>
                            <td>${ totalPlinthFormatted ?? survey.totalBuiltUpAreaSqFt} </td>
                            <td>${ totalPlinthSmFormatted ?? survey.totalBuiltUpAreaSqMeter} </td>
                            
                            <td style="text-align: center" class="bg-primary" >${ checkfloort([1, 5],1) }</td>
                            <td style="text-align: center" class="bg-primary">${ checkfloorR([1, 5],1,survey.ward?.id) }</td>
                            <td style="text-align: center" class="bg-primary">${ checkfloorTax([1, 5],1,survey.ward?.id) }</td>
                            <td style="text-align: center" class="bg-info">${ checkfloort([1, 5],[2,4]) }</td>
                            <td style="text-align: center" class="bg-info">${ checkfloorR([1, 5],[2,4],survey.ward?.id) }</td>
                            <td style="text-align: center" class="bg-info">${ checkfloorTax([1, 5],[2,4],survey.ward?.id) }</td>
                            <td style="text-align: center" class="bg-Secondary">${ checkfloort([1, 5],3) }</td>
                            <td style="text-align: center" class="bg-Secondary">${ checkfloorR([1, 5],3,survey.ward?.id) }</td>
                            <td style="text-align: center" class="bg-Secondary">${ checkfloorTax([1, 5],3,survey.ward?.id) }</td>
                            
                            <td style="text-align: center" class="bg-primary">${ checkfloort([2,3,4,6],1) }</td>
                            <td style="text-align: center" class="bg-primary">${ checkfloorR([2,3,4,6],1,survey.ward?.id) }</td>
                            <td style="text-align: center" class="bg-primary">${ checkfloorTax([2,3,4,6],1,survey.ward?.id) }</td>
                            <td style="text-align: center" class="bg-info">${ checkfloort([2,3,4,6],[2,4]) }</td>
                            <td style="text-align: center" class="bg-info">${ checkfloorR([2,3,4,6],[2,4],survey.ward?.id) }</td>
                            <td style="text-align: center" class="bg-info">${ checkfloorTax([2,3,4,6],[2,4],survey.ward?.id) }</td>
                            <td style="text-align: center" class="bg-Secondary">${ checkfloort([2,3,4,6],3) }</td>
                            <td style="text-align: center" class="bg-Secondary">${ checkfloorR([2,3,4,6],3,survey.ward?.id) }</td>
                            <td style="text-align: center" class="bg-Secondary">${ checkfloorTax([2,3,4,6],3,survey.ward?.id) }</td>
                            
                            <td style="text-align: center" class="bg-danger">${ checkfloort([2,3,4,6],["Other",5]) }</td>
                            <td style="text-align: center" class="bg-danger">${ checkfloorR([2,3,4,6],["Other",5],survey.ward?.id) }</td>
                            <td style="text-align: center" class="bg-danger">${ checkfloorTax([2,3,4,6],["Other",5],survey.ward?.id) }</td>
                            <td style="text-align: center" class="bg-Secondary">
                            ${ 
                                (
                                    Number(checkfloorTax([1, 5],1,survey.ward?.id)) + 
                                    Number(checkfloorTax([1, 5],[2,4],survey.ward?.id)) + 
                                    Number(checkfloorTax([1, 5],3,survey.ward?.id)) +  
                                    Number(checkfloorTax([2,3,4,6],1,survey.ward?.id)) +  
                                    Number(checkfloorTax([2,3,4,6],[2,4],survey.ward?.id)) + 
                                    Number(checkfloorTax([2,3,4,6],3,survey.ward?.id))
                                ).toFixed(2) }</td>
                            <td>${ survey.isMuncipalWaterSupply}</td>
                            <td>${ survey.totalWaterConnection}</td>
                            <td>${ survey.waterConnectionId}</td>
                            <td>${ survey.toilet_type_data?.name }</td> 
                            <td>${ survey.isMuncipalWaterSupply}</td>
                            <td>${ survey.isMuncipalWasteService}</td> 
                            <td>${ survey.sourceOfWater==null? 'NA': survey.source_of_water_data?.name }</td> 
                              
                        </tr>
                    `);
                });
                
            
                // Update pagination with Previous and Next buttons
                let paginationLinks = $('#paginationLinks');
                paginationLinks.empty();

                // Previous button
                if (response.prev_page_url) 
                {
                    paginationLinks.append(`<a href="#" class="btn btn-secondary btn-sm" id="prevBtn">Previous</a>`);
                } else {
                    paginationLinks.append(`<span class="btn btn-light btn-sm">Previous</span>`);
                }

                // Next button
                if (response.next_page_url) {
                    paginationLinks.append(`<a href="#" class="btn btn-secondary btn-sm" id="nextBtn">Next</a>`);
                } else {
                    paginationLinks.append(`<span class="btn btn-light btn-sm">Next</span>`);
                }

                // Last button
                if (response.last_page_url) {
                    paginationLinks.append(`<a href="#" class="btn btn-secondary btn-sm" id="lastBtn">Last</a>`);
                } else {
                    paginationLinks.append(`<span class="btn btn-light btn-sm">Last</span>`);
                }

                // Handle Previous button click
                $('#prevBtn').on('click', function (e) {
                    e.preventDefault();
                    if (response.prev_page_url) {
                        loadSurveys(new URL(response.prev_page_url).searchParams.get('page')); // Get the previous page number from URL
                    }
                });

                // Handle Next button click
                $('#nextBtn').on('click', function (e) {
                    e.preventDefault();
                    if (response.next_page_url) {
                        loadSurveys(new URL(response.next_page_url).searchParams.get('page')); // Get the next page number from URL
                    }
                });

                // Handle Last button click
                $('#lastBtn').on('click', function (e) {
                    e.preventDefault();
                    if (response.last_page_url) {
                        loadSurveys(new URL(response.last_page_url).searchParams.get('page')); // Get the last page number from URL
                    }
                });
            },
            error: function () {
                alert('Error loading survey data.');
            }
        });
    } 

//});


    
    
    function getSurveyStatus(status) {
        const statusMap = {
            0: { label: 'In-progress', class: 'btn-warning', value: 1, },
            1: { label: 'QC Level 1', class: 'btn-primary', value: 2 },
            2: { label: 'QC Level 2', class: 'btn-info' , value: 3},
            3: { label: 'QC Done', class: 'btn-success', value: 4 },
            4: { label: 'Completed', class: 'btn-dark', value: 4 }
        };
        
        return statusMap.hasOwnProperty(status) ? statusMap[status] : 'Unknown';
    }


</script>

<script>
    // Function to search and filter the table
    function searchTable() {
    let searchQuery = $("#searchQuery").val().toLowerCase(); // Get the search query and convert to lowercase
    let selectedColumn = $("#columnSelect").val(); // Get the selected column index (empty string for "All")
    let tableRows = $('#surveyTableBody tr'); // Get all rows in the table body

        tableRows.each(function () {
            let row = $(this); // Get the current row
    
            if (selectedColumn === "") {
                // Search across all columns if "All" is selected
                let rowText = row.text().toLowerCase(); // Get all the text content of the row
                if (rowText.indexOf(searchQuery) > -1) {
                    row.show();
                } else {
                    row.hide();
                }
            } else {
                // Otherwise, search only the selected column
                let cell = row.find('td').eq(selectedColumn); // Get the selected column in the row
                let cellText = cell.text().toLowerCase(); // Get the text of that cell and convert it to lowercase
    
                // If the cell contains the search query, show the row, otherwise hide it
                if (cellText.indexOf(searchQuery) > -1) {
                    row.show();
                } else {
                    row.hide();
                }
            }
        });
    }
    
    // Trigger search on input change
    $("#searchQuery").on("input", function() {
        searchTable(); // Call the search function when the user types in the search box
    });
    
    // Optional: Trigger search on column change
    $("#columnSelect").on("change", function() {
        searchTable(); // Call the search function when the user changes the column
    });

</script>

<!-- Add the export functionality -->
<script>
    // Excel export
    
    $(document).on("click", ".btn-status", function() {
        let statusUrl = $(this).data("status");
        $.ajax({
            url: statusUrl,
            type: "GET",
            success: function(res) {
                res.status === 'success' ? toastr.success(res.msg) : toastr.error(res.msg);
                loadSurveys(1); 
            }
        });
    });
    
    document.getElementById("downloadNotices").addEventListener("click", function () 
    {
        let wardNo = document.getElementById("wardNo").value;
        if (wardNo) {
              window.open(`<?php echo e(url('gis/properties/print-ward-demand-notice/${wardNo}')); ?>`, '_blank');
        } else {
            alert("Please enter a ward number.");
        }
    });
    document.getElementById("exportExcel").addEventListener("click", function () 
    {
        let wardNo = document.getElementById("wardNo").value;
        let wardName ='';
        if (wardNo) {
             wardName = `-Ward-No-${wardNo}`;
        }
        var wb = XLSX.utils.table_to_book(document.getElementById('example22'), { sheet: "Survey Data" });
        XLSX.writeFile(wb, `<?php echo e(env('APP_NAME')); ?>${wardName}-survey-data.xlsx`); 
    });

    // PDF export
    // document.getElementById("exportPDF").addEventListener("click", function () {
    //     const { jsPDF } = window.jspdf;
    //     const doc = new jsPDF();
    //     doc.autoTable({ html: '#example22' });
    //     doc.save('survey_data.pdf');
    // });
</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.adminApp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/npgovardhan25/public_html/resources/views/admin/property-surveyors/report.blade.php ENDPATH**/ ?>