
<?php $__env->startSection('style'); ?>
<link href='https://cdn.jsdelivr.net/npm/froala-editor@latest/css/froala_editor.pkgd.min.css' rel='stylesheet' type='text/css' />

<style>
.btn-group .btn {
    margin-right: 8px;
}

.btn-group .btn:last-child {
    margin-right: 0;
}

.btn-warning.edit-btn:hover {
    background-color: #e0a800;
    color: white;
}

.btn-danger.btn-delete:hover {
    background-color: #c82333;
    color: white;
}
</style>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">All Wards Member </div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page"> Wards Member </li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                </div>
            </div>
        </div>
        <!--end breadcrumb-->
        <div class="row">
            <div class="col-lg-4 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Add Wards Member</h6>
                        </div>
                    </div>
                        <div class="card-body">

                            <form action="" method="POST" enctype="multipart/form-data" id="SameForm">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="id" value="<?php echo e($wardMember->id ?? ''); ?>">
                                                    
                                    <!-- Ward Info -->
                                    <div class="mb-3">
                                        <label for="ward_info" class="form-label">Ward Info (Name + Number)</label>
                                        <input type="text" class="form-control" id="ward_info" name="ward_info" 
                                               value="<?php echo e($wardMember->ward_info ?? ''); ?>" placeholder="e.g., Ward 5 - East">
                                        <?php $__errorArgs = ['ward_info'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                
                                    <!-- Member Name -->
                                    <div class="mb-3">
                                        <label for="member_name" class="form-label">Member Name</label>
                                        <input type="text" class="form-control" id="member_name" name="member_name" 
                                               value="<?php echo e($wardMember->member_name ?? ''); ?>">
                                        <?php $__errorArgs = ['member_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                
                                    <!-- Mobile No -->
                                    <div class="mb-3">
                                        <label for="mobile_no" class="form-label">Mobile Number</label>
                                        <input type="text" class="form-control" id="mobile_no" name="mobile_no" 
                                               value="<?php echo e($wardMember->mobile_no ?? ''); ?>">
                                        <?php $__errorArgs = ['mobile_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                
                                    <!-- Member List File -->
                                    <!-- Member List File -->
                                        <div class="mb-3">
                                            <label for="member_list" class="form-label">Member List (Upload File)</label>
                                            <input type="file" class="form-control" id="member_list" name="member_list">
                                        
                                            <!-- JS will inject preview here -->
                                            <div id="current-file-preview" class="mt-2"></div>
                                        
                                            <?php $__errorArgs = ['member_list'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="text-danger"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                    <!-- Status -->
                                    <div class="mb-3">
                                        <label for="status" class="form-label">Status</label>
                                        <select class="form-control" id="status" name="status">
                                            <option value="1" <?php echo e((isset($wardMember) && $wardMember->status == 1) ? 'selected' : ''); ?>>Active</option>
                                            <option value="0" <?php echo e((isset($wardMember) && $wardMember->status == 0) ? 'selected' : ''); ?>>Inactive</option>
                                        </select>
                                    </div>
                                
                                    <!-- Submit -->
                                    <button type="submit" class="btn btn-primary">Save</button>
                                    <a href="<?php echo e(route('mis.wardmember.index')); ?>" class="btn btn-secondary">Cancel</a>
                            </form>

                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <!-- Displaying Success Message -->
                        <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>

                        <!-- Displaying Error Messages -->
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="col-lg-8 mx-auto">
                <div class="card">
                    <div class="card-header radius-15 bg-primary">
                        <div class="d-flex align-items-center">
                            <h6 class="mb-0 text-white">Wards List</h6>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="example">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Ward Info</th>
                                        <th>Member Number</th>
                                        <th>Mobile Number</th>
                                        <th>Member List</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- DataTables -->

<script>
$(function () {
    $('#example').DataTable({
        processing: true,
        serverSide: true,
        ajax: '<?php echo e(route('mis.wardmember.data')); ?>',
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex'},
            { data: 'ward_info', name: 'ward_info'},
            { data: 'member_name', name: 'member_name'},
            { data: 'mobile_no', name: 'mobile_no'},
            { data: 'member_list', name: 'member_list'},
            { data: 'status', name: 'status'},
            { data: 'actions', name: 'actions', orderable: false, searchable: false}
        ]
    });
});


   $(document).ready(function () {
    $(document).on("submit", "#SameForm", function (e) {
        e.preventDefault();

        let formData = new FormData(this);
        $.ajax({
            url: "<?php echo e(route('mis.wardmember.store')); ?>",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: function (res) {
    if (res.status == "add") {
        $("#SameForm")[0].reset();
        $('#example').DataTable().ajax.reload();
    }

    if (res.status == 'update') {
    $('#example').DataTable().ajax.reload(null, false);
    $("#SameForm")[0].reset();
    $("#SameForm input[name='id']").val('');

    // ✅ Remove the current file preview after update
    $('#current-file-preview').remove();
}


    toastr.success(res.msg);
},
            error: function (xhr) {
                let error = xhr.responseJSON.errors;
                $.each(error, function (key, value) {
                    $(`.${key}`).html(value);
                    toastr.error(value);
                });
            }
        });
    });
});


$(document).on('click', '.edit-btn', function () {
    let id = $(this).data('id');

    $.ajax({
        url: `/mis/wardsmember/get/${id}`,
        method: 'GET',
        success: function (data) {
            // ✅ Fill form fields
            $('#SameForm input[name="id"]').val(data.id);
            $('#SameForm input[name="ward_info"]').val(data.ward_info);
            $('#SameForm input[name="member_name"]').val(data.member_name);
            $('#SameForm input[name="mobile_no"]').val(data.mobile_no);
            $('#SameForm select[name="status"]').val(data.status);

            // ✅ Show preview of uploaded file
            if (data.member_list) {
                let fileUrl = `/storage/${data.member_list}`;
                let fileName = data.member_list.split('/').pop();
                let extension = fileName.split('.').pop().toLowerCase();

                // File type check
                let imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];

                let previewHtml = '';

                if (imageExtensions.includes(extension)) {
                    // ✅ Show image preview
                    previewHtml = `<img src="${fileUrl}" alt="Member Image" style="max-height: 80px;">`;
                } else {
                    // ✅ Show view file link
                    previewHtml = `<a href="${fileUrl}" target="_blank">View File</a>`;
                }

                // Remove old preview if any
                $('#current-file-preview').remove();

                // Add new preview
                $('#SameForm input[name="member_list"]').after(`
                    <div id="current-file-preview" class="mt-2">
                        ${previewHtml}
                    </div>
                `);
            } else {
                $('#current-file-preview').remove(); // If no file, remove preview
            }
        },
        error: function () {
            alert('Data load karne me error aaya');
        }
    });
});




    $(document).on("click", ".btn-delete", function () {
                let delUrl = $(this).data("delid");
                $.ajax({
                    url: delUrl,
                    type: "GET",
                    success: function (res) {
                        if (res.status === 1) {
                            toastr.success("Data has been deleted successfully");
                        } else {
                            toastr.error('Something went wrong');
                        }
                         $('#example').DataTable().ajax.reload();
                    }
                })
            })


    



</script>

<?php $__env->stopSection(); ?>
  
<?php echo $__env->make('admin.layouts.adminApp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/npgovardhan25/public_html/resources/views/mis/wardmember/memberward.blade.php ENDPATH**/ ?>