<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="page-content">

        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Edit Property Surveyor</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="#"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Edit Property Surveyor</li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Flash Messages -->
        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <!-- Form Start -->
        <form action="<?php echo e(route('gis.properties.update', $property->id)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h6>Property Details</h6>
                </div>
                <div class="card-body row">
                    
                    <div class="col-md-2 mb-3">
                        <label for="period">Ward No</label>
                        <select name="period" class="form-select">
                            <option value="">Select Assessment Year</option> 
                            <option value="2022-2023" <?php echo e($property->period == '2022-2023' ? 'selected' : ''); ?>>2022-2023</option>
                            <option value="2023-2024" <?php echo e($property->period == '2023-2024' ? 'selected' : ''); ?>>2023-2024</option>
                            <option value="2024-2025" <?php echo e($property->period == '2024-2025' ? 'selected' : ''); ?>>2024-2025</option>
                            <option value="2025-2026" <?php echo e($property->period == '2025-2026' ? 'selected' : ''); ?>>2025-2026</option>
                            
                        </select>
                    </div>
                    
                    <div class="col-md-2 mb-3">
                        <label for="ulbNameCode">ULB's Name/Code</label>
                        <input type="text" name="ulbNameCode" class="form-control" value="<?php echo e($property->ulbNameCode); ?>" readonly required>
                    </div>

                    <div class="col-md-3 mb-3">
                        <label for="wardNo">Ward No</label>
                        <select name="wardNo" class="form-select">
                            <option value="">Select Ward No</option>
                            <?php $__currentLoopData = $allInOne['wards']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($ward->id); ?>" <?php echo e($ward->id == $property->wardNo ? 'selected' : ''); ?>><?php echo e($ward->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="nagarpalikaId">E-Nagarpalika Id</label>
                        <input type="text" name="nagarpalikaId" class="form-control" value="<?php echo e($property->nagarpalikaId); ?>">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="parcelNo">Parcel No</label>
                        <input type="text" name="parcelNo" class="form-control" value="<?php echo e($property->parcelNo); ?>">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="propertyNo">Property No</label>
                        <input type="text" name="propertyNo" class="form-control" value="<?php echo e($property->propertyNo); ?>">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="electricityId">Electricity Id</label>
                        <input type="text" name="electricityId" class="form-control" value="<?php echo e($property->electricityId); ?>">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="khasraNo">Khasra No</label>
                        <input type="text" name="khasraNo" class="form-control" value="<?php echo e($property->khasraNo); ?>">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="registryNo">Registry No</label>
                        <input type="text" name="registryNo" class="form-control" value="<?php echo e($property->registryNo); ?>">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="constructedDate">Constructed Date</label>
                        <input type="text" name="constructedDate" class="form-control" value="<?php echo e($property->constructedDate); ?>">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="isSlum">Slum</label>
                        <select name="isSlum" id="isSlum" class="form-select">
                            <option value="yes" <?php echo e($property->isSlum == 'yes' ? 'selected' : ''); ?>>Yes</option>
                            <option value="no" <?php echo e($property->isSlum == 'no' ? 'selected' : ''); ?>>No</option>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3" id="slumIdContainer" style="<?php echo e($property->isSlum == 'yes' ? '' : 'display:none;'); ?>">
                        <label for="slumId">Slum ID</label>
                        <input type="text" name="slumId" id="slumId" class="form-control" value="<?php echo e($property->slumId); ?>">
                    </div>

                </div>
 
            </div>
            
            <div class="card">
                <div class="card-header radius-15 bg-primary">
                    <div class="d-flex align-items-center">
                        <h6 class="mb-0 text-white">Owner Details</h6>
                    </div>
                </div>
                <div class="card-body p-4 row"> 
            
                    <!-- Name of Respondent -->
                    <div class="col-md-3 mb-3">
                        <label for="respondentName" class="form-label">Name of Respondent</label>
                        <input type="text" class="form-control" id="respondentName" name="respondentName" value="<?php echo e($property->respondentName ?? ''); ?>" required>
                        <?php $__errorArgs = ['respondentName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
            
                    <!-- Respondent Relationship -->
                    <div class="col-md-2 mb-3">
                        <label for="respondentRelationship" class="form-label">Respondent with Owner</label>
                        <select class="form-select form-select-sm" id="respondentRelationship" name="respondentRelationship" required>
                            <option value="">Select Respondent Relationship</option>
                            <?php $__currentLoopData = $allInOne['relationshipWithOwner']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$relationshipWithOwner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($relationshipWithOwner->id); ?>" <?php echo e($property->respondentRelationship == $relationshipWithOwner->id  ? 'selected' : ''); ?>><?php echo e($relationshipWithOwner->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>  
                        </select>
                        <?php $__errorArgs = ['respondentRelationship'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
            
                    <!-- Owner Aadhaar Number -->
                    <div class="col-md-2 mb-3">
                        <label for="ownerAadhaarNumber" class="form-label">Owner Aadhaar Number</label>
                        <input type="number" class="form-control" id="ownerAadhaarNumber" name="ownerAadhaarNumber" value="<?php echo e($property->ownerAadhaarNumber ?? ''); ?>">
                        <?php $__errorArgs = ['ownerAadhaarNumber'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="ownerAadhaarNumber" class="form-label">
                            Upload Owner Aadhaar (Front & Back PDF)
                        </label>
                        <input type="file" class="form-control" id="ownerAadhaarNumber" name="ownerAadhaarNumber" accept="application/pdf">
                        
                        <?php $__errorArgs = ['ownerAadhaarNumber'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    
                        <?php if(!empty($property->ownerAadhaarNumber)): ?>
                            <small class="form-text text-muted">
                                Current file: 
                                <a href="<?php echo e(asset('storage/' . $property->ownerAadhaarNumber)); ?>" target="_blank">View PDF</a>
                            </small>
                        <?php endif; ?>
                    </div>
                    
                    <div class="col-md-2 mb-3">
                        <label for="number_of_members" class="form-label">Number of Famliy Members</label>
                        <input type="number" class="form-control" id="number_of_members" name="number_of_members" value="<?php echo e($property->number_of_members ?? ''); ?>">
                        <?php $__errorArgs = ['number_of_members'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Owner Details Table -->
                    <div class="col-md-12 mb-3">
                        <label for="ownerDetails" class="form-label">Owner(s) Information</label>
                        <table class="table" id="owner-table">
                            <thead>
                                <tr>
                                    <th>Owner Name</th>
                                    <th>Father/Husband Name</th>
                                    <th>Mobile No.</th>
                                    <th>Secondary Mobile No.</th>
                                    <th>Email</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $owners = is_array($property->ownerDetails) ? $property->ownerDetails : json_decode($property->ownerDetails, true);
                                ?>
                                <?php if($owners): ?>
                                    <?php $__currentLoopData = $owners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $owner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="owner-row" data-index="<?php echo e($k); ?>">
                                            <td><input type="text" class="form-control" name="ownerDetails[<?php echo e($k); ?>][name]" value="<?php echo e($owner['name'] ?? ''); ?>" required></td>
                                            <td><input type="text" class="form-control" name="ownerDetails[<?php echo e($k); ?>][fatherName]" value="<?php echo e($owner['fatherName'] ?? ''); ?>" required></td>
                                            <td><input type="number" class="form-control" name="ownerDetails[<?php echo e($k); ?>][mobile]" value="<?php echo e($owner['mobile'] ?? ''); ?>" required></td>
                                            <td><input type="number" class="form-control" name="ownerDetails[<?php echo e($k); ?>][secondaryPhone]" value="<?php echo e($owner['secondaryPhone'] ?? ''); ?>"></td>
                                            <td><input type="email" class="form-control" name="ownerDetails[<?php echo e($k); ?>][email]" value="<?php echo e($owner['email'] ?? ''); ?>"></td>
                                            <td><button type="button" class="btn btn-danger btn-sm remove-owner-btn">Remove</button></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="6" class="text-end">
                                        <button type="button" class="btn btn-primary" id="add-owner-btn">Add Owner</button>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            <!-- Owner Details --> 

            <!-- Address Details -->
            <div class="card">
                <div class="card-header radius-15 bg-primary">
                    <div class="d-flex align-items-center">
                        <h6 class="mb-0 text-white">Address Details</h6>
                    </div>
                </div> 
                <div class="card-body p-4 row">
                    <div class="col-md-2 mb-3">
                        <label for="houseNo" class="form-label">House No</label>
                        <input type="text" class="form-control" id="houseNo" name="houseNo" value="<?php echo e($property->houseNo ?? ''); ?>" >
                        <?php $__errorArgs = ['houseNo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="streetNoName" class="form-label">Street No / Name</label>
                        <input type="text" class="form-control" id="streetNoName" name="streetNoName" value="<?php echo e($property->streetNoName ?? ''); ?>" required>
                        <?php $__errorArgs = ['streetNoName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="locality" class="form-label">Locality</label>
                        <input type="text" class="form-control" id="locality" name="locality" value="<?php echo e($property->locality ?? ''); ?>" required>
                        <?php $__errorArgs = ['locality'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="colony" class="form-label">Colony</label>
                        <input type="text" class="form-control" id="colony" name="colony" value="<?php echo e($property->colony ?? ''); ?>" required>
                        <?php $__errorArgs = ['colony'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="city" class="form-label">City</label>
                        <input type="text" class="form-control" id="city" name="city" value="<?php echo e($property->city ?? ''); ?>" required>
                        <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="pincode" class="form-label">Pincode</label>
                        <input type="text" class="form-control" id="pincode" name="pincode" value="<?php echo e($property->pincode ?? ''); ?>" required>
                        <?php $__errorArgs = ['pincode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                
                    <div class="col-md-12 mb-3">
                        <label for="isSameAsProperty" class="form-label">Same As Property</label>
                        <input type="checkbox" class="form-checkbox" 
                               id="isSameAsProperty" 
                               name="isSameAsProperty" 
                               <?php echo e($property->isSameAsProperty == 'true' ? 'checked' : ''); ?>

                               value="true" 
                        >
                        <?php $__errorArgs = ['isSameAsProperty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                
                    <!-- Present Address Fields -->
                    <div class="col-md-2 mb-3">
                        <label for="presentHouseNo" class="form-label">Present House No</label>
                        <input type="text" class="form-control" id="presentHouseNo" name="presentHouseNo" value="<?php echo e($property->presentHouseNo ?? ''); ?>" >
                        <?php $__errorArgs = ['presentHouseNo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="presentStreetNoName" class="form-label">Present Street No / Name</label>
                        <input type="text" class="form-control" id="presentStreetNoName" name="presentStreetNoName" value="<?php echo e($property->presentStreetNoName ?? ''); ?>" required>
                        <?php $__errorArgs = ['presentStreetNoName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="presentLocality" class="form-label">Present Locality</label>
                        <input type="text" class="form-control" id="presentLocality" name="presentLocality" value="<?php echo e($property->presentLocality ?? ''); ?>" required>
                        <?php $__errorArgs = ['presentLocality'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="presentColony" class="form-label">Present Colony</label>
                        <input type="text" class="form-control" id="presentColony" name="presentColony" value="<?php echo e($property->presentColony ?? ''); ?>" required>
                        <?php $__errorArgs = ['presentColony'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="presentCity" class="form-label">Present City</label>
                        <input type="text" class="form-control" id="presentCity" name="presentCity" value="<?php echo e($property->presentCity ?? ''); ?>" required>
                        <?php $__errorArgs = ['presentCity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="presentPincode" class="form-label">Present Pincode</label>
                        <input type="text" class="form-control" id="presentPincode" name="presentPincode" value="<?php echo e($property->presentPincode ?? ''); ?>" required>
                        <?php $__errorArgs = ['presentPincode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div> 

            </div>
            
            <div class="card">
                <div class="card-header radius-15 bg-primary">
                    <div class="d-flex align-items-center">
                        <h6 class="mb-0 text-white">Taxation Details</h6>
                    </div>
                </div>
                <div class="card-body p-4 row"> 
                    <div class="col-md-3 mb-3">
                        <label for="taxRateZone" class="form-label">Tax Rate Zone</label>
                        <select class="form-select form-select-sm" id="taxRateZone" name="taxRateZone">
                            <option value="">Select Tax Rate Zone</option>
                            <?php $__currentLoopData = $allInOne['currentTaxRateZone']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$taxRateZone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($taxRateZone->id); ?>" <?php echo e($taxRateZone->id == $property->taxRateZone ? 'selected' : ''); ?>><?php echo e($taxRateZone->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>  
                        </select>
                        <?php $__errorArgs = ['taxRateZone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>  
                    
                   <div class="col-md-3 mb-3">
                    <label for="propertyOwnership" class="form-label">Ownerships</label>
                    <select class="form-select form-select-sm" id="propertyOwnership" name="propertyOwnership">
                        <option value="">Select Ownership</option>
                        <?php $__currentLoopData = $allInOne['propertyOwnership']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownership): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($ownership->id); ?>" <?php echo e($ownership->id == $property->propertyOwnership ? 'selected' : ''); ?>>
                                <?php echo e($ownership->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </select>
                    <?php $__errorArgs = ['propertyOwnership'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger"><?php echo e($message); ?></div>
                     <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                <div class="col-md-2 mb-3">
                    <label for="situation" class="form-label">Situations</label>
                    <select class="form-select form-select-sm" id="situation" name="situation">
                        <option value="">Select Situation</option>

                        <?php $__currentLoopData = $allInOne['situation']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $situation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($situation->id); ?>"
                                <?php echo e($property?->situation == $situation->id ? 'selected' : ''); ?>>
                                <?php echo e($situation->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                    </select>

                    <?php $__errorArgs = ['situation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                    <div class="col-md-2 mb-3">
                        <label for="propertyType" class="form-label">Property Type</label>
                        <select class="form-select form-select-sm" id="propertyType" name="propertyType" required>
                            <option value="">Select Property Type</option>
                            <?php $__currentLoopData = $allInOne['propertyType']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $propertyType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($propertyType->id); ?>" 
                                    <?php echo e($propertyType->id == $property->propertyType ? 'selected' : ''); ?>>
                                    <?php echo e($propertyType->type_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>  
                        </select>

                        <?php $__errorArgs = ['propertyType'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div> 
                     
                    
                    <div class="col-md-2 mb-3">
                        <label for="propertyUse" class="form-label">Property Use</label>
                        <select class="form-select form-select-sm" id="propertyUse" name="propertyUse" required>
                            <option value="">Select Property Use</option>
                        
                            
                            <?php $__currentLoopData = $allInOne['propertyUse']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $propertyUse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($propertyUse->id); ?>" 
                                    <?php echo e($propertyUse->id == $property->propertyUse ? 'selected' : ''); ?>>
                                    <?php echo e($propertyUse->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>  
                        </select>

                        <?php $__errorArgs = ['propertyUse'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>  
                    <div class="col-md-2 mb-3">
                        <label for="roadType" class="form-label"> Road Type</label>
                        <select class="form-select form-select-sm" id="roadType" name="roadType" required>
                            <option value="">Select Road Type</option>
                            <?php $__currentLoopData = $allInOne['roadType']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$roadType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($roadType->id); ?>" <?php echo e($roadType->id == $property->roadType ? 'selected' : ''); ?>><?php echo e($roadType->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>  
                        </select>
                        <?php $__errorArgs = ['roadType'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-2 mb-3">
                            <label for="yearOfConstruction" class="form-label">Year of Construction</label>
                        <select class="form-select form-select-sm" id="yearOfConstruction" name="yearOfConstruction">
                            <option value="">Select Year of Construction</option> 
                                <?php $__currentLoopData = $allInOne['yearOfConstruction']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $yearOfConstruction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($yearOfConstruction->id); ?>"
                                        <?php echo e($property->yearOfConstruction == $yearOfConstruction->id ? 'selected' : ''); ?>>
                                            <?php echo e($yearOfConstruction->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
 
                        </select>

                                <?php $__errorArgs = ['yearOfConstruction'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div> 
                </div>
            </div>
            
            <?php 
                $floorData = json_decode($property->floorData);
                if (!is_array($floorData)) { $floorData = json_decode($floorData); } 
            ?>
            
            <div class="card">
                <div class="card-header radius-15 bg-primary">
                    <div class="d-flex align-items-center">
                        <h6 class="mb-0 text-white">Area Detail</h6>
                    </div>
                </div>
                <div class="card-body p-4 row">
                    
                    <div class="col-md-3 mb-3">
                        <label for="plotAreaSqFt" class="form-label">Plot Area (sq. ft)</label>
                        <input type="text" class="form-control" id="plotAreaSqFt" name="plotAreaSqFt" 
                               value="<?php echo e(old('plotAreaSqFt', $property->plotAreaSqFt ?? '')); ?>" 
                               oninput="convertPlotArea(this)" required>
                        <?php $__errorArgs = ['plotAreaSqFt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
            
                    <div class="col-md-3 mb-3">
                        <label for="plotAreaSqMeter" class="form-label">Plot Area (sq. meter)</label>
                        <input type="text" class="form-control" id="plotAreaSqMeter" name="plotAreaSqMeter" 
                               value="<?php echo e(old('plotAreaSqMeter', $property->plotAreaSqMeter ?? '')); ?>" 
                               oninput="convertPlotArea(this)" required>
                        <?php $__errorArgs = ['plotAreaSqMeter'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
            
                    <div class="col-md-3 mb-3">
                        <label for="plinthAreaSqFt" class="form-label">Plinth Area (sq. ft)</label>
                        <input type="text" class="form-control" id="plinthAreaSqFt" name="plinthAreaSqFt"  value="<?php echo e($property->plinthAreaSqFt ?? ''); ?>"  oninput="convertPlinthArea(this)" readonly required>
                        <?php $__errorArgs = ['plinthAreaSqFt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
            
                    <div class="col-md-3 mb-3">
                        <label for="plinthAreaSqMeter" class="form-label">Plinth Area (sq. meter)</label>
                        <input type="text" class="form-control" id="plinthAreaSqMeter" name="plinthAreaSqMeter"  value="<?php echo e($property->plinthAreaSqMeter ?? ''); ?>" oninput="convertPlinthArea(this)" readonly required>
                        <?php $__errorArgs = ['plinthAreaSqMeter'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
            
                    
                    <div class="col-md-12 mb-3">
                        <table class="table table-bordered" id="floor-table">
                            <thead>
                                <tr>
                                    <th>Floor No</th>
                                    <th>Area (sq. ft)</th>
                                    <th>Area (sq. meter)</th>
                                    <th>Usage Type</th>
                                    <th>Usage Factor</th>
                                    <th>Construction Type</th>
                                    <th>Remove</th>
                                </tr>
                            </thead>
                            <tbody id="floor-table-body">
                                <?php $__currentLoopData = $floorData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $floor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="floor-row" data-index="<?php echo e($k); ?>">
                                        
                                        <td>
                                            <select class="form-select form-select-sm floorType" name="floors[<?php echo e($k); ?>][floorType]" required >
                                                <option value="">Select Floor Type</option>
                                                <?php $__currentLoopData = $allInOne['floorType']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($fl->id); ?>" <?php echo e($fl->id == $floor->floorType ? 'selected' : ''); ?>>
                                                        <?php echo e($fl->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php $__errorArgs = ["floors.$k.floorType"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </td>
            
                                        
                                        <td>
                                            <input type="text" class="form-control areaSqFt" name="floors[<?php echo e($k); ?>][areaSqFt]" 
                                                   value="<?php echo e($floor->areaSqFt); ?>" oninput="convertToSqMeter(this)" required >
                                        </td>
            
                                        
                                        <td>
                                            <input type="text" class="form-control areaSqMeter" name="floors[<?php echo e($k); ?>][areaSqMt]" 
                                                   value="<?php echo e($floor->areaSqMt); ?>" oninput="convertToSqFeet(this)" required >
                                        </td>
            
                                        
                                        <td>
                                            <select class="form-select form-select-sm" name="floors[<?php echo e($k); ?>][usageType]" required >
                                                <option value="">Select Usage Type</option>
                                                <?php $__currentLoopData = $allInOne['propertyType']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usageType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($usageType->id); ?>" <?php echo e($usageType->id == $floor->usageType ? 'selected' : ''); ?>>
                                                        <?php echo e($usageType->type_name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>
            
                                        
                                        <td>
                                            <select class="form-select form-select-sm" name="floors[<?php echo e($k); ?>][usageFactor]" required >
                                                <option value="">Select Usage Factor</option>
                                                <?php $__currentLoopData = $allInOne['usagsFactor']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($factor->id); ?>" <?php echo e($factor->id == $floor->usageFactor ? 'selected' : ''); ?>>
                                                        <?php echo e($factor->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>
            
                                        
                                        <td>
                                            <select class="form-select form-select-sm" name="floors[<?php echo e($k); ?>][constructionType]" required >
                                                <option value="">Select Construction Type</option>
                                                <?php $__currentLoopData = $allInOne['natureOfConstruction']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $construction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($construction->id); ?>" <?php echo e($construction->id == $floor->constructionType ? 'selected' : ''); ?>>
                                                        <?php echo e($construction->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>
            
                                        
                                        <td class="text-center">
                                            <button type="button" class="btn btn-danger btn-sm remove-floor-btn" onclick="removeFloorRow(this)">
                                                ✕
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="7" class="text-end">
                                        <button type="button" class="btn btn-primary" id="add-floor-btn">+ Add More Floor</button>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
            
                    
                    <div class="col-md-3 mb-3">
                        <label for="totalBuiltUpAreaSqFt" class="form-label">Total Built-Up Area (sq. ft)</label>
                        <input type="text" class="form-control" id="totalBuiltUpAreaSqFt" name="totalBuiltUpAreaSqFt" 
                               value="<?php echo e(old('totalBuiltUpAreaSqFt', $property->totalBuiltUpAreaSqFt ?? '')); ?>" required>
                        <?php $__errorArgs = ['totalBuiltUpAreaSqFt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
            
                    <div class="col-md-3 mb-3">
                        <label for="totalBuiltUpAreaSqMeter" class="form-label">Total Built-Up Area (sq. meter)</label>
                        <input type="text" class="form-control" id="totalBuiltUpAreaSqMeter" name="totalBuiltUpAreaSqMeter" 
                               value="<?php echo e(old('totalBuiltUpAreaSqMeter', $property->totalBuiltUpAreaSqMeter ?? '')); ?>" required>
                        <?php $__errorArgs = ['totalBuiltUpAreaSqMeter'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-header radius-15 bg-primary">
                    <div class="d-flex align-items-center">
                        <h6 class="mb-0 text-white">Municipal Town Supply</h6>
                    </div>
                </div>
            
                <div class="card-body p-4 row">
                    
                    <div class="col-md-3 mb-3">
                        <label for="isMuncipalWaterSupply" class="form-label">Municipal Water Supply Connection</label>
                        <select class="form-select form-select-sm" id="isMuncipalWaterSupply" name="isMuncipalWaterSupply">
                            <option value="yes" <?php echo e(old('isMuncipalWaterSupply', $property->isMuncipalWaterSupply ?? '') == 'yes' ? 'selected' : ''); ?>>Yes</option>
                            <option value="no"  <?php echo e(old('isMuncipalWaterSupply', $property->isMuncipalWaterSupply ?? '') == 'no' ? 'selected' : ''); ?>>No</option>
                        </select>
                    </div>
            
                    
                    <div class="col-md-9 mb-3" id="municipalWaterDetails" 
                         style="display: <?php echo e($property->isMuncipalWaterSupply == 'yes' ? 'block' : 'none'); ?>;">
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="totalWaterConnection" class="form-label">No of Connection</label>
                                <input type="number" 
                                       class="form-control" 
                                       id="totalWaterConnection" 
                                       name="totalWaterConnection" 
                                       min="1" 
                                       max="10"
                                       value="<?php echo e(old('totalWaterConnection', $property->totalWaterConnection ?? '')); ?>" 
                                       oninput="totalWaterConn(this)">
                                <small class="text-muted">Maximum 10 connections allowed.</small>
                            </div>
                            <div class="col-md-9">
                                <table class="table" id="connection-table">
                                    <thead>
                                        <tr>
                                            <th>SN</th>
                                            <th>Enter Connection Id</th>
                                            <th>Water Connection Type</th>
                                        </tr>
                                    </thead>
                                    <tbody id="connection-table-body">
                                        <?php 
                                            $connections = is_array($property->waterConnectionId) 
                                                ? $property->waterConnectionId 
                                                : json_decode($property->waterConnectionId ?? '[]');
                                        ?>
            
                                        <?php $__currentLoopData = $connections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $connection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($k + 1); ?></td>
                                                <td>
                                                    <input type="text" class="form-control" 
                                                           name="waterConnectionId[<?php echo e($k); ?>][id]" 
                                                           value="<?php echo e($connection->id ?? ''); ?>">
                                                </td>
                                                <td>
                                                    <select class="form-select form-select-sm" 
                                                            name="waterConnectionId[<?php echo e($k); ?>][connectionType]">
                                                        <option value="">Water Connection Type</option>
                                                        <?php $__currentLoopData = $allInOne['propertyType']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usageType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($usageType->id); ?>" 
                                                                <?php echo e($usageType->id == ($connection->connectionType ?? '') ? 'selected' : ''); ?>>
                                                                <?php echo e($usageType->type_name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                                                    </select>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
            
                    
                    <div class="col-md-3 mb-3">
                        <label for="sourceOfWater" class="form-label">Source of Water</label>
                        <select class="form-select form-select-sm" id="sourceOfWater" name="sourceOfWater">
                            <option value="">Select Source of Water</option>
                            <?php $__currentLoopData = $allInOne['sourceOfWater']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($source->id); ?>" <?php echo e($source->id == ($property->sourceOfWater ?? '') ? 'selected' : ''); ?>><?php echo e($source->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                        </select>
                    </div>
            
                    
                    <div class="col-md-3 mb-3">
                        <label for="toiletType" class="form-label">Sanitation</label>
                        <select class="form-select form-select-sm" id="toiletType" name="toiletType">
                            <option value="">Select Sanitation</option>
                            <?php $__currentLoopData = $allInOne['sanitation']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sanitation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($sanitation->id); ?>" <?php echo e($sanitation->id == ($property->toiletType ?? '') ? 'selected' : ''); ?>><?php echo e($sanitation->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
            
                    
                    <div class="col-md-3 mb-3">
                        <label for="isMunicipalWasteService" class="form-label">Solid Waste Management</label>
                        <select class="form-select form-select-sm" id="isMunicipalWasteService" name="isMunicipalWasteService">
                            <option value="yes" <?php echo e(old('isMunicipalWasteService', $property->isMunicipalWasteService ?? '') == 'yes' ? 'selected' : ''); ?>>Yes</option>
                            <option value="no"  <?php echo e(old('isMunicipalWasteService', $property->isMunicipalWasteService ?? '') == 'no' ? 'selected' : ''); ?>>No</option>
                        </select>
                    </div>
                </div>
            </div>

            
            <div class="card">
                <div class="card-header radius-15 bg-primary">
                    <h6 class="mb-0 text-white">Location/Photos & Documents</h6>
                </div>
            
                <div class="card-body p-4 row">
                    <div class="col-md-2 mb-3">
                        <label for="latitude" class="form-label">Latitude</label>
                        <input type="text" class="form-control" id="latitude" name="latitude" 
                               value="<?php echo e(old('latitude', $property->latitude ?? '')); ?>" required>
                        <?php $__errorArgs = ['latitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="longitude" class="form-label">Longitude</label>
                        <input type="text" class="form-control" id="longitude" name="longitude" 
                               value="<?php echo e(old('longitude', $property->longitude ?? '')); ?>" required>
                        <?php $__errorArgs = ['longitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <!-- Property First Image -->
                    <div class="col-md-2 mb-3">
                        <label for="propertyFirstImage" class="form-label">Property First Image</label>
                        <input type="file" class="form-control" id="propertyFirstImage" name="propertyFirstImage" accept="image/*">
                        <?php $__errorArgs = ['propertyFirstImage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            
                        <?php if(!empty($property->propertyFirstImage)): ?>
                            <div class="mt-2">
                                <a href="<?php echo e(asset('storage/' . $property->propertyFirstImage)); ?>" target="_blank">
                                    <img src="<?php echo e(asset('storage/' . $property->propertyFirstImage)); ?>" 
                                         alt="Property First Image" 
                                         style="max-width:100px; max-height:100px; border:1px solid #ddd;">
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
            
                    <!-- Property Second Image -->
                    <div class="col-md-2 mb-3">
                        <label for="propertySecondImage" class="form-label">Property Second Image</label>
                        <input type="file" class="form-control" id="propertySecondImage" name="propertySecondImage" accept="image/*">
                        <?php $__errorArgs = ['propertySecondImage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            
                        <?php if(!empty($property->propertySecondImage)): ?>
                            <div class="mt-2">
                                <a href="<?php echo e(asset('storage/' . $property->propertySecondImage)); ?>" target="_blank">
                                    <img src="<?php echo e(asset('storage/' . $property->propertySecondImage)); ?>" 
                                         alt="Property Second Image" 
                                         style="max-width:100px; max-height:100px; border:1px solid #ddd;">
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
            
                    <!-- Owner Image -->
                    <div class="col-md-2 mb-3">
                        <label for="ownerImage" class="form-label">Owner Image</label>
                        <input type="file" class="form-control" id="ownerImage" name="ownerImage" accept="image/*">
                        <?php $__errorArgs = ['ownerImage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            
                        <?php if(!empty($property->ownerImage)): ?>
                            <div class="mt-2">
                                <a href="<?php echo e(asset('storage/' . $property->ownerImage)); ?>" target="_blank">
                                    <img src="<?php echo e(asset('storage/' . $property->ownerImage)); ?>" 
                                         alt="Owner Image" 
                                         style="max-width:100px; max-height:100px; border:1px solid #ddd;">
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
            
                    <!-- Supporting Documents -->
                    <div class="col-md-3 mb-3">
                        <label for="supportingDocuments" class="form-label">Supporting Documents</label>
                        <input type="file" class="form-control" id="supportingDocuments" name="supportingDocuments[]" accept=".pdf,image/*" multiple>
                        <?php $__errorArgs = ['supportingDocuments'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            
                        <?php if(!empty($property->supportingDocuments) && is_array($property->supportingDocuments)): ?>
                            <div class="mt-2">
                                <p class="text-muted mb-1">Uploaded:</p>
                                <div class="d-flex flex-wrap gap-2">
                                    <?php $__currentLoopData = $property->supportingDocuments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div style="text-align:center;">
                                            <?php if(Str::endsWith(strtolower($doc), ['.jpg', '.jpeg', '.png', '.gif'])): ?>
                                                <a href="<?php echo e(asset('storage/' . $doc)); ?>" target="_blank">
                                                    <img src="<?php echo e(asset('storage/' . $doc)); ?>" 
                                                         alt="Supporting Document" 
                                                         style="max-width:80px; max-height:80px; border:1px solid #ddd;">
                                                </a>
                                            <?php elseif(Str::endsWith(strtolower($doc), ['.pdf'])): ?>
                                                <a href="<?php echo e(asset('storage/' . $doc)); ?>" target="_blank">📄 PDF</a>
                                            <?php else: ?>
                                                <a href="<?php echo e(asset('storage/' . $doc)); ?>" target="_blank">📎 <?php echo e(basename($doc)); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            
                <div class="card-footer bg-light">
                    <small class="text-muted">You can upload property images, owner image, and multiple supporting documents here.</small>
                </div>
                <div class="card-footer bg-light d-flex justify-content-end">
                    <button type="submit" class="btn btn-success px-4">
                        <i class="bi bi-save me-1"></i> Save Changes
                    </button>
                </div>
            </div>


        </form>
        <!-- Form End -->

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const isSlum = document.getElementById('isSlum');
        const slumIdContainer = document.getElementById('slumIdContainer');

        isSlum.addEventListener('change', function () {
            slumIdContainer.style.display = (this.value === 'yes') ? 'block' : 'none';
        });
    });
</script> 

<script>
    let ownerIndex = <?php echo e(isset($owners) ? count($owners) : 0); ?>;

    document.getElementById('add-owner-btn').addEventListener('click', function () {
        const tableBody = document.querySelector('#owner-table tbody');
        const row = document.createElement('tr');
        row.classList.add('owner-row');
        row.setAttribute('data-index', ownerIndex);

        row.innerHTML = `
            <td><input type="text" class="form-control" name="ownerDetails[${ownerIndex}][name]" required></td>
            <td><input type="text" class="form-control" name="ownerDetails[${ownerIndex}][fatherName]" required></td>
            <td><input type="number" class="form-control" name="ownerDetails[${ownerIndex}][mobile]" required></td>
            <td><input type="number" class="form-control" name="ownerDetails[${ownerIndex}][secondaryPhone]"></td>
            <td><input type="email" class="form-control" name="ownerDetails[${ownerIndex}][email]"></td>
            <td><button type="button" class="btn btn-danger btn-sm remove-owner-btn">Remove</button></td>
        `;
        tableBody.appendChild(row);
        ownerIndex++;
    });

    document.addEventListener('click', function (e) {
        if (e.target && e.target.classList.contains('remove-owner-btn')) {
            e.target.closest('tr').remove();
        }
    });
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const floorTableBody = document.getElementById('floor-table-body');
    const addFloorBtn = document.getElementById('add-floor-btn');

    // Function to update the index on all rows
    function updateFloorRowIndices() {
        const rows = floorTableBody.querySelectorAll('tr.floor-row');
        rows.forEach((row, index) => {
            row.dataset.index = index;
            // Update all inputs/selects inside this row
            row.querySelectorAll('select, input').forEach(el => {
                // Extract the base name without the index part and replace with new index
                const name = el.name;
                if (!name) return;

                const newName = name.replace(/floors\[\d+\]/, `floors[${index}]`);
                el.name = newName;
            });
        });
    }

    // Function to create a new empty floor row
    function createNewFloorRow(index) {
        // Create table row element
        const tr = document.createElement('tr');
        tr.classList.add('floor-row');
        tr.dataset.index = index;

        // Using template literals for easy multi-line HTML
        tr.innerHTML = `
            <td>
                <select class="form-select form-select-sm floorType" name="floors[${index}][floorType]">
                    <option value="">Select Floor Type</option>
                    <?php $__currentLoopData = $allInOne['floorType']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($fl->id); ?>"><?php echo e($fl->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </td>
            <td>
                <input type="text" class="form-control areaSqFt" name="floors[${index}][areaSqFt]" oninput="convertToSqMeter(this)">
            </td>
            <td>
                <input type="text" class="form-control areaSqMeter" name="floors[${index}][areaSqMt]" oninput="convertToSqFeet(this)">
            </td>
            <td>
                <select class="form-select form-select-sm" name="floors[${index}][usageType]">
                    <option value="">Select Usage Type</option>
                    <?php $__currentLoopData = $allInOne['propertyType']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usageType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($usageType->id); ?>"><?php echo e($usageType->type_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </td>
            <td>
                <select class="form-select form-select-sm" name="floors[${index}][usageFactor]">
                    <option value="">Select Usage Factor</option>
                    <?php $__currentLoopData = $allInOne['usagsFactor']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($factor->id); ?>"><?php echo e($factor->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </td>
            <td>
                <select class="form-select form-select-sm" name="floors[${index}][constructionType]">
                    <option value="">Select Construction Type</option>
                    <?php $__currentLoopData = $allInOne['natureOfConstruction']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $construction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($construction->id); ?>"><?php echo e($construction->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </td>
            <td class="text-center">
                <button type="button" class="btn btn-danger btn-sm remove-floor-btn">✕</button>
            </td>
        `;
        return tr;
    }

    // Add new floor row event
    addFloorBtn.addEventListener('click', () => {
        const currentRows = floorTableBody.querySelectorAll('tr.floor-row').length;
        const newRow = createNewFloorRow(currentRows);
        floorTableBody.appendChild(newRow);
    });

    // Delegate click event for remove buttons inside the table body
    floorTableBody.addEventListener('click', (event) => {
        if (event.target.classList.contains('remove-floor-btn')) {
            const row = event.target.closest('tr.floor-row');
            if (row) {
                row.remove();
                updateFloorRowIndices();
            }
        }
    });

});


function convertPlotArea(el) {
    const sqFtInput = document.getElementById('plotAreaSqFt');
    const sqMInput = document.getElementById('plotAreaSqMeter');

    if (el.id === 'plotAreaSqFt') {
        let value = parseFloat(sqFtInput.value) || 0;
        sqMInput.value = (value * 0.092903).toFixed(2);
    } else if (el.id === 'plotAreaSqMeter') {
        let value = parseFloat(sqMInput.value) || 0;
        sqFtInput.value = (value / 0.092903).toFixed(2);
    }
}

function convertPlinthArea(el) {
    const sqFtInput = document.getElementById('plinthAreaSqFt');
    const sqMInput = document.getElementById('plinthAreaSqMeter');

    if (el.id === 'plinthAreaSqFt') {
        let value = parseFloat(sqFtInput.value) || 0;
        sqMInput.value = (value * 0.092903).toFixed(2);
    } else if (el.id === 'plinthAreaSqMeter') {
        let value = parseFloat(sqMInput.value) || 0;
        sqFtInput.value = (value / 0.092903).toFixed(2);
    }
}

function convertToSqMeter(input) {
    const row = input.closest('tr');
    const sqFt = parseFloat(input.value) || 0;
    const sqMInput = row.querySelector('.areaSqMeter');

    if (sqMInput) {
        sqMInput.value = (sqFt * 0.092903).toFixed(2);
    }

    updatePlinthAndTotal();
}

function convertToSqFeet(input) {
    const row = input.closest('tr');
    const sqM = parseFloat(input.value) || 0;
    const sqFtInput = row.querySelector('.areaSqFt');

    if (sqFtInput) {
        sqFtInput.value = (sqM / 0.092903).toFixed(2);
    }

    updatePlinthAndTotal();
}

function updatePlinthAndTotal() {
    const rows = document.querySelectorAll('tr');

    let totalSqFt = 0;
    let totalSqM = 0;
    let plinthSqFt = 0;
    let plinthSqM = 0;

    rows.forEach(row => {
        const sqFt = parseFloat(row.querySelector('.areaSqFt')?.value) || 0;
        const sqM = parseFloat(row.querySelector('.areaSqMeter')?.value) || 0;
        const floorType = row.querySelector('.floorType')?.value || '';

        // Add to total
        totalSqFt += sqFt;
        totalSqM += sqM;

        // Add to plinth only if floorType is "Ground Floor"
        if (floorType.toLowerCase() === 'ground floor' || floorType == 2) {
            plinthSqFt += sqFt;
            plinthSqM += sqM;
        }
    });

    // Update Plinth Area
    document.getElementById('plinthAreaSqFt').value = plinthSqFt.toFixed(2);
    document.getElementById('plinthAreaSqMeter').value = plinthSqM.toFixed(2);

    // Update Total Built-Up Area
    document.getElementById('totalBuiltUpAreaSqFt').value = totalSqFt.toFixed(2);
    document.getElementById('totalBuiltUpAreaSqMeter').value = totalSqM.toFixed(2);
}





</script>

<script>

function totalWaterConn(input) {
    let count = parseInt(input.value) || 0;
    if (count > 10) {
        alert("You can add a maximum of 10 connections only.");
        input.value = 10;
        count = 10;
    }

    let tbody = document.getElementById('connection-table-body');
    tbody.innerHTML = ''; // clear old rows

    for (let i = 0; i < count; i++) {
        let row = `
            <tr>
                <td>${i + 1}</td>
                <td><input type="text" class="form-control" name="waterConnectionId[${i}][id]"></td>
                <td>
                    <select class="form-select form-select-sm" name="waterConnectionId[${i}][connectionType]">
                        <option value="">Water Connection Type</option>
                        ${propertyTypes.map(type => `<option value="${type.id}">${type.type_name}</option>`).join('')}
                    </select>
                </td>
            </tr>
        `;
        tbody.insertAdjacentHTML('beforeend', row);
    }
}

document.addEventListener("DOMContentLoaded", function () {
    const waterSelect = document.getElementById('isMuncipalWaterSupply');
    const detailsDiv = document.getElementById('municipalWaterDetails');
    const totalInput = document.getElementById('totalWaterConnection');
    const tbody = document.getElementById('connection-table-body');

    // Toggle section when Yes/No selected
    waterSelect.addEventListener("change", function () {
        if (this.value === "yes") {
            detailsDiv.style.display = "block";
        } else {
            detailsDiv.style.display = "none";
            tbody.innerHTML = "";
            totalInput.value = "";
        }
    });

    // Generate rows when number entered
    totalInput?.addEventListener("input", function () {
        const count = parseInt(this.value) || 0;
        tbody.innerHTML = ""; // clear old rows

        for (let i = 0; i < count; i++) {
            const row = `
                <tr>
                    <td>${i + 1}</td>
                    <td>
                        <input type="text" class="form-control" 
                               name="waterConnectionId[${i}][id]">
                    </td>
                    <td>
                        <select class="form-select form-select-sm" name="waterConnectionId[${i}][connectionType]">
                            <option value="">Water Connection Type</option>
                            <?php $__currentLoopData = $allInOne['propertyType']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usageType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($usageType->id); ?>"><?php echo e($usageType->type_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </td>
                </tr>`;
            tbody.insertAdjacentHTML("beforeend", row);
        }
    });
});
</script>
<script>
    const propertyTypes = <?php echo json_encode($allInOne['propertyType'], 15, 512) ?>;
</script>


<script>
$(document).ready(function () {

    $("#propertyType").on("change", function () {
        let propertyTypeId = $(this).val();

        if (propertyTypeId === "") {
            $("#propertyUse").html('<option value="">Select Property Use</option>');
            return;
        }

        $.ajax({
            url: "/get-property-use/" + propertyTypeId,
            type: "GET",
            success: function (response) {
                $("#propertyUse").empty();
                $("#propertyUse").append('<option value="">Select Property Use</option>');

                if (response.status && response.data.length > 0) {
                    $.each(response.data, function (index, item) {
                        $("#propertyUse").append(
                            `<option value="${item.id}">${item.name}</option>`
                        );
                    });
                } else {
                    $("#propertyUse").append('<option value="">No Data Found</option>');
                }
            },
            error: function () {
                alert("Something went wrong!");
            }
        });
    });

});
</script>





<!--<script>-->
<!--    document.addEventListener('DOMContentLoaded', function () {-->
<!--        const waterSupplySelect = document.getElementById('isMunicipalWaterSupply');-->
<!--        const waterDetails = document.getElementById('municipalWaterDetails');-->

<!--        const sourceSelect = document.getElementById('sourceOfWater');-->
<!--        const sourceOtherField = document.getElementById('sourceOfWaterOtherField');-->

        // Show/hide Municipal Water fields
<!--        waterSupplySelect.addEventListener('change', function () {-->
<!--            if (this.value === 'yes') {-->
<!--                waterDetails.style.display = 'block';-->
<!--            } else {-->
<!--                waterDetails.style.display = 'none';-->
<!--            }-->
<!--        });-->

        // Show/hide Source of Water "Other" input
<!--        sourceSelect.addEventListener('change', function () {-->
<!--            sourceOtherField.style.display = (this.value === 'Other') ? 'block' : 'none';-->
<!--        });-->

        // Handle dynamic 'Other' in Water Connection Type rows
<!--        document.querySelectorAll('.water-connection-type').forEach(select => {-->
<!--            select.addEventListener('change', function () {-->
<!--                const otherInput = this.closest('td').querySelector('.water-connection-type-other');-->
<!--                otherInput.style.display = (this.value === 'Other') ? 'block' : 'none';-->
<!--            });-->
<!--        });-->
<!--    });-->

<!--    function totalWaterConn(input) {-->
        // You can implement dynamic row addition here if needed
        // For now, this is a placeholder
<!--        console.log('Total connections:', input.value);-->
<!--    }-->
<!--</script>-->


<?php $__env->stopSection(); ?>
 
<?php echo $__env->make('admin.layouts.adminApp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/npgovardhan25/public_html/resources/views/admin/property-surveyors/edit.blade.php ENDPATH**/ ?>