<!doctype html>
<html lang="en" class="semi-dark">
<!--semi-dark-->

<head>
     <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Property Details - Nagar Panchayat Govardhan">
    <meta name="author" content="Nagar Panchayat Govardhan">
    <meta name="robots" content="index, follow">
    <meta property="og:title" content="Property Details - Nagar Panchayat Govardhan">
    <meta property="og:description" content="Detailed property information including location, area, owner details, and construction details."/>
    <meta property="og:image" content="<?php echo e(asset('admin/assets/up.png')); ?>"> <!-- Replace with a valid image URL -->
    <meta property="og:url" content="current_page_url"> <!-- Replace with the current page URL -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Property Details - Nagar Panchayat Govardhan">
    <meta name="twitter:description" content="Detailed property information including location, area, owner details, and construction details.">
    <meta name="twitter:image" content="<?php echo e(asset('admin/assets/up.png')); ?>"> <!-- Replace with a valid image URL -->
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(asset('admin/assets/up.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('admin/assets/up.png')); ?>" type="image/png"> <!-- For PNG format -->
    <link rel="apple-touch-icon" href="<?php echo e(asset('admin/assets/up.png')); ?>">

    <!-- Add this for CSRF token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <!--plugins-->
    <link href="<?php echo e(asset('admin/assets/plugins/simplebar/css/simplebar.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('admin/assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('admin/assets/plugins/metismenu/css/metisMenu.min.css')); ?>" rel="stylesheet" />
    <!-- loader-->
    <link href="<?php echo e(asset('admin/assets/css/pace.min.css')); ?>" rel="stylesheet" />

    <!-- Bootstrap CSS -->
    <link href="<?php echo e(asset('admin/assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('admin/assets/css/bootstrap-extended.css')); ?>" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="<?php echo e(asset('admin/assets/css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('admin/assets/css/icons.css')); ?>" rel="stylesheet">
    <!-- Theme Style CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/css/dark-theme.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/css/semi-dark.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/css/header-colors.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" />
    <!-- lightGallery CSS -->
    <link href="https://cdn.jsdelivr.net/npm/lightgallery@2.7.1/css/lightgallery-bundle.min.css" rel="stylesheet" />

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
    <link rel="stylesheet"
        href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <?php echo $__env->yieldContent('style'); ?>
    <title>Property Survey - Nagar Panchayat Govardhan </title>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />

    <style>
        .menu-label {
    padding: 8px 20px;
    font-weight: bold;
    font-size: 12px;
    color: #6c757d; /* greyish color */
    text-transform: uppercase;
    letter-spacing: 0.05em;
    background-color: #f8f9fa; /* light background if needed */
    cursor: default;
    pointer-events: none;
}


    </style>
</head>

<body>
    <!--wrapper-->
    <div class="wrapper">
        <!--sidebar wrapper -->
        <div class="sidebar-wrapper" data-simplebar="true">
            <div class="sidebar-header">
                <div> <img src="<?php echo e(asset('admin/assets/up.png')); ?>" class="logo-icon" alt="logo icon"> </div>
                <div>
                    <h4 class="logo-text"> PS Admin </h4>
                </div>
                <div class="toggle-icon ms-auto"><i class='bx bx-arrow-back'></i> </div>
            </div>
            <!--navigation-->
            <ul class="metismenu" id="menu">
                <li>
                    <a href="<?php echo e(route('gis.dashboard')); ?>">
                        <div class="parent-icon"><i class='bx bx-home-alt'></i> </div>
                        <div class="menu-title">Dashboard</div>
                    </a>
                </li> 
            <?php if(has_permission(['GIS'], 'index')): ?>
                <?php if(has_permission(['Users', 'Roles'], 'index')): ?>
                    <li>
                        <a class="has-arrow" href="javascript:;">
                            <div class="parent-icon"><i class='bx bx-user-pin'></i> </div>
                            <div class="menu-title"> User's</div>
                        </a>
                        <ul>
                            <?php if(has_permission(['Users'], 'index')): ?>
                                <li> <a href="<?php echo e(route('gis.user.index')); ?>"><i class='bx bx-radio-circle'></i> User
                                        List</a> </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Roles'], 'index')): ?>
                                <li> <a href="<?php echo e(route('gis.roles.index')); ?>"><i class='bx bx-radio-circle'></i> Role
                                        List</a> </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>
                

                <?php if(has_permission(['Properties', 'Property-Photo'], 'index')): ?>
                    <li>
                        <a class="has-arrow" href="javascript:;">
                            <div class="parent-icon"><i class='bx bx-location-plus'></i> </div>
                            <div class="menu-title"> Property Survey </div>
                        </a>
                        <ul>
                                <?php if(has_permission(['Properties'], 'index')): ?>
                                <li> <a href="<?php echo e(route('gis.property.index')); ?>"><i class='bx bx-radio-circle'></i>
                                        All Survey List</a> </li>
                                <?php endif; ?>
                                <?php if(has_permission(['Properties'], 'in-progress')): ?>
                                    <li> <a href="<?php echo e(route('gis.property.index')); ?>?filter=0"><i class='bx bx-radio-circle'></i>
                                            In-progress Survey List</a> </li>
                                <?php endif; ?>
                                <?php if(has_permission(['Properties'], 'QC-Level-1')): ?>
                                    <li> <a href="<?php echo e(route('gis.property.index')); ?>?filter=1"><i class='bx bx-radio-circle'></i>
                                            QC Level 1 Survey List</a> </li>
                                <?php endif; ?>
                                <?php if(has_permission(['Properties'], 'QC-Level-2')): ?>
                                    <li> <a href="<?php echo e(route('gis.property.index')); ?>?filter=2"><i class='bx bx-radio-circle'></i>
                                            QC Level 2 Survey List</a> </li>
                                <?php endif; ?>
                                <?php if(has_permission(['Properties'], 'QC-Done')): ?>
                                    <li> <a href="<?php echo e(route('gis.property.index')); ?>?filter=3"><i class='bx bx-radio-circle'></i>
                                            QC Done Survey List</a> </li>
                                <?php endif; ?>
                                <?php if(has_permission(['Properties'], 'index')): ?>
                                    <li> <a href="<?php echo e(route('gis.property.index')); ?>?filter=4"><i class='bx bx-radio-circle'></i>
                                            Completed Survey List</a> </li>
                                <?php endif; ?>
                                <?php if(has_permission(['Properties'], 'index')): ?>
                                    <li> <a href="<?php echo e(route('gis.properties.report')); ?>"><i class='bx bx-radio-circle'></i>
                                            All Survey Report List</a> </li>
                                <?php endif; ?>
                                <?php if(has_permission(['Property-Photo'], 'index')): ?>
                                    <li> <a href="<?php echo e(route('gis.propertyPhoto.index')); ?>"><i
                                                class='bx bx-radio-circle'></i> Survey Photo Update</a> </li>
                                <?php endif; ?>
                                <?php if(has_permission(['Property-Photo'], 'index')): ?>
                                <li> <a href="<?php echo e(route('mis.cash-desk-search')); ?>"><i class='bx bx-radio-circle'></i> Cash Desk</a> </li>
                                <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                <?php if(has_permission(['Wards','Relationship-with-Owners','Tax-Rate-Zone','Ownership-Type','Ownership-Type','Ownership-Type','Situations','Property-Type','Property-Uses','Year-of-Constructions','Floor-Usage-Type','Floor-Types','Usags-Factor','Nature-of-Construction'], 'index')): ?>
                    <li>
                        <a class="has-arrow" href="javascript:;">
                            <div class="parent-icon"><i class='bx bx-grid-alt'></i> </div>
                            <div class="menu-title">App Master </div>
                        </a>
                        <ul>
                            <?php if(has_permission(['Wards'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.wards.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Ward List
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Relationship-with-Owners'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.relationship-with-owners.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Relationship With Owners
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Tax-Rate-Zone'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.taxrate.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Tax Rate Zone
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Ownership-Type'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.ownership.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Ownership Type
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Situations'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.situations.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Situations
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Property-Type'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.propertyuse.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Property Type
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Property-Uses'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.propertyuse.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Property Uses
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Commercial-Uses'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.propertcommercial.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Commercial Uses
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Year-of-Constructions'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.propertyyear.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Year of Constructions
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Exemption-Applicable'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.exemption.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Exemption Applicables
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Floor-Usage-Type'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.propertytype.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Floor Usage Type
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Floor-Types'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.flortype.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Floor Type
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Usags-Factor'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.usagsFactor.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Usags Factor
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission(['Nature-of-Construction'], 'index')): ?>
                                <li>
                                    <a href="<?php echo e(route('gis.natureof.index')); ?>">
                                        <i class='bx bx-radio-circle'></i> Nature of Construction
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>
            <?php endif; ?>
            
            <?php if(has_permission(['MIS'], 'index')): ?>
                
                <li class="menu-label"><i class="bx bx-minus"></i> MIS</li>
                <?php if(has_permission(['Ward-Members'], 'index')): ?>
                <li>
                    <a href="<?php echo e(route('mis.wardmember.index')); ?>">
                        <div class="parent-icon"><i class='bx bx-group'></i> </div>
                        <div class="menu-title">Ward-Members</div>
                    </a>
                </li>    
                <?php endif; ?>
                <?php if(has_permission(['Slider','Notice-Boards','Office-Bearers'], 'index')): ?> 
                <li>
                    <a class="has-arrow" href="javascript:;">
                        <div class="parent-icon"><i class='bx bx-home-alt'></i> </div>
                        <div class="menu-title"> Home Page </div>
                    </a>
                    <ul>

                        <li> <a href="<?php echo e(route('mis.slider.index')); ?>"><i class='bx bx-radio-circle'></i> Slider</a> </li>
                        <li> <a href="<?php echo e(route('mis.noticeboard.index')); ?>"><i class='bx bx-radio-circle'></i> Notice Board</a> </li> 
                        <li> <a href="<?php echo e(route('mis.officebeares.index')); ?>"><i class='bx bx-radio-circle'></i> Office Beares</a> </li> 
                        <li> <a href="<?php echo e(route('mis.web-page-about.index')); ?>"><i class='bx bx-radio-circle'></i> About</a> </li>
                        <li> <a href="<?php echo e(route('mis.web-page-service.index')); ?>"><i class='bx bx-radio-circle'></i> Our Services</a> </li>
                        <li> <a href="<?php echo e(route('mis.public-grievance.index')); ?>"><i class='bx bx-radio-circle'></i> Public Grievance</a> </li>
                        <li> <a href="<?php echo e(route('mis.government-scheme.index')); ?>"><i class='bx bx-radio-circle'></i> Government Schemes</a> </li>
                        <li> <a href="<?php echo e(route('mis.web-gallery.index')); ?>"><i class='bx bx-radio-circle'></i> Photo / Media Gallery</a> </li>
                        
                    </ul>
                </li>
                
                <?php endif; ?>
                <?php if(has_permission(['President','Executive-Officer','Member-List','Staff-Details'], 'index')): ?>
                
                <li>
                    <a class="has-arrow" href="javascript:;">
                        <div class="parent-icon"><i class='bx bx-briefcase'></i> </div>
                        <div class="menu-title">Department</div>
                    </a>
                    <ul> 
                        <?php if(has_permission(['President'], 'index')): ?>
                        <li> <a href="<?php echo e(route('mis.president.index')); ?>"><i class='bx bx-radio-circle'></i> President List</a></li>
                        <?php endif; ?>
                        <?php if(has_permission(['Executive-Officer'], 'index')): ?> 
                        <li> <a href="<?php echo e(route('mis.executive.index')); ?>"><i class='bx bx-radio-circle'></i> Executive Officer List</a></li>
                        <?php endif; ?>
                        <?php if(has_permission(['Member-List'], 'index')): ?>
                        <li> <a href="<?php echo e(route('mis.member.index')); ?>"><i class='bx bx-radio-circle'></i> Member List</a></li>
                        <?php endif; ?>
                        <?php if(has_permission(['Staff-Details'], 'index')): ?>
                        <li> <a href="<?php echo e(route('mis.staffdata.index')); ?>"><i class='bx bx-radio-circle'></i> Staff Details</a></li>
                        <?php endif; ?> 
                    </ul>
                </li>
                <?php endif; ?>
                <?php if(has_permission(['Right-to-Information-Act','Citizen-Charter'], 'index')): ?>
                
                <li>
                    <a class="has-arrow" href="javascript:;">
                        <div class="parent-icon"><i class='bx bx-news'></i> </div>
                        <div class="menu-title">Right to Information</div>
                    </a>
                    <ul>
                        <?php if(has_permission(['Right-to-Information-Act'], 'index')): ?>
                        <li> <a href="<?php echo e(route('mis.soochna.index')); ?>"><i class='bx bx-radio-circle'></i> Right to Information Act</a></li>
                        <?php endif; ?>
                        <?php if(has_permission(['Citizen-Charter'], 'index')): ?>
                        <li> <a href="<?php echo e(route('mis.citizencharter.index')); ?>"><i class='bx bx-radio-circle'></i> Citizen Charter</a></li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
                <?php if(has_permission(['Site-Settings'], 'index')): ?>
                
                <li>
                    <a href="<?php echo e(route('mis.sitesetting.index')); ?>">
                        <div class="parent-icon"><i class='bx bx-wrench'></i> </div>
                        <div class="menu-title">Site Settings</div>
                    </a>
                </li>
                <?php endif; ?>
            <?php endif; ?>





            </ul>
            <!--end navigation-->
        </div>
        <!--end sidebar wrapper -->
        <!--start header -->
        <header>
            <div class="topbar d-flex align-items-center">
                <nav class="navbar navbar-expand gap-3">

                    <div class="mobile-toggle-menu"><i class="bx bx-menu"></i> </div>
                    <div class="position-relative search-bar d-lg-block d-none" data-bs-toggle="modal"
                        data-bs-target="#SearchModal">
                        <input class="form-control px-5" disabled type="search" placeholder="Survey Property Admin">
                        <span
                            class="position-absolute top-50 search-show ms-3 translate-middle-y start-0 top-50 fs-5"><i
                                class='bx bx-search'></i></span>
                    </div>


                    <div class="top-menu ms-auto">
                        <ul class="navbar-nav align-items-center gap-1">
                            <li class="nav-item dropdown dropdown-large">
                                <div class="header-notifications-list"> </div>
                                <div class="header-message-list"> </div>
                            </li>
                        </ul>
                    </div>



                    <div class="user-box dropdown px-3">
                        <a class="d-flex align-items-center nav-link dropdown-toggle gap-3 dropdown-toggle-nocaret" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="<?php echo e(asset('admin/assets/up.png')); ?>" class="user-img" alt="user avatar">
                            <div class="user-info">
                                <p class="user-name mb-0"> <?php echo e(Auth::user()->name ?? 'Demo'); ?> </p>
                                <p class="designattion mb-0"> <?php echo e(Auth::user()->role->name ?? ''); ?>  </p>
                            </div>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">

                            <li>
                                <div class="dropdown-divider mb-0"></div>
                            </li>
                            <li><a class="dropdown-item d-flex align-items-center" href=""
                                    onclick="event.preventDefault();document.getElementById('logout-form').submit();">
                                    <i class="bx bx-log-out-circle"></i><span> <?php echo e(__('Logout')); ?> </span></a>
                            </li>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none"> <?php echo csrf_field(); ?> </form>
                        </ul>
                    </div>
                </nav>
                 <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
                <?php endif; ?>
            </div>
        </header>
        <!--end header -->
        <!--start page wrapper -->

        <?php echo $__env->yieldContent('content'); ?>
        <!--end page wrapper -->
        <!--start overlay-->
        <div class="overlay toggle-icon"></div>
        <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
        <footer class="page-footer">
            <p class="mb-0">Copyright © 2025. Nagar Panchayat Milak. | All right reserved.</p>
        </footer>
    </div>

    <!-- Bootstrap JS -->
    <script src="<?php echo e(asset('admin/assets/js/bootstrap.bundle.min.js')); ?>"></script>
    <!--plugins-->
    <script src="<?php echo e(asset('admin/assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/plugins/metismenu/js/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
        <script src="<?php echo e(asset('admin/assets/js/pace.min.js')); ?>"></script>
    <!--app JS-->
    <script src="<?php echo e(asset('admin/assets/js/app.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="<?php echo e(asset('admin/assets/plugins/select2/js/select2-custom.js')); ?>"></script>

    <script src="<?php echo e(asset('admin/assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <!-- lightGallery JS -->
<script src="https://cdn.jsdelivr.net/npm/lightgallery@2.7.1/lightgallery.umd.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/lightgallery@2.7.1/plugins/zoom/lg-zoom.umd.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/lightgallery@2.7.1/plugins/thumbnail/lg-thumbnail.umd.min.js"></script>

    <?php echo $__env->yieldContent('script'); ?>
    <script>
        $(document).ready(function() {
            $('#example').DataTable();
        });
    </script>
    <script>
        $(document).ready(function() {
            var table = $('#example2').DataTable({
                lengthChange: false,
                buttons: ['copy', 'excel', 'pdf', 'print']
            });

            table.buttons().container()
                .appendTo('#example2_wrapper .col-md-6:eq(0)');
        });
    </script>

    <script>
                
    document.addEventListener('DOMContentLoaded', function() {
        lightGallery(document.querySelectorAll('.lightgallery-item'), {
            plugins: [lgZoom, lgThumbnail],
            speed: 500,
        });
    });
    
     function calculateRate(constructionType, usageType, usageFactor, taxRateZone,nagarpalikaId='') 
        {
            
            // console.log('nagarpalikaId:', nagarpalikaId);
            // console.log('constructionType:', constructionType);
            // console.log('usageType:', usageType);
            // console.log('usageFactor:', usageFactor);
            // console.log('taxRateZone:', taxRateZone);
        
           const rates = {
                        1: [
                            { zones: [1], rate1: 0.60, },
                            { zones: [2], rate1: 0.75, },
                            { zones: [3], rate1: 0.90, },
                            { zones: [6], rate1: 1.10, },
                        ],
                        2: [
                            { zones: [1], rate1: 0.50, },
                            { zones: [2], rate1: 0.60, },
                            { zones: [3], rate1: 0.80, },
                            { zones: [6], rate1: 0.90, },
                        ],
                        3: [
                            { zones: [1], rate1: 0.40, },
                            { zones: [2], rate1: 0.50, },
                            { zones: [3], rate1: 0.60, },
                            { zones: [6], rate1: 0.75, },
                        ],
                        4: [
                            { zones: [1], rate1: 0.50, },
                            { zones: [2], rate1: 0.60, },
                            { zones: [3], rate1: 0.80, },
                            { zones: [6], rate1: 0.90, }
                        ],
                        5: [
                            { zones: [1], rate1: 0.30, },
                            { zones: [2], rate1: 0.40, },
                            { zones: [3], rate1: 0.50, },
                            { zones: [6], rate1: 0.60, },
                        ],
                         
                    };
        
            let baseRate = 0;
        
            // Convert to lowercase key if it's "Other"
            const key = rates.hasOwnProperty(constructionType) ? constructionType : 1;
        
            for (const rateZone of rates[key]) 
            {
                if (rateZone.zones.includes(Number(taxRateZone))) 
                {
                    if ([2,4].includes(Number(usageType)))   
                    {
                        baseRate =  rateZone.rate1 * 2 ; 
                    }
                    else
                    {
                        baseRate = rateZone.rate1;
                    } 
                    break;
                }
            }
            return parseFloat(baseRate.toFixed(2));
        }

     
    
    </script>
</body>

</html>
<?php /**PATH /home/npgovardhan25/public_html/resources/views/admin/layouts/adminApp.blade.php ENDPATH**/ ?>